/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.EmptyMessageBundle;
import com.google.javascript.jscomp.Instrumentation;
import com.google.javascript.jscomp.JqueryCodingConvention;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.WhitelistWarningsGuard;
import com.google.javascript.jscomp.XtbMessageBundle;
import com.google.javascript.rhino.TokenStream;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.OptionHandlerFilter;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.StringOptionHandler;

@GwtIncompatible(value="Unnecessary")
public class CommandLineRunner
extends AbstractCommandLineRunner<Compiler, CompilerOptions> {
    public static final String OUTPUT_MARKER = "%output%";
    public static final int UTF8_BOM_CODE = 65279;
    private static final Pattern extraModuleNameChars = Pattern.compile("[-.]+");
    private final Flags flags = new Flags();
    private boolean errors = false;
    private boolean runCompiler = false;
    private PrintStream errorStream;

    protected CommandLineRunner(String[] args) {
        this.initConfigFromFlags(args, System.out, System.err);
    }

    protected CommandLineRunner(String[] args, PrintStream out, PrintStream err) {
        super(out, err);
        this.initConfigFromFlags(args, out, err);
    }

    protected CommandLineRunner(String[] args, InputStream in, PrintStream out, PrintStream err) {
        super(in, out, err);
        this.initConfigFromFlags(args, out, err);
    }

    private static List<String> processArgs(String[] args) {
        Pattern argPattern = Pattern.compile("(--?[a-zA-Z_]+)=(.*)");
        Pattern quotesPattern = Pattern.compile("^['\"](.*)['\"]$");
        ArrayList<String> processedArgs = new ArrayList<String>();
        for (String arg : args) {
            Matcher matcher = argPattern.matcher(arg);
            if (matcher.matches()) {
                processedArgs.add(matcher.group(1));
                String value = matcher.group(2);
                Matcher quotesMatcher = quotesPattern.matcher(value);
                if (quotesMatcher.matches()) {
                    processedArgs.add(quotesMatcher.group(1));
                    continue;
                }
                processedArgs.add(value);
                continue;
            }
            processedArgs.add(arg);
        }
        return processedArgs;
    }

    private void reportError(String message) {
        this.errors = true;
        this.errorStream.println(message);
        this.errorStream.flush();
    }

    private void processFlagFile() throws CmdLineException, IOException {
        int c;
        Path flagFile = Paths.get(this.flags.flagFile, new String[0]);
        BufferedReader buffer = Files.newBufferedReader(flagFile, StandardCharsets.UTF_8);
        StringBuilder builder = new StringBuilder();
        List<String> tokens = new ArrayList<String>();
        boolean quoted = false;
        boolean escaped = false;
        boolean isFirstCharacter = true;
        while ((c = buffer.read()) != -1) {
            if (isFirstCharacter) {
                isFirstCharacter = false;
                if (c == 65279) continue;
            }
            if (c == 32 || c == 9 || c == 10 || c == 13) {
                if (quoted) {
                    builder.append((char)c);
                } else if (builder.length() != 0) {
                    tokens.add(builder.toString());
                    builder.setLength(0);
                }
            } else if (c == 34) {
                if (escaped) {
                    if (quoted) {
                        builder.setCharAt(builder.length() - 1, (char)c);
                    } else {
                        builder.append((char)c);
                    }
                } else {
                    quoted = !quoted;
                }
            } else {
                builder.append((char)c);
            }
            escaped = c == 92;
        }
        buffer.close();
        if (builder.length() != 0) {
            tokens.add(builder.toString());
        }
        this.flags.flagFile = "";
        tokens = CommandLineRunner.processArgs(tokens.toArray(new String[0]));
        ArrayList previousGuardLevels = new ArrayList(Flags.guardLevels);
        ArrayList previousMixedJsSources = new ArrayList(Flags.mixedJsSources);
        Flags.guardLevels.clear();
        Flags.mixedJsSources.clear();
        this.flags.parse(tokens);
        Flags.guardLevels.addAll(previousGuardLevels);
        Flags.mixedJsSources.addAll(previousMixedJsSources);
        if (!this.flags.flagFile.isEmpty()) {
            this.reportError("ERROR - Arguments in the file cannot contain --flagfile option.");
        }
    }

    private void initConfigFromFlags(String[] args, PrintStream out, PrintStream err) {
        this.errorStream = err;
        List<String> processedArgs = CommandLineRunner.processArgs(args);
        Flags.guardLevels.clear();
        Flags.mixedJsSources.clear();
        List<String> jsFiles = null;
        List<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>> mixedSources = null;
        List<SourceMap.LocationMapping> mappings = null;
        ImmutableMap<String, String> sourceMapInputs = null;
        try {
            this.flags.parse(processedArgs);
            if (!this.flags.flagFile.isEmpty()) {
                this.processFlagFile();
            }
            jsFiles = this.flags.getJsFiles();
            mixedSources = this.flags.getMixedJsSources();
            mappings = this.flags.getSourceMapLocationMappings();
            sourceMapInputs = this.flags.getSourceMapInputs();
        }
        catch (CmdLineException e) {
            this.reportError(e.getMessage());
        }
        catch (IOException ioErr) {
            this.reportError("ERROR - " + this.flags.flagFile + " read error.");
        }
        ArrayList<ModuleIdentifier> entryPoints = new ArrayList<ModuleIdentifier>();
        if (this.flags.processCommonJsModules) {
            this.flags.processClosurePrimitives = true;
            if (this.flags.commonJsEntryModule != null) {
                if (this.flags.entryPoints.isEmpty()) {
                    entryPoints.add(ModuleIdentifier.forFile(this.flags.commonJsEntryModule));
                } else {
                    this.reportError("--common_js_entry_module cannot be used with --entry_point.");
                }
            }
        }
        if (this.flags.outputWrapperFile != null && !this.flags.outputWrapperFile.isEmpty()) {
            this.flags.outputWrapper = "";
            try {
                this.flags.outputWrapper = com.google.common.io.Files.toString((File)new File(this.flags.outputWrapperFile), (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                this.reportError("ERROR - invalid output_wrapper_file specified.");
            }
        }
        if (this.flags.outputWrapper != null && !this.flags.outputWrapper.isEmpty() && !this.flags.outputWrapper.contains(OUTPUT_MARKER)) {
            this.reportError("ERROR - invalid output_wrapper specified. Missing '%output%'.");
        }
        if (this.errors) {
            this.flags.printShortUsageAfterErrors(this.errorStream);
        } else if (this.flags.displayHelp) {
            this.flags.printUsage(out);
        } else if (this.flags.version) {
            out.println("Closure Compiler (http://github.com/google/closure-compiler)\nVersion: " + Compiler.getReleaseVersion() + "\n" + "Built on: " + Compiler.getReleaseDate());
            out.flush();
        } else {
            this.runCompiler = true;
            CodingConvention conv = this.flags.thirdParty ? CodingConventions.getDefault() : (this.flags.processJqueryPrimitives ? new JqueryCodingConvention() : new ClosureCodingConvention());
            ArrayList<String> moduleRoots = new ArrayList<String>();
            if (!this.flags.moduleRoot.isEmpty()) {
                moduleRoots.addAll(this.flags.moduleRoot);
                if (!this.flags.commonJsPathPrefix.isEmpty()) {
                    this.reportError("--commonJsPathPrefix cannot be used with --js_module_root.");
                }
            } else if (this.flags.commonJsPathPrefix != null) {
                moduleRoots.addAll(this.flags.commonJsPathPrefix);
            } else {
                moduleRoots.add("./");
            }
            for (String entryPoint : this.flags.entryPoints) {
                if (entryPoint.startsWith("goog:")) {
                    entryPoints.add(ModuleIdentifier.forClosure(entryPoint));
                    continue;
                }
                entryPoints.add(ModuleIdentifier.forFile(entryPoint));
            }
            if (this.flags.dependencyMode == CompilerOptions.DependencyMode.STRICT && entryPoints.isEmpty()) {
                this.reportError("When --dependency_mode=STRICT, you must specify at least one --entry_point.");
            }
            CompilerOptions.DependencyMode depMode = this.flags.dependencyMode;
            if (this.flags.onlyClosureDependencies || this.flags.manageClosureDependencies) {
                if (this.flags.dependencyMode != CompilerOptions.DependencyMode.NONE) {
                    this.reportError((this.flags.onlyClosureDependencies ? "--only_closure_dependencies" : "--manage_closure_dependencies") + " cannot be used with --dependency_mode.");
                } else {
                    if (this.flags.manageClosureDependencies) {
                        depMode = CompilerOptions.DependencyMode.LOOSE;
                    } else if (this.flags.onlyClosureDependencies) {
                        depMode = CompilerOptions.DependencyMode.STRICT;
                    }
                    if (!this.flags.closureEntryPoint.isEmpty() && !this.flags.entryPoints.isEmpty()) {
                        this.reportError("--closure_entry_point cannot be used with --entry_point.");
                    } else {
                        for (String entryPoint : this.flags.closureEntryPoint) {
                            entryPoints.add(ModuleIdentifier.forClosure(entryPoint));
                        }
                    }
                }
            }
            this.getCommandLineConfig().setPrintTree(this.flags.printTree).setPrintAst(this.flags.printAst).setPrintPassGraph(this.flags.printPassGraph).setJscompDevMode(this.flags.jscompDevMode).setLoggingLevel(this.flags.loggingLevel).setExterns(this.flags.externs).setJs(jsFiles).setJsZip(this.flags.jszip).setMixedJsSources(mixedSources).setJsOutputFile(this.flags.jsOutputFile).setModule(this.flags.module).setVariableMapOutputFile(this.flags.variableMapOutputFile).setCreateNameMapFiles(this.flags.createNameMapFiles).setPropertyMapOutputFile(this.flags.propertyMapOutputFile).setCodingConvention(conv).setSummaryDetailLevel(this.flags.summaryDetailLevel).setOutputWrapper(this.flags.outputWrapper).setModuleWrapper(this.flags.moduleWrapper).setModuleOutputPathPrefix(this.flags.moduleOutputPathPrefix).setCreateSourceMap(this.flags.createSourceMap).setSourceMapFormat(this.flags.sourceMapFormat).setSourceMapLocationMappings(mappings).setSourceMapInputFiles((Map<String, String>)sourceMapInputs).setWarningGuards(Flags.guardLevels).setDefine(this.flags.define).setCharset(this.flags.charset).setDependencyMode(depMode).setEntryPoints(entryPoints).setOutputManifest((List<String>)ImmutableList.of((Object)this.flags.outputManifest)).setOutputModuleDependencies(this.flags.outputModuleDependencies).setProcessCommonJSModules(this.flags.processCommonJsModules).setModuleRoots(moduleRoots).setTransformAMDToCJSModules(this.flags.transformAmdModules).setWarningsWhitelistFile(this.flags.warningsWhitelistFile).setHideWarningsFor(this.flags.hideWarningsFor).setAngularPass(this.flags.angularPass).setTracerMode(this.flags.tracerMode).setInstrumentationTemplateFile(this.flags.instrumentationFile).setNewTypeInference(this.flags.useNewTypeInference).setJsonStreamMode(this.flags.jsonStreamMode).setPrintSourceAfterEachPass(this.flags.printSourceAfterEachPass);
        }
        this.errorStream = null;
    }

    @Override
    protected void addWhitelistWarningsGuard(CompilerOptions options, File whitelistFile) {
        options.addWarningsGuard(WhitelistWarningsGuard.fromFile(whitelistFile));
    }

    @Override
    protected void checkModuleName(String name) {
        if (!TokenStream.isJSIdentifier(extraModuleNameChars.matcher(name).replaceAll("_"))) {
            throw new AbstractCommandLineRunner.FlagUsageException("Invalid module name: '" + name + "'");
        }
    }

    @Override
    protected CompilerOptions createOptions() {
        CompilerOptions.LanguageMode languageMode;
        CompilerOptions options = new CompilerOptions();
        if (!this.flags.languageIn.isEmpty()) {
            languageMode = CompilerOptions.LanguageMode.fromString(this.flags.languageIn);
            if (languageMode != null) {
                options.setLanguageIn(languageMode);
            } else {
                throw new AbstractCommandLineRunner.FlagUsageException("Unknown language `" + this.flags.languageIn + "' specified.");
            }
        }
        if (this.flags.languageOut.isEmpty()) {
            options.setLanguageOut(options.getLanguageIn());
        } else {
            languageMode = CompilerOptions.LanguageMode.fromString(this.flags.languageOut);
            if (languageMode != null) {
                options.setLanguageOut(languageMode);
            } else {
                throw new AbstractCommandLineRunner.FlagUsageException("Unknown language `" + this.flags.languageOut + "' specified.");
            }
        }
        if (this.flags.processJqueryPrimitives) {
            options.setCodingConvention(new JqueryCodingConvention());
        } else {
            options.setCodingConvention(new ClosureCodingConvention());
        }
        options.setExtraAnnotationNames(this.flags.extraAnnotationName);
        CompilationLevel level = this.flags.compilationLevelParsed;
        level.setOptionsForCompilationLevel(options);
        if (this.flags.debug) {
            level.setDebugOptionsForCompilationLevel(options);
        }
        options.setEnvironment(this.flags.environment);
        options.setChecksOnly(this.flags.checksOnly);
        if (this.flags.useTypesForOptimization) {
            level.setTypeBasedOptimizationOptions(options);
        }
        if (this.flags.assumeFunctionWrapper) {
            level.setWrappedOutputOptimizations(options);
        }
        if (this.flags.generateExports) {
            options.setGenerateExports(this.flags.generateExports);
        }
        if (this.flags.exportLocalPropertyDefinitions) {
            options.setExportLocalPropertyDefinitions(true);
        }
        WarningLevel wLevel = this.flags.warningLevel;
        wLevel.setOptionsForWarningLevel(options);
        for (FormattingOption formattingOption : this.flags.formatting) {
            formattingOption.applyToOptions(options);
        }
        options.closurePass = this.flags.processClosurePrimitives;
        options.jqueryPass = CompilationLevel.ADVANCED_OPTIMIZATIONS == level && this.flags.processJqueryPrimitives;
        options.angularPass = this.flags.angularPass;
        options.polymerPass = this.flags.polymerPass;
        options.setDartPass(this.flags.dartPass);
        options.setJ2clPass(this.flags.j2clPass);
        options.renamePrefixNamespace = this.flags.renamePrefixNamespace;
        options.setPreserveTypeAnnotations(this.flags.preserveTypeAnnotations);
        options.setPreventLibraryInjection(this.flags.noinjectLibrary);
        options.rewritePolyfills = this.flags.rewritePolyfills;
        if (!this.flags.translationsFile.isEmpty()) {
            try {
                options.messageBundle = new XtbMessageBundle(new FileInputStream(this.flags.translationsFile), this.flags.translationsProject);
            }
            catch (IOException e) {
                throw new RuntimeException("Reading XTB file", e);
            }
        } else if (CompilationLevel.ADVANCED_OPTIMIZATIONS == level) {
            options.messageBundle = new EmptyMessageBundle();
            options.setWarningLevel(DiagnosticGroups.MSG_CONVENTIONS, CheckLevel.OFF);
        }
        options.setConformanceConfigs((List<ConformanceConfig>)this.loadConformanceConfigs(this.flags.conformanceConfigs));
        if (!this.flags.instrumentationFile.isEmpty()) {
            Instrumentation.Builder builder = Instrumentation.newBuilder();
            try (BufferedReader br = new BufferedReader(com.google.common.io.Files.newReader((File)new File(this.flags.instrumentationFile), (Charset)StandardCharsets.UTF_8));){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append(System.lineSeparator());
                    line = br.readLine();
                }
                String instrumentationPb = sb.toString();
                TextFormat.merge((CharSequence)instrumentationPb, (Message.Builder)builder);
                options.instrumentationTemplate = builder.build();
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading instrumentation template", e);
            }
        }
        return options;
    }

    @Override
    protected Compiler createCompiler() {
        return new Compiler(this.getErrorPrintStream());
    }

    @Override
    protected List<SourceFile> createExterns(CompilerOptions options) throws IOException {
        List<SourceFile> externs = super.createExterns(options);
        if (this.isInTestMode()) {
            return externs;
        }
        List<SourceFile> builtinExterns = CommandLineRunner.getBuiltinExterns(options.getEnvironment());
        builtinExterns.addAll(externs);
        return builtinExterns;
    }

    private ImmutableList<ConformanceConfig> loadConformanceConfigs(List<String> configPaths) {
        ImmutableList.Builder configs = ImmutableList.builder();
        for (String configPath : configPaths) {
            try {
                configs.add((Object)CommandLineRunner.loadConformanceConfig(configPath));
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading conformance config", e);
            }
        }
        return configs.build();
    }

    private static ConformanceConfig loadConformanceConfig(String configFile) throws IOException {
        String textProto = com.google.common.io.Files.toString((File)new File(configFile), (Charset)StandardCharsets.UTF_8);
        ConformanceConfig.Builder builder = ConformanceConfig.newBuilder();
        if (textProto.charAt(0) == '\ufeff') {
            textProto = textProto.substring(1);
        }
        try {
            TextFormat.merge((CharSequence)textProto, (Message.Builder)builder);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return builder.build();
    }

    @Deprecated
    public static List<SourceFile> getDefaultExterns() throws IOException {
        return CommandLineRunner.getBuiltinExterns(CompilerOptions.Environment.BROWSER);
    }

    public static List<String> findJsFiles(Collection<String> patterns) throws IOException {
        return CommandLineRunner.findJsFiles(patterns, false);
    }

    private static List<String> findJsFiles(Collection<String> patterns, boolean sortAlphabetically) throws IOException {
        TreeSet<String> allJsInputs = sortAlphabetically ? new TreeSet() : new LinkedHashSet();
        HashSet<String> excludes = new HashSet<String>();
        for (String pattern : patterns) {
            if (!pattern.contains("*") && !pattern.startsWith("!")) {
                File matchedFile = new File(pattern);
                if (matchedFile.isDirectory()) {
                    CommandLineRunner.matchPaths(new File(matchedFile, "**.js").toString(), allJsInputs, excludes);
                    continue;
                }
                String pathString = Paths.get(pattern, new String[0]).normalize().toString();
                if (excludes.contains(pathString)) continue;
                allJsInputs.add(pathString);
                continue;
            }
            CommandLineRunner.matchPaths(pattern, allJsInputs, excludes);
        }
        return new ArrayList<String>(allJsInputs);
    }

    private static void matchPaths(String pattern, final Set<String> allJsInputs, final Set<String> excludes) throws IOException {
        boolean remove;
        FileSystem fs = FileSystems.getDefault();
        boolean bl = remove = pattern.indexOf(33) == 0;
        if (remove) {
            pattern = pattern.substring(1);
        }
        String separator = File.separator.equals("\\") ? "\\\\" : File.separator;
        List patternParts = Splitter.on((String)File.separator).splitToList((CharSequence)pattern);
        String prefix = ".";
        for (int i = 0; i < patternParts.size(); ++i) {
            if (!((String)patternParts.get(i)).contains("*")) continue;
            if (i <= 0) break;
            prefix = Joiner.on((String)separator).join(patternParts.subList(0, i));
            pattern = Joiner.on((String)separator).join(patternParts.subList(i, patternParts.size()));
            break;
        }
        final PathMatcher matcher = fs.getPathMatcher("glob:" + prefix + separator + pattern);
        Files.walkFileTree(fs.getPath(prefix, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) {
                if (matcher.matches(p) || matcher.matches(p.normalize())) {
                    String pathString = p.normalize().toString();
                    if (remove) {
                        excludes.add(pathString);
                        allJsInputs.remove(pathString);
                    } else if (!excludes.contains(pathString)) {
                        allJsInputs.add(pathString);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public boolean shouldRunCompiler() {
        return this.runCompiler;
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public static void main(String[] args) {
        CommandLineRunner runner = new CommandLineRunner(args);
        if (runner.shouldRunCompiler()) {
            runner.run();
        }
        if (runner.hasErrors()) {
            System.exit(-1);
        }
    }

    private static enum FormattingOption {
        PRETTY_PRINT,
        PRINT_INPUT_DELIMITER,
        SINGLE_QUOTES;


        private void applyToOptions(CompilerOptions options) {
            switch (this) {
                case PRETTY_PRINT: {
                    options.prettyPrint = true;
                    break;
                }
                case PRINT_INPUT_DELIMITER: {
                    options.printInputDelimiter = true;
                    break;
                }
                case SINGLE_QUOTES: {
                    options.setPreferSingleQuotes(true);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown formatting option: " + (Object)((Object)this));
                }
            }
        }
    }

    private static class Flags {
        private static List<AbstractCommandLineRunner.FlagEntry<CheckLevel>> guardLevels = Collections.synchronizedList(new ArrayList());
        private static List<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>> mixedJsSources = Collections.synchronizedList(new ArrayList());
        @Option(name="--help", handler=BooleanOptionHandler.class, usage="Displays this message on stdout and exit")
        private boolean displayHelp = false;
        @Option(name="--print_tree", hidden=true, handler=BooleanOptionHandler.class, usage="Prints out the parse tree and exits")
        private boolean printTree = false;
        @Option(name="--print_ast", hidden=true, handler=BooleanOptionHandler.class, usage="Prints a dot file describing the internal abstract syntax tree and exits")
        private boolean printAst = false;
        @Option(name="--print_pass_graph", hidden=true, handler=BooleanOptionHandler.class, usage="Prints a dot file describing the passes that will get run and exits")
        private boolean printPassGraph = false;
        @Option(name="--jscomp_dev_mode", aliases={"--dev_mode"})
        private CompilerOptions.DevMode jscompDevMode = CompilerOptions.DevMode.OFF;
        @Option(name="--logging_level", hidden=true, usage="The logging level (standard java.util.logging.Level values) for Compiler progress. Does not control errors or warnings for the JavaScript code under compilation")
        private String loggingLevel = Level.WARNING.getName();
        @Option(name="--externs", usage="The file containing JavaScript externs. You may specify multiple")
        private List<String> externs = new ArrayList<String>();
        @Option(name="--js", handler=JsOptionHandler.class, usage="The JavaScript filename. You may specify multiple. The flag name is optional, because args are interpreted as files by default. You may also use minimatch-style glob patterns. For example, use --js='**.js' --js='!**_test.js' to recursively include all js files that do not end in _test.js")
        private List<String> js = new ArrayList<String>();
        @Option(name="--jszip", hidden=true, handler=JsZipOptionHandler.class, usage="The JavaScript zip filename. You may specify multiple.")
        private List<String> jszip = new ArrayList<String>();
        @Option(name="--js_output_file", usage="Primary output filename. If not specified, output is written to stdout")
        private String jsOutputFile = "";
        @Option(name="--module", usage="A JavaScript module specification. The format is <name>:<num-js-files>[:[<dep>,...][:]]]. Module names must be unique. Each dep is the name of a module that this module depends on. Modules must be listed in dependency order, and JS source files must be listed in the corresponding order. Where --module flags occur in relation to --js flags is unimportant. <num-js-files> may be set to 'auto' for the first module if it has no dependencies. Provide the value 'auto' to trigger module creation from CommonJSmodules.")
        private List<String> module = new ArrayList<String>();
        @Option(name="--variable_renaming_report", hidden=true, usage="File where the serialized version of the variable renaming map produced should be saved")
        private String variableMapOutputFile = "";
        @Option(name="--create_renaming_reports", hidden=true, handler=BooleanOptionHandler.class, usage="If true, variable renaming and property renaming report files will be produced as {binary name}_vars_renaming_report.out and {binary name}_props_renaming_report.out. Note that this flag cannot be used in conjunction with either variable_renaming_report or property_renaming_report")
        private boolean createNameMapFiles = false;
        @Option(name="--property_renaming_report", hidden=true, usage="File where the serialized version of the property renaming map produced should be saved")
        private String propertyMapOutputFile = "";
        @Option(name="--third_party", handler=BooleanOptionHandler.class, usage="Check source validity but do not enforce Closure style rules and conventions")
        private boolean thirdParty = false;
        @Option(name="--summary_detail_level", hidden=true, usage="Controls how detailed the compilation summary is. Values: 0 (never print summary), 1 (print summary only if there are errors or warnings), 2 (print summary if the 'checkTypes' diagnostic  group is enabled, see --jscomp_warning), 3 (always print summary). The default level is 1")
        private int summaryDetailLevel = 1;
        @Option(name="--output_wrapper", usage="Interpolate output into this string at the place denoted by the marker token %output%. Use marker token %output|jsstring% to do js string escaping on the output.")
        private String outputWrapper = "";
        @Option(name="--output_wrapper_file", hidden=true, usage="Loads the specified file and passes the file contents to the --output_wrapper flag, replacing the value if it exists.")
        private String outputWrapperFile = "";
        @Option(name="--module_wrapper", usage="An output wrapper for a JavaScript module (optional). The format is <name>:<wrapper>. The module name must correspond with a module specified using --module. The wrapper must contain %s as the code placeholder. The %basename% placeholder can also be used to substitute the base name of the module output file.")
        private List<String> moduleWrapper = new ArrayList<String>();
        @Option(name="--module_output_path_prefix", usage="Prefix for filenames of compiled JS modules. <module-name>.js will be appended to this prefix. Directories will be created as needed. Use with --module")
        private String moduleOutputPathPrefix = "./";
        @Option(name="--create_source_map", usage="If specified, a source map file mapping the generated source files back to the original source file will be output to the specified path. The %outname% placeholder will expand to the name of the output file that the source map corresponds to.")
        private String createSourceMap = "";
        @Option(name="--source_map_format", hidden=true, usage="The source map format to produce. Options are V3 and DEFAULT, which are equivalent.")
        private SourceMap.Format sourceMapFormat = SourceMap.Format.DEFAULT;
        @Option(name="--source_map_location_mapping", usage="Source map location mapping separated by a '|' (i.e. filesystem-path|webserver-path)")
        private List<String> sourceMapLocationMapping = new ArrayList<String>();
        @Option(name="--source_map_input", hidden=true, usage="Source map locations for input files, separated by a '|', (i.e. input-file-path|input-source-map)")
        private List<String> sourceMapInputs = new ArrayList<String>();
        @Option(name="--jscomp_error", handler=WarningGuardErrorOptionHandler.class, usage="Make the named class of warnings an error. Options:accessControls, ambiguousFunctionDecl, checkEventfulObjectDisposal, checkRegExp, checkTypes, checkVars, conformanceViolations, const, constantProperty, deprecated, deprecatedAnnotations, duplicateMessage, es3, es5Strict, externsValidation, fileoverviewTags, globalThis, internetExplorerChecks, invalidCasts, misplacedTypeAnnotation, missingGetCssName, missingProperties, missingProvide, missingRequire, missingReturn, msgDescriptions, newCheckTypes, nonStandardJsDocs, reportUnknownTypes, suspiciousCode, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, unnecessaryCasts, unusedLocalVariables, unusedPrivateMembers, uselessCode, useOfGoogBase, underscore, visibility. '*' adds all supported.")
        private List<String> jscompError = new ArrayList<String>();
        @Option(name="--jscomp_warning", handler=WarningGuardWarningOptionHandler.class, usage="Make the named class of warnings a normal warning. Options:accessControls, ambiguousFunctionDecl, checkEventfulObjectDisposal, checkRegExp, checkTypes, checkVars, conformanceViolations, const, constantProperty, deprecated, deprecatedAnnotations, duplicateMessage, es3, es5Strict, externsValidation, fileoverviewTags, globalThis, internetExplorerChecks, invalidCasts, misplacedTypeAnnotation, missingGetCssName, missingProperties, missingProvide, missingRequire, missingReturn, msgDescriptions, newCheckTypes, nonStandardJsDocs, reportUnknownTypes, suspiciousCode, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, unnecessaryCasts, unusedLocalVariables, unusedPrivateMembers, uselessCode, useOfGoogBase, underscore, visibility. '*' adds all supported.")
        private List<String> jscompWarning = new ArrayList<String>();
        @Option(name="--jscomp_off", handler=WarningGuardOffOptionHandler.class, usage="Turn off the named class of warnings. Options:accessControls, ambiguousFunctionDecl, checkEventfulObjectDisposal, checkRegExp, checkTypes, checkVars, conformanceViolations, const, constantProperty, deprecated, deprecatedAnnotations, duplicateMessage, es3, es5Strict, externsValidation, fileoverviewTags, globalThis, internetExplorerChecks, invalidCasts, misplacedTypeAnnotation, missingGetCssName, missingProperties, missingProvide, missingRequire, missingReturn, msgDescriptions, newCheckTypes, nonStandardJsDocs, reportUnknownTypes, suspiciousCode, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, unnecessaryCasts, unusedLocalVariables, unusedPrivateMembers, uselessCode, useOfGoogBase, underscore, visibility. '*' adds all supported.")
        private List<String> jscompOff = new ArrayList<String>();
        @Option(name="--define", hidden=true, aliases={"--D", "-D"}, usage="Override the value of a variable annotated @define. The format is <name>[=<val>], where <name> is the name of a @define variable and <val> is a boolean, number, or a single-quoted string that contains no single quotes. If [=<val>] is omitted, the variable is marked true")
        private List<String> define = new ArrayList<String>();
        @Option(name="--charset", usage="Input and output charset for all files. By default, we accept UTF-8 as input and output US_ASCII")
        private String charset = "";
        @Option(name="--compilation_level", aliases={"-O"}, usage="Specifies the compilation level to use. Options: WHITESPACE_ONLY, SIMPLE, ADVANCED")
        private String compilationLevel = "SIMPLE";
        private CompilationLevel compilationLevelParsed = null;
        @Option(name="--checks_only", aliases={"--checks-only"}, handler=BooleanOptionHandler.class, usage="Don't generate output. Run checks, but no optimization passes.")
        private boolean checksOnly = false;
        @Option(name="--use_types_for_optimization", handler=BooleanOptionHandler.class, usage="Enable or disable the optimizations based on available type information. Inaccurate type annotations may result in incorrect results.")
        private boolean useTypesForOptimization = true;
        @Option(name="--assume_function_wrapper", handler=BooleanOptionHandler.class, usage="Enable additional optimizations based on the assumption that the output will be wrapped with a function wrapper.  This flag is used to indicate that \"global\" declarations will not actually be global but instead isolated to the compilation unit. This enables additional optimizations.")
        private boolean assumeFunctionWrapper = false;
        @Option(name="--warning_level", aliases={"-W"}, usage="Specifies the warning level to use. Options: QUIET, DEFAULT, VERBOSE")
        private WarningLevel warningLevel = WarningLevel.DEFAULT;
        @Option(name="--debug", hidden=true, handler=BooleanOptionHandler.class, usage="Enable debugging options")
        private boolean debug = false;
        @Option(name="--generate_exports", handler=BooleanOptionHandler.class, usage="Generates export code for those marked with @export")
        private boolean generateExports = false;
        @Option(name="--export_local_property_definitions", hidden=true, handler=BooleanOptionHandler.class, usage="Generates export code for local properties marked with @export")
        private boolean exportLocalPropertyDefinitions = false;
        @Option(name="--formatting", hidden=true, usage="Specifies which formatting options, if any, should be applied to the output JS. Options: PRETTY_PRINT, PRINT_INPUT_DELIMITER, SINGLE_QUOTES")
        private List<FormattingOption> formatting = new ArrayList<FormattingOption>();
        @Option(name="--process_common_js_modules", handler=BooleanOptionHandler.class, usage="Process CommonJS modules to a concatenable form.")
        private boolean processCommonJsModules = false;
        @Option(name="--common_js_module_path_prefix", hidden=true, usage="Deprecated: use --js_module_root.")
        private List<String> commonJsPathPrefix = new ArrayList<String>();
        @Option(name="--js_module_root", usage="Path prefixes to be removed from ES6 & CommonJS modules.")
        private List<String> moduleRoot = new ArrayList<String>();
        @Option(name="--common_js_entry_module", hidden=true, usage="Deprecated: use --entry_point.")
        private String commonJsEntryModule;
        @Option(name="--transform_amd_modules", handler=BooleanOptionHandler.class, usage="Transform AMD to CommonJS modules.")
        private boolean transformAmdModules = false;
        @Option(name="--process_closure_primitives", handler=BooleanOptionHandler.class, usage="Processes built-ins from the Closure library, such as goog.require(), goog.provide(), and goog.exportSymbol(). True by default.")
        private boolean processClosurePrimitives = true;
        @Option(name="--manage_closure_dependencies", hidden=true, handler=BooleanOptionHandler.class, usage="Deprecated: use --dependency_mode=LOOSE.")
        private boolean manageClosureDependencies = false;
        @Option(name="--only_closure_dependencies", hidden=true, handler=BooleanOptionHandler.class, usage="Deprecated: use --dependency_mode=STRICT.")
        private boolean onlyClosureDependencies = false;
        @Option(name="--closure_entry_point", hidden=true, usage="Deprecated: use --entry_point.")
        private List<String> closureEntryPoint = new ArrayList<String>();
        @Option(name="--process_jquery_primitives", hidden=true, handler=BooleanOptionHandler.class, usage="Processes built-ins from the Jquery library, such as jQuery.fn and jQuery.extend()")
        private boolean processJqueryPrimitives = false;
        @Option(name="--angular_pass", handler=BooleanOptionHandler.class, usage="Generate $inject properties for AngularJS for functions annotated with @ngInject")
        private boolean angularPass = false;
        @Option(name="--polymer_pass", handler=BooleanOptionHandler.class, usage="Rewrite Polymer classes to be compiler-friendly.")
        private boolean polymerPass = false;
        @Option(name="--dart_pass", hidden=true, handler=BooleanOptionHandler.class, usage="Rewrite Dart Dev Compiler output to be compiler-friendly.")
        private boolean dartPass = false;
        @Option(name="--j2cl_pass", hidden=true, handler=BooleanOptionHandler.class, usage="Rewrite J2CL output to be compiler-friendly.")
        private boolean j2clPass = false;
        @Option(name="--output_manifest", usage="Prints out a list of all the files in the compilation. If --dependency_mode=STRICT or LOOSE is specified, this will not include files that got dropped because they were not required. The %outname% placeholder expands to the JS output file. If you're using modularization, using %outname% will create a manifest for each module.")
        private String outputManifest = "";
        @Option(name="--output_module_dependencies", usage="Prints out a JSON file of dependencies between modules.")
        private String outputModuleDependencies = "";
        @Option(name="--language_in", usage="Sets what language spec that input sources conform. Options: ECMASCRIPT3, ECMASCRIPT5, ECMASCRIPT5_STRICT, ECMASCRIPT6 (default), ECMASCRIPT6_STRICT, ECMASCRIPT6_TYPED (experimental)")
        private String languageIn = "ECMASCRIPT6";
        @Option(name="--language_out", usage="Sets what language spec the output should conform to. Options: ECMASCRIPT3 (default), ECMASCRIPT5, ECMASCRIPT5_STRICT, ECMASCRIPT6_TYPED (experimental)")
        private String languageOut = "ECMASCRIPT3";
        @Option(name="--version", handler=BooleanOptionHandler.class, usage="Prints the compiler version to stdout and exit.")
        private boolean version = false;
        @Option(name="--translations_file", hidden=true, usage="Source of translated messages. Currently only supports XTB.")
        private String translationsFile = "";
        @Option(name="--translations_project", hidden=true, usage="Scopes all translations to the specified project.When specified, we will use different message ids so that messages in different projects can have different translations.")
        private String translationsProject = null;
        @Option(name="--flagfile", hidden=true, usage="A file containing additional command-line options.")
        private String flagFile = "";
        @Option(name="--warnings_whitelist_file", usage="A file containing warnings to suppress. Each line should be of the form\n<file-name>:<line-number>?  <warning-description>")
        private String warningsWhitelistFile = "";
        @Option(name="--hide_warnings_for", usage="If specified, files whose path contains this string will have their warnings hidden. You may specify multiple.")
        private List<String> hideWarningsFor = new ArrayList<String>();
        @Option(name="--extra_annotation_name", hidden=true, usage="A whitelist of tag names in JSDoc. You may specify multiple")
        private List<String> extraAnnotationName = new ArrayList<String>();
        @Option(name="--tracer_mode", hidden=true, usage="Shows the duration of each compiler pass and the impact to the compiled output size. Options: ALL, RAW_SIZE, TIMING_ONLY, OFF")
        private CompilerOptions.TracerMode tracerMode = CompilerOptions.TracerMode.OFF;
        @Option(name="--new_type_inf", handler=BooleanOptionHandler.class, usage="Checks for type errors using the new type inference algorithm.")
        private boolean useNewTypeInference = false;
        @Option(name="--rename_prefix_namespace", usage="Specifies the name of an object that will be used to store all non-extern globals")
        private String renamePrefixNamespace = null;
        @Option(name="--conformance_configs", usage="A list of JS Conformance configurations in text protocol buffer format.")
        private List<String> conformanceConfigs = new ArrayList<String>();
        @Option(name="--env", usage="Determines the set of builtin externs to load. Options: BROWSER, CUSTOM. Defaults to BROWSER.")
        private CompilerOptions.Environment environment = CompilerOptions.Environment.BROWSER;
        @Option(name="--instrumentation_template", hidden=true, usage="A file containing an instrumentation template.")
        private String instrumentationFile = "";
        @Option(name="--json_streams", usage="Specifies whether standard input and output streams will be a JSON array of sources. Each source will be an object of the form {path: filename, src: file_contents, srcmap: srcmap_contents }. Intended for use by stream-based build systems such as gulpjs. Options: NONE, IN, OUT, BOTH. Defaults to NONE.")
        private CompilerOptions.JsonStreamMode jsonStreamMode = CompilerOptions.JsonStreamMode.NONE;
        @Option(name="--preserve_type_annotations", hidden=true, handler=BooleanOptionHandler.class, usage="Preserves type annotations.")
        private boolean preserveTypeAnnotations = false;
        @Option(name="--noinject_library", hidden=true, usage="Prevent injecting the named runtime libraries.")
        private List<String> noinjectLibrary = new ArrayList<String>();
        @Option(name="--dependency_mode", hidden=true, usage="Specifies how the compiler should determine the set and order of files for a compilation. Options: NONE the compiler will include all src files in the order listed, STRICT files will be included and sorted by starting from namespaces or files listed by the --entry_point flag - files will only be included if they are referenced by a goog.require or CommonJS require or ES6 import, LOOSE same as with STRICT but files which do not goog.provide a namespace and are not modules will be automatically added as --entry_point entries. Defaults to NONE.")
        private CompilerOptions.DependencyMode dependencyMode = CompilerOptions.DependencyMode.NONE;
        @Option(name="--entry_point", usage="A file or namespace to use as the starting point for determining which src files to include in the compilation. ES6 and CommonJS modules are specified as file paths (without the extension). Closure-library namespaces are specified with a \"goog:\" prefix. Example: --entry_point=goog:goog.Promise")
        private List<String> entryPoints = new ArrayList<String>();
        @Option(name="--rewrite_polyfills", handler=BooleanOptionHandler.class, usage="Rewrite ES6 library calls to use polyfills provided by the compiler's runtime.")
        private boolean rewritePolyfills = false;
        @Option(name="--print_source_after_each_pass", hidden=true, usage="Whether to iteratively print resulting JS source per pass.")
        private boolean printSourceAfterEachPass = false;
        @Argument
        private List<String> arguments = new ArrayList<String>();
        private final CmdLineParser parser = new CmdLineParser((Object)this);
        private static final Map<String, CompilationLevel> COMPILATION_LEVEL_MAP = ImmutableMap.of((Object)"WHITESPACE_ONLY", (Object)((Object)CompilationLevel.WHITESPACE_ONLY), (Object)"SIMPLE", (Object)((Object)CompilationLevel.SIMPLE_OPTIMIZATIONS), (Object)"SIMPLE_OPTIMIZATIONS", (Object)((Object)CompilationLevel.SIMPLE_OPTIMIZATIONS), (Object)"ADVANCED", (Object)((Object)CompilationLevel.ADVANCED_OPTIMIZATIONS), (Object)"ADVANCED_OPTIMIZATIONS", (Object)((Object)CompilationLevel.ADVANCED_OPTIMIZATIONS));

        Flags() {
        }

        private void parse(List<String> args) throws CmdLineException {
            this.parser.parseArgument(args.toArray(new String[0]));
            this.compilationLevelParsed = COMPILATION_LEVEL_MAP.get(this.compilationLevel.toUpperCase());
            if (this.compilationLevelParsed == null) {
                throw new CmdLineException(this.parser, "Bad value for --compilation_level: " + this.compilationLevel);
            }
        }

        private void printUsage(PrintStream ps) {
            this.parser.printUsage((Writer)new OutputStreamWriter((OutputStream)ps, StandardCharsets.UTF_8), null, OptionHandlerFilter.PUBLIC);
            ps.flush();
        }

        private void printShortUsageAfterErrors(PrintStream ps) {
            ps.print("Sample usage: ");
            ps.println("--compilation_level (-O) VAL --externs VAL --js VAL --js_output_file VAL --warning_level (-W) [QUIET | DEFAULT | VERBOSE]");
            ps.println("Run with --help for all options and details");
            ps.flush();
        }

        protected List<String> getJsFiles() throws CmdLineException, IOException {
            ArrayList<String> patterns = new ArrayList<String>();
            patterns.addAll(this.js);
            patterns.addAll(this.arguments);
            List<String> allJsInputs = CommandLineRunner.findJsFiles(patterns);
            if (!patterns.isEmpty() && allJsInputs.isEmpty()) {
                throw new CmdLineException(this.parser, "No inputs matched");
            }
            return allJsInputs;
        }

        protected List<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>> getMixedJsSources() throws CmdLineException, IOException {
            ArrayList<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>> mixedSources = new ArrayList<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>>();
            HashSet<String> excludes = new HashSet<String>();
            for (AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType> source : mixedJsSources) {
                if (source.value.endsWith(".zip")) {
                    mixedSources.add(source);
                    continue;
                }
                if (source.value.startsWith("!")) {
                    for (String filename : CommandLineRunner.findJsFiles(Collections.singletonList(source.value.substring(1)))) {
                        excludes.add(filename);
                        mixedSources.remove(new AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>(AbstractCommandLineRunner.JsSourceType.JS, filename));
                    }
                    continue;
                }
                for (String filename : CommandLineRunner.findJsFiles(Collections.singletonList(source.value), true)) {
                    if (excludes.contains(filename)) continue;
                    mixedSources.add(new AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>(AbstractCommandLineRunner.JsSourceType.JS, filename));
                }
            }
            List<String> fromArguments = CommandLineRunner.findJsFiles(this.arguments);
            for (String filename : fromArguments) {
                mixedSources.add(new AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>(AbstractCommandLineRunner.JsSourceType.JS, filename));
            }
            if (!mixedJsSources.isEmpty() && !this.arguments.isEmpty() && mixedSources.isEmpty()) {
                throw new CmdLineException(this.parser, "No inputs matched");
            }
            return mixedSources;
        }

        List<SourceMap.LocationMapping> getSourceMapLocationMappings() throws CmdLineException {
            ImmutableList.Builder locationMappings = ImmutableList.builder();
            ImmutableMap<String, String> split = this.splitPipeParts(this.sourceMapLocationMapping, "--source_map_location_mapping");
            for (Map.Entry mapping : split.entrySet()) {
                locationMappings.add((Object)new SourceMap.LocationMapping((String)mapping.getKey(), (String)mapping.getValue()));
            }
            return locationMappings.build();
        }

        ImmutableMap<String, String> getSourceMapInputs() throws CmdLineException {
            return this.splitPipeParts(this.sourceMapInputs, "--source_map_input");
        }

        private ImmutableMap<String, String> splitPipeParts(Iterable<String> input, String flagName) throws CmdLineException {
            ImmutableMap.Builder result = new ImmutableMap.Builder();
            Splitter splitter = Splitter.on((char)'|').limit(2);
            for (String inputSourceMap : input) {
                List parts = splitter.splitToList((CharSequence)inputSourceMap);
                if (parts.size() != 2) {
                    throw new CmdLineException(this.parser, "Bad value for " + flagName + " (duplicate key): " + input);
                }
                result.put(parts.get(0), parts.get(1));
            }
            return result.build();
        }

        private static class MultiFlagSetter<T>
        implements Setter<String> {
            private final Setter<? super String> proxy;
            private final T flag;
            private final List<AbstractCommandLineRunner.FlagEntry<T>> entries;

            private MultiFlagSetter(Setter<? super String> proxy, T flag, List<AbstractCommandLineRunner.FlagEntry<T>> entries) {
                this.proxy = proxy;
                this.flag = flag;
                this.entries = entries;
            }

            public boolean isMultiValued() {
                return this.proxy.isMultiValued();
            }

            public Class<String> getType() {
                return this.proxy.getType();
            }

            public void addValue(String value) throws CmdLineException {
                this.proxy.addValue((Object)value);
                this.entries.add(new AbstractCommandLineRunner.FlagEntry<T>(this.flag, value));
            }

            public FieldSetter asFieldSetter() {
                return this.proxy.asFieldSetter();
            }

            public AnnotatedElement asAnnotatedElement() {
                return this.proxy.asAnnotatedElement();
            }
        }

        public static class JsZipOptionHandler
        extends StringOptionHandler {
            public JsZipOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, new MultiFlagSetter(setter, (Object)AbstractCommandLineRunner.JsSourceType.JS_ZIP, mixedJsSources));
            }
        }

        public static class JsOptionHandler
        extends StringOptionHandler {
            public JsOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, new MultiFlagSetter(setter, (Object)AbstractCommandLineRunner.JsSourceType.JS, mixedJsSources));
            }
        }

        public static class WarningGuardOffOptionHandler
        extends StringOptionHandler {
            public WarningGuardOffOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, new MultiFlagSetter(setter, (Object)CheckLevel.OFF, guardLevels));
            }
        }

        public static class WarningGuardWarningOptionHandler
        extends StringOptionHandler {
            public WarningGuardWarningOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, new MultiFlagSetter(setter, (Object)CheckLevel.WARNING, guardLevels));
            }
        }

        public static class WarningGuardErrorOptionHandler
        extends StringOptionHandler {
            public WarningGuardErrorOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, new MultiFlagSetter(setter, (Object)CheckLevel.ERROR, guardLevels));
            }
        }

        public static class BooleanOptionHandler
        extends OptionHandler<Boolean> {
            private static final Set<String> TRUES = ImmutableSet.of((Object)"true", (Object)"on", (Object)"yes", (Object)"1");
            private static final Set<String> FALSES = ImmutableSet.of((Object)"false", (Object)"off", (Object)"no", (Object)"0");

            public BooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
                super(parser, option, setter);
            }

            public int parseArguments(Parameters params) throws CmdLineException {
                String param = null;
                try {
                    param = params.getParameter(0);
                }
                catch (CmdLineException e) {
                    param = null;
                }
                if (param == null) {
                    this.setter.addValue((Object)true);
                    return 0;
                }
                String lowerParam = param.toLowerCase();
                if (TRUES.contains(lowerParam)) {
                    this.setter.addValue((Object)true);
                } else if (FALSES.contains(lowerParam)) {
                    this.setter.addValue((Object)false);
                } else {
                    this.setter.addValue((Object)true);
                    return 0;
                }
                return 1;
            }

            public String getDefaultMetaVariable() {
                return null;
            }
        }
    }
}

