/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LiveVariablesAnalysis;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class CheckEventfulObjectDisposal
implements CompilerPass {
    static final DiagnosticType EVENTFUL_OBJECT_NOT_DISPOSED = DiagnosticType.error("JSC_EVENTFUL_OBJECT_NOT_DISPOSED", "eventful object created should be\n  * registered as disposable, or\n  * explicitly disposed of");
    static final DiagnosticType EVENTFUL_OBJECT_PURELY_LOCAL = DiagnosticType.error("JSC_EVENTFUL_OBJECT_PURELY_LOCAL", "a purely local eventful object cannot be disposed of later");
    static final DiagnosticType OVERWRITE_PRIVATE_EVENTFUL_OBJECT = DiagnosticType.error("JSC_OVERWRITE_PRIVATE_EVENTFUL_OBJECT", "private eventful object overwritten in subclass cannot be properly disposed of");
    static final DiagnosticType UNLISTEN_WITH_ANONBOUND = DiagnosticType.error("JSC_UNLISTEN_WITH_ANONBOUND", "an unlisten call with an anonymous or bound function does not result in the event being unlisted to");
    private static final String DISPOSABLE_INTERFACE_TYPE_NAME = "goog.disposable.IDisposable";
    private static final String EVENT_HANDLER_TYPE_NAME = "goog.events.EventHandler";
    private JSType googDisposableInterfaceType;
    private JSType googEventsEventHandlerType;
    private Set<JSType> eventfulTypes;
    private Map<JSType, Map<String, List<Integer>>> disposeCalls;
    public static final int DISPOSE_ALL = -1;
    public static final int DISPOSE_SELF = -2;
    private final AbstractCompiler compiler;
    private final TypeIRegistry typeRegistry;
    private final DisposalCheckingPolicy checkingPolicy;
    private Map<String, Set<String>> eventizes;
    private static Map<String, EventfulObjectState> eventfulObjectMap;

    public CheckEventfulObjectDisposal(AbstractCompiler compiler, DisposalCheckingPolicy checkingPolicy) {
        this.compiler = compiler;
        this.checkingPolicy = checkingPolicy;
        this.typeRegistry = compiler.getTypeIRegistry();
        this.initializeDisposeMethodsMap();
    }

    private void addDisposeCall(String functionOrMethodName, List<Integer> argumentsThatAreDisposed) {
        String propertyName;
        JSType objectType = null;
        int lastPeriod = functionOrMethodName.lastIndexOf(46);
        if (lastPeriod >= 0) {
            String potentiallyTypeName = functionOrMethodName.substring(0, lastPeriod).replaceFirst(".prototype$", "");
            propertyName = functionOrMethodName.substring(lastPeriod);
            objectType = (JSType)this.typeRegistry.getType(potentiallyTypeName);
        } else {
            propertyName = functionOrMethodName;
        }
        Map<String, List<Integer>> map = this.disposeCalls.get(objectType);
        if (map == null) {
            map = new HashMap<String, List<Integer>>();
            this.disposeCalls.put(objectType, map);
        }
        if (objectType == null) {
            map.put(functionOrMethodName, argumentsThatAreDisposed);
        } else {
            map.put(propertyName, argumentsThatAreDisposed);
        }
    }

    private void initializeDisposeMethodsMap() {
        this.disposeCalls = new HashMap<JSType, Map<String, List<Integer>>>();
        this.addDisposeCall("goog.array.extend", (List<Integer>)ImmutableList.of((Object)-1));
        this.addDisposeCall("goog.dispose", (List<Integer>)ImmutableList.of((Object)0));
        this.addDisposeCall("goog.Disposable.registerDisposable", (List<Integer>)ImmutableList.of((Object)0));
        this.addDisposeCall("goog.disposeAll", (List<Integer>)ImmutableList.of((Object)-1));
        this.addDisposeCall("goog.events.EventHandler.removeAll", (List<Integer>)ImmutableList.of((Object)-2));
        this.addDisposeCall(".dispose", (List<Integer>)ImmutableList.of((Object)-2));
        this.addDisposeCall(".push", (List<Integer>)ImmutableList.of((Object)0));
        this.addDisposeCall(".add", (List<Integer>)ImmutableList.of((Object)-2));
    }

    private static Node getBase(Node n) {
        Node base = n;
        while (base.isGetProp()) {
            base = base.getFirstChild();
        }
        return base;
    }

    private static JSType getTypeOfThisForScope(NodeTraversal t) {
        JSType typeOfThis = t.getScopeRoot().getJSType();
        if (typeOfThis == null) {
            return null;
        }
        ObjectType objectType = ObjectType.cast(CheckEventfulObjectDisposal.dereference(typeOfThis));
        return objectType.getTypeOfThis();
    }

    private static boolean isPossiblySubtype(JSType thisType, JSType thatType) {
        if (thisType == null) {
            return false;
        }
        JSType type = thisType;
        if (type.isUnionType()) {
            for (JSType alternate : type.toMaybeUnionType().getAlternates()) {
                if (!alternate.isSubtype(thatType)) continue;
                return true;
            }
        } else if (type.isSubtype(thatType)) {
            return true;
        }
        return false;
    }

    private static JSType dereference(JSType type) {
        return type == null ? null : type.dereference();
    }

    private static String generateKey(NodeTraversal t, Node n, boolean noLocalVariables) {
        String key;
        if (n == null) {
            return null;
        }
        Node scopeNode = t.getScopeRoot();
        if (n.isName()) {
            if (noLocalVariables) {
                return null;
            }
            key = n.getQualifiedName();
            if (scopeNode.isFunction()) {
                JSType parentScopeType = (JSType)t.getTypedScope().getParentScope().getTypeOfThis();
                if (!parentScopeType.isGlobalThisType()) {
                    key = parentScopeType + "~" + key;
                }
                key = NodeUtil.getName(scopeNode) + "=" + key;
            }
        } else {
            if (!n.isQualifiedName()) {
                return null;
            }
            key = n.getQualifiedName();
            Node base = CheckEventfulObjectDisposal.getBase(n);
            if (base != null && base.isThis()) {
                if (base.getJSType().isUnknownType()) {
                    key = t.getTypedScope().getParentScope().getTypeOfThis() + "~" + key;
                } else if (n.getFirstChild() == null) {
                    key = base.getJSType() + "=" + key;
                } else {
                    ObjectType objectType = ObjectType.cast(CheckEventfulObjectDisposal.dereference(n.getFirstChild().getJSType()));
                    if (objectType == null) {
                        return null;
                    }
                    ObjectType hObjT = objectType;
                    String propertyName = n.getLastChild().getString();
                    while (objectType != null) {
                        hObjT = objectType;
                        if ((objectType = objectType.getImplicitPrototype()) != null && (objectType.getDisplayName().endsWith("prototype") || objectType.getPropertyNames().contains(propertyName))) continue;
                    }
                    key = hObjT + "=" + key;
                }
            }
        }
        return key;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument((this.checkingPolicy != DisposalCheckingPolicy.OFF ? 1 : 0) != 0);
        this.googDisposableInterfaceType = (JSType)this.typeRegistry.getType(DISPOSABLE_INTERFACE_TYPE_NAME);
        this.googEventsEventHandlerType = (JSType)this.typeRegistry.getType(EVENT_HANDLER_TYPE_NAME);
        if (this.googEventsEventHandlerType == null || this.googDisposableInterfaceType == null) {
            return;
        }
        this.eventfulTypes = new HashSet<JSType>();
        this.eventfulTypes.add(this.googEventsEventHandlerType);
        if (this.checkingPolicy == DisposalCheckingPolicy.AGGRESSIVE) {
            NodeTraversal.traverseTyped(this.compiler, root, new ComputeEventizeTraversal());
            this.computeEventful();
        }
        eventfulObjectMap = new HashMap<String, EventfulObjectState>();
        NodeTraversal.traverseTyped(this.compiler, root, new Traversal());
        for (EventfulObjectState e : eventfulObjectMap.values()) {
            Node n = e.allocationSite;
            if (e.seen == SeenType.ALLOCATED) {
                this.compiler.report(JSError.make(n, EVENTFUL_OBJECT_NOT_DISPOSED, new String[0]));
                continue;
            }
            if (e.seen != SeenType.ALLOCATED_LOCALLY || this.checkingPolicy != DisposalCheckingPolicy.AGGRESSIVE) continue;
            this.compiler.report(JSError.make(n, EVENTFUL_OBJECT_PURELY_LOCAL, new String[0]));
        }
    }

    private void computeEventful() {
        String[] order = new String[this.eventizes.size()];
        int white = 0;
        int gray = 1;
        int black = 2;
        int last = this.eventizes.size() - 1;
        HashMap<String, Integer> color = new HashMap<String, Integer>();
        Stack<String> dfsStack = new Stack<String>();
        for (Map.Entry<String, Set<String>> eventizesEntry : this.eventizes.entrySet()) {
            color.put(eventizesEntry.getKey(), white);
            for (String s : eventizesEntry.getValue()) {
                color.put(s, white);
            }
        }
        int indx = 0;
        for (String s : this.eventizes.keySet()) {
            dfsStack.push(s);
            while (!dfsStack.isEmpty()) {
                String top = (String)dfsStack.pop();
                if (!color.containsKey(top)) continue;
                if ((Integer)color.get(top) == white) {
                    color.put(top, gray);
                    dfsStack.push(top);
                    if (!this.eventizes.containsKey(top)) continue;
                    for (String v : this.eventizes.get(top)) {
                        if ((Integer)color.get(v) != white) continue;
                        dfsStack.push(v);
                    }
                    continue;
                }
                if ((Integer)color.get(top) != gray || !this.eventizes.containsKey(top)) continue;
                order[last - indx] = top;
                ++indx;
                color.put(top, black);
            }
        }
        for (String s : order) {
            if (!this.eventfulTypes.contains(this.typeRegistry.getType(s))) continue;
            for (String v : this.eventizes.get(s)) {
                this.eventfulTypes.add((JSType)this.typeRegistry.getType(v));
            }
        }
    }

    private JSType maybeReturnDisposedType(Node n, boolean checkDispose) {
        Node first = n.getFirstChild();
        if (first == null || !first.isQualifiedName()) {
            return null;
        }
        String property = first.getQualifiedName();
        if (property.endsWith(".registerDisposable")) {
            Node base = first.getFirstChild();
            JSType baseType = base.getJSType();
            if (baseType == null || !CheckEventfulObjectDisposal.isPossiblySubtype(baseType, this.googDisposableInterfaceType)) {
                return null;
            }
            return n.getLastChild().getJSType();
        }
        if (checkDispose) {
            if (property.equals("goog.dispose")) {
                return n.getLastChild().getJSType();
            }
            if (property.endsWith(".dispose")) {
                return n.getFirstFirstChild().getJSType();
            }
        }
        return null;
    }

    private class Traversal
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private Traversal() {
        }

        private boolean createsEventfulObject(Node n) {
            Node first = n.getFirstChild();
            JSType type = n.getJSType();
            if (first == null || !first.isQualifiedName() || type.isEmptyType() || type.isUnknownType()) {
                return false;
            }
            boolean isOfTypeNeedingDisposal = false;
            for (JSType disposableType : CheckEventfulObjectDisposal.this.eventfulTypes) {
                if (!type.isSubtype(disposableType)) continue;
                isOfTypeNeedingDisposal = true;
                break;
            }
            return isOfTypeNeedingDisposal;
        }

        private Node localEventfulObjectAssign(NodeTraversal t, Node propertyNode) {
            EventfulObjectState e;
            Node parent = !t.getTypedScope().isGlobal() ? NodeUtil.getFunctionBody(t.getScopeRoot()) : t.getScopeRoot().getFirstChild();
            for (Node sibling : parent.children()) {
                Node assign;
                if (!sibling.isExprResult() || !(assign = sibling.getFirstChild()).isAssign() || !propertyNode.matchesQualifiedName(assign.getLastChild()) || assign.getFirstChild().isName()) continue;
                return assign.getFirstChild();
            }
            String key = CheckEventfulObjectDisposal.generateKey(t, propertyNode, false);
            if (key == null) {
                return null;
            }
            if (eventfulObjectMap.containsKey(key)) {
                e = (EventfulObjectState)eventfulObjectMap.get(key);
                if (e.seen == SeenType.ALLOCATED) {
                    e.seen = SeenType.ALLOCATED_LOCALLY;
                }
            } else {
                e = new EventfulObjectState();
                e.seen = SeenType.ALLOCATED_LOCALLY;
                eventfulObjectMap.put(key, e);
            }
            e.allocationSite = propertyNode;
            return null;
        }

        private void visitNew(NodeTraversal t, Node n, Node parent) {
            Node globalVarNode;
            EventfulObjectState e;
            if (!this.createsEventfulObject(n)) {
                return;
            }
            Node propertyNode = parent.isAssign() ? parent.getFirstChild() : parent;
            String key = CheckEventfulObjectDisposal.generateKey(t, propertyNode, false);
            if (key == null) {
                return;
            }
            if (eventfulObjectMap.containsKey(key)) {
                e = (EventfulObjectState)eventfulObjectMap.get(key);
            } else {
                e = new EventfulObjectState();
                e.seen = SeenType.ALLOCATED;
                eventfulObjectMap.put(key, e);
            }
            e.allocationSite = propertyNode;
            if (propertyNode.isName() && (globalVarNode = this.localEventfulObjectAssign(t, propertyNode)) != null) {
                key = CheckEventfulObjectDisposal.generateKey(t, globalVarNode, false);
                if (key == null) {
                    e.seen = SeenType.POSSIBLY_DISPOSED;
                    return;
                }
                eventfulObjectMap.put(key, e);
            }
        }

        private void addDisposeArgumentsMatched(Map<String, List<Integer>> map, Node n, String property, List<Node> foundDisposeCalls) {
            for (Map.Entry<String, List<Integer>> disposeCallsEntry : map.entrySet()) {
                if (!property.endsWith(disposeCallsEntry.getKey())) continue;
                List<Integer> disposeArguments = disposeCallsEntry.getValue();
                Node t = n.getNext();
                int tsArgument = 0;
                block5: for (Integer disposeArgument : disposeArguments) {
                    switch (disposeArgument) {
                        case -1: {
                            for (Node tt = n.getNext(); tt != null; tt = tt.getNext()) {
                                foundDisposeCalls.add(tt);
                            }
                            continue block5;
                        }
                        case -2: {
                            Node calledOn = n.getFirstChild();
                            foundDisposeCalls.add(calledOn);
                            break;
                        }
                        default: {
                            if (tsArgument > disposeArgument) {
                                t = n.getNext();
                                tsArgument = 0;
                            }
                            while (tsArgument < disposeArgument && t != null) {
                                t = t.getNext();
                                ++tsArgument;
                            }
                            if (tsArgument != disposeArgument || t == null) continue block5;
                            foundDisposeCalls.add(t);
                        }
                    }
                }
            }
        }

        private List<Node> maybeGetValueNodesFromCall(Node n) {
            ArrayList<Node> ret = new ArrayList<Node>();
            Node first = n.getFirstChild();
            if (first == null || !first.isQualifiedName()) {
                return ret;
            }
            String property = first.getQualifiedName();
            Node base = first.getFirstChild();
            JSType baseType = null;
            if (base != null) {
                baseType = base.getJSType();
            }
            for (Map.Entry disposeCallEntry : CheckEventfulObjectDisposal.this.disposeCalls.entrySet()) {
                JSType key = (JSType)disposeCallEntry.getKey();
                if (key != null && (baseType == null || !CheckEventfulObjectDisposal.isPossiblySubtype(baseType, key))) continue;
                this.addDisposeArgumentsMatched((Map)disposeCallEntry.getValue(), first, property, ret);
            }
            return ret;
        }

        private void visitCall(NodeTraversal t, Node n) {
            List<Node> variableNodes = this.maybeGetValueNodesFromCall(n);
            for (Node variableNode : variableNodes) {
                String key;
                Preconditions.checkState((variableNode != null ? 1 : 0) != 0);
                boolean isTrackedRemoval = false;
                JSType vnType = variableNode.getJSType();
                for (JSType type : CheckEventfulObjectDisposal.this.eventfulTypes) {
                    if (!CheckEventfulObjectDisposal.isPossiblySubtype(vnType, type)) continue;
                    isTrackedRemoval = true;
                }
                if (!isTrackedRemoval || (key = CheckEventfulObjectDisposal.generateKey(t, variableNode, false)) == null) continue;
                this.eventfulObjectDisposed(t, variableNode);
            }
        }

        private JSType dereference(JSType type) {
            return type == null ? null : type.dereference();
        }

        public void visitFunction(NodeTraversal t, Node n) {
            Preconditions.checkArgument((boolean)n.isFunction());
            JSDocInfo jsDocInfo = NodeUtil.getBestJSDocInfo(n);
            if (jsDocInfo != null && jsDocInfo.isDisposes()) {
                JSType type = n.getJSType();
                if (type == null || type.isUnknownType()) {
                    return;
                }
                FunctionType funType = type.toMaybeFunctionType();
                Node paramNode = NodeUtil.getFunctionParameters(n).getFirstChild();
                ArrayList<Integer> positionalDisposedParameters = new ArrayList<Integer>();
                if (jsDocInfo.disposesOf("*")) {
                    positionalDisposedParameters.add(-1);
                } else {
                    for (int index = 0; index < funType.getMaxArguments() && paramNode != null; paramNode = paramNode.getNext(), ++index) {
                        if (!jsDocInfo.disposesOf(paramNode.getString())) continue;
                        positionalDisposedParameters.add(index);
                    }
                }
                CheckEventfulObjectDisposal.this.addDisposeCall(NodeUtil.getName(n), positionalDisposedParameters);
            }
        }

        public void visitAssign(NodeTraversal t, Node n) {
            Node assignedTo = n.getFirstChild();
            JSType assignedToType = assignedTo.getJSType();
            if (assignedToType == null || assignedToType.isEmptyType()) {
                return;
            }
            if (n.getFirstChild().isGetProp()) {
                boolean fieldIsPrivate;
                boolean isTrackedAssign = false;
                for (JSType disposalType : CheckEventfulObjectDisposal.this.eventfulTypes) {
                    if (!assignedToType.isSubtype(disposalType)) continue;
                    isTrackedAssign = true;
                    break;
                }
                if (!isTrackedAssign) {
                    return;
                }
                JSDocInfo di = n.getJSDocInfo();
                ObjectType objectType = ObjectType.cast(this.dereference(n.getFirstFirstChild().getJSType()));
                String propertyName = n.getFirstChild().getLastChild().getString();
                boolean bl = fieldIsPrivate = di != null && di.getVisibility() == JSDocInfo.Visibility.PRIVATE;
                while (objectType != null) {
                    di = null;
                    if ((objectType = objectType.getImplicitPrototype()) == null) break;
                    if (objectType.getDisplayName().endsWith("prototype") || (di = objectType.getOwnPropertyJSDocInfo(propertyName)) == null || !fieldIsPrivate && di.getVisibility() != JSDocInfo.Visibility.PRIVATE) continue;
                    CheckEventfulObjectDisposal.this.compiler.report(t.makeError(n, OVERWRITE_PRIVATE_EVENTFUL_OBJECT, new String[0]));
                    break;
                }
            }
        }

        private void visitReturn(NodeTraversal t, Node n) {
            Node variableNode = n.getFirstChild();
            if (variableNode == null) {
                return;
            }
            if (!variableNode.isArrayLit()) {
                this.eventfulObjectDisposed(t, variableNode);
            } else {
                for (Node child : variableNode.children()) {
                    this.eventfulObjectDisposed(t, child);
                }
            }
        }

        private void eventfulObjectDisposed(NodeTraversal t, Node variableNode) {
            String key = CheckEventfulObjectDisposal.generateKey(t, variableNode, false);
            if (key == null) {
                return;
            }
            EventfulObjectState e = (EventfulObjectState)eventfulObjectMap.get(key);
            if (e == null) {
                e = new EventfulObjectState();
                eventfulObjectMap.put(key, e);
            }
            e.seen = SeenType.POSSIBLY_DISPOSED;
        }

        @Override
        public void enterScope(NodeTraversal t) {
            ControlFlowGraph<Node> cfg = t.getControlFlowGraph();
            LiveVariablesAnalysis liveness = new LiveVariablesAnalysis(cfg, t.getTypedScope(), CheckEventfulObjectDisposal.this.compiler);
            liveness.analyze();
            for (TypedVar typedVar : liveness.getEscapedLocals()) {
                this.eventfulObjectDisposed(t, typedVar.getNode());
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 86: {
                    this.visitAssign(t, n);
                    break;
                }
                case 37: {
                    this.visitCall(t, n);
                    break;
                }
                case 105: {
                    this.visitFunction(t, n);
                    break;
                }
                case 30: {
                    this.visitNew(t, n, parent);
                    break;
                }
                case 4: {
                    this.visitReturn(t, n);
                    break;
                }
            }
        }
    }

    private class ComputeEventizeTraversal
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        Stack<Boolean> isConstructorStack = new Stack();
        Stack<Boolean> isDisposalStack = new Stack();

        public ComputeEventizeTraversal() {
            CheckEventfulObjectDisposal.this.eventizes = new HashMap();
        }

        private Boolean inConstructorScope() {
            Preconditions.checkNotNull(this.isConstructorStack);
            if (!this.isDisposalStack.isEmpty()) {
                return this.isConstructorStack.peek();
            }
            return null;
        }

        private Boolean inDisposalScope() {
            Preconditions.checkNotNull(this.isDisposalStack);
            if (!this.isDisposalStack.isEmpty()) {
                return this.isDisposalStack.peek();
            }
            return null;
        }

        private boolean collectorFilterType(JSType type) {
            if (type == null) {
                return true;
            }
            return type.isEmptyType() || type.isUnknownType() || !CheckEventfulObjectDisposal.isPossiblySubtype(type, CheckEventfulObjectDisposal.this.googDisposableInterfaceType);
        }

        private void addEventize(JSType thisType, JSType thatType) {
            if (this.collectorFilterType(thisType) || this.collectorFilterType(thatType) || thisType.isEquivalentTo(thatType)) {
                return;
            }
            String className = thisType.getDisplayName();
            if (thatType.isUnionType()) {
                UnionType ut = thatType.toMaybeUnionType();
                for (JSType type : ut.getAlternates()) {
                    if (!type.isObject()) continue;
                    this.addEventizeClass(className, type);
                }
            } else {
                this.addEventizeClass(className, thatType);
            }
        }

        private void addEventizeClass(String className, JSType thatType) {
            String propertyJsTypeName = thatType.getDisplayName();
            HashSet<String> eventize = (HashSet<String>)CheckEventfulObjectDisposal.this.eventizes.get(propertyJsTypeName);
            if (eventize == null) {
                eventize = new HashSet<String>();
                CheckEventfulObjectDisposal.this.eventizes.put(propertyJsTypeName, eventize);
            }
            eventize.add(className);
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Node n = t.getScopeRoot();
            boolean isConstructor = false;
            boolean isInDisposal = false;
            String functionName = null;
            if (n.isFunction()) {
                functionName = NodeUtil.getName(n);
                if (functionName != null) {
                    JSDocInfo jsDocInfo = NodeUtil.getBestJSDocInfo(n);
                    if (jsDocInfo != null && jsDocInfo.isConstructor()) {
                        isConstructor = true;
                        if (t.getTypedScope() != null && t.getTypedScope().getTypeOfThis() != null) {
                            ObjectType objectType = ObjectType.cast(t.getTypedScope().getTypeOfThis().dereference());
                            while (objectType != null && (objectType = objectType.getImplicitPrototype()) != null) {
                                if (objectType.getDisplayName().endsWith("prototype")) continue;
                                this.addEventize((JSType)CheckEventfulObjectDisposal.this.compiler.getTypeIRegistry().getType(functionName), objectType);
                                break;
                            }
                        }
                    }
                    if (functionName.endsWith(".disposeInternal")) {
                        isInDisposal = true;
                    }
                }
                this.isConstructorStack.push(isConstructor);
                this.isDisposalStack.push(isInDisposal);
            } else {
                this.isConstructorStack.push(this.inConstructorScope());
                this.isDisposalStack.push(this.inDisposalScope());
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            this.isConstructorStack.pop();
            this.isDisposalStack.pop();
        }

        private void isGoogEventsUnlisten(Node n) {
            Preconditions.checkArgument((n.getChildCount() > 3 ? 1 : 0) != 0);
            Node listener = n.getChildAtIndex(3);
            Node objectWithListener = n.getSecondChild();
            if (!objectWithListener.isQualifiedName()) {
                return;
            }
            if (listener.isFunction()) {
                CheckEventfulObjectDisposal.this.compiler.report(JSError.make(n, UNLISTEN_WITH_ANONBOUND, new String[0]));
            } else if (listener.isCall()) {
                if (!listener.getFirstChild().isQualifiedName()) {
                    CheckEventfulObjectDisposal.this.compiler.report(JSError.make(n, UNLISTEN_WITH_ANONBOUND, new String[0]));
                } else if (listener.getFirstChild().matchesQualifiedName("goog.bind")) {
                    CheckEventfulObjectDisposal.this.compiler.report(JSError.make(n, UNLISTEN_WITH_ANONBOUND, new String[0]));
                }
            }
        }

        private void visitCall(NodeTraversal t, Node n) {
            JSType disposedType;
            Node functionCalled = n.getFirstChild();
            if (functionCalled == null || !functionCalled.isQualifiedName()) {
                return;
            }
            JSType typeOfThis = CheckEventfulObjectDisposal.getTypeOfThisForScope(t);
            if (typeOfThis == null) {
                return;
            }
            if (functionCalled.matchesQualifiedName("goog.events.unlisten")) {
                if (this.inDisposalScope().booleanValue()) {
                    CheckEventfulObjectDisposal.this.eventfulTypes.add(typeOfThis);
                }
                this.isGoogEventsUnlisten(n);
            }
            if (this.inDisposalScope().booleanValue() && functionCalled.matchesQualifiedName("goog.events.removeAll")) {
                CheckEventfulObjectDisposal.this.eventfulTypes.add(typeOfThis);
            }
            if (!this.collectorFilterType(disposedType = CheckEventfulObjectDisposal.this.maybeReturnDisposedType(n, this.inDisposalScope()))) {
                this.addEventize(CheckEventfulObjectDisposal.getTypeOfThisForScope(t), disposedType);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 37: {
                    this.visitCall(t, n);
                    break;
                }
            }
        }
    }

    private static class EventfulObjectState {
        public SeenType seen;
        public Node allocationSite;

        private EventfulObjectState() {
        }
    }

    private static enum SeenType {
        ALLOCATED,
        ALLOCATED_LOCALLY,
        POSSIBLY_DISPOSED,
        DISPOSED;

    }

    public static enum DisposalCheckingPolicy {
        OFF,
        ON,
        AGGRESSIVE;

    }
}

