/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class AnalyzePrototypeProperties
implements CompilerPass {
    private static final SymbolType PROPERTY = SymbolType.PROPERTY;
    private static final SymbolType VAR = SymbolType.VAR;
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;
    private final boolean anchorUnusedVars;
    private final JSModuleGraph moduleGraph;
    private final JSModule firstModule;
    private static final Set<String> IMPLICITLY_USED_PROPERTIES = ImmutableSet.of((Object)"length", (Object)"toString", (Object)"valueOf");
    private final LinkedDirectedGraph<NameInfo, JSModule> symbolGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final NameInfo globalNode = new NameInfo("[global]");
    private final NameInfo externNode = new NameInfo("[extern]");
    private final NameInfo anonymousNode = new NameInfo("[anonymous]");
    private final Map<String, NameInfo> propertyNameInfo = new LinkedHashMap<String, NameInfo>();
    private final Map<String, NameInfo> varNameInfo = new LinkedHashMap<String, NameInfo>();

    AnalyzePrototypeProperties(AbstractCompiler compiler, JSModuleGraph moduleGraph, boolean canModifyExterns, boolean anchorUnusedVars) {
        this.compiler = compiler;
        this.moduleGraph = moduleGraph;
        this.canModifyExterns = canModifyExterns;
        this.anchorUnusedVars = anchorUnusedVars;
        this.firstModule = moduleGraph != null ? moduleGraph.getRootModule() : null;
        this.globalNode.markReference(null);
        this.externNode.markReference(null);
        this.symbolGraph.createNode(this.globalNode);
        this.symbolGraph.createNode(this.externNode);
        for (String property : IMPLICITLY_USED_PROPERTIES) {
            NameInfo nameInfo = this.getNameInfoForName(property, PROPERTY);
            if (moduleGraph == null) {
                this.symbolGraph.connect(this.externNode, null, nameInfo);
                continue;
            }
            for (JSModule module : moduleGraph.getAllModules()) {
                this.symbolGraph.connect(this.externNode, module, nameInfo);
            }
        }
    }

    @Override
    public void process(Node externRoot, Node root) {
        if (!this.canModifyExterns) {
            NodeTraversal.traverseEs6(this.compiler, externRoot, new ProcessExternProperties());
        }
        NodeTraversal.traverseEs6(this.compiler, root, new ProcessProperties());
        FixedPointGraphTraversal<NameInfo, JSModule> t = FixedPointGraphTraversal.newTraversal(new PropagateReferences());
        t.computeFixedPoint(this.symbolGraph, (Set<NameInfo>)ImmutableSet.of((Object)this.externNode, (Object)this.globalNode));
    }

    public Collection<NameInfo> getAllNameInfo() {
        ArrayList<NameInfo> result = new ArrayList<NameInfo>(this.propertyNameInfo.values());
        result.addAll(this.varNameInfo.values());
        return result;
    }

    private NameInfo getNameInfoForName(String name, SymbolType type) {
        Map<String, NameInfo> map;
        Map<String, NameInfo> map2 = map = type == PROPERTY ? this.propertyNameInfo : this.varNameInfo;
        if (map.containsKey(name)) {
            return map.get(name);
        }
        NameInfo nameInfo = new NameInfo(name);
        map.put(name, nameInfo);
        this.symbolGraph.createNode(nameInfo);
        return nameInfo;
    }

    class NameInfo {
        final String name;
        private boolean referenced = false;
        private final Deque<Symbol> declarations = new ArrayDeque<Symbol>();
        private JSModule deepestCommonModuleRef = null;
        private boolean readClosureVariables = false;

        NameInfo(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        boolean isReferenced() {
            return this.referenced;
        }

        boolean readsClosureVariables() {
            return this.readClosureVariables;
        }

        boolean markReference(JSModule module) {
            boolean hasChanged = false;
            if (!this.referenced) {
                this.referenced = true;
                hasChanged = true;
            }
            if (AnalyzePrototypeProperties.this.moduleGraph != null) {
                JSModule originalDeepestCommon = this.deepestCommonModuleRef;
                this.deepestCommonModuleRef = this.deepestCommonModuleRef == null ? module : AnalyzePrototypeProperties.this.moduleGraph.getDeepestCommonDependencyInclusive(this.deepestCommonModuleRef, module);
                if (originalDeepestCommon != this.deepestCommonModuleRef) {
                    hasChanged = true;
                }
            }
            return hasChanged;
        }

        JSModule getDeepestCommonModuleRef() {
            return this.deepestCommonModuleRef;
        }

        Deque<Symbol> getDeclarations() {
            return this.declarations;
        }
    }

    private class NameContext {
        final NameInfo name;
        final Scope scope;

        NameContext(NameInfo name, Scope scope) {
            this.name = name;
            this.scope = scope;
        }
    }

    static class LiteralProperty
    implements Property {
        private final Node key;
        private final Node value;
        private final Node map;
        private final Node assign;
        private final Var rootVar;
        private final JSModule module;

        LiteralProperty(Node key, Node value, Node map, Node assign, Var rootVar, JSModule module) {
            this.key = key;
            this.value = value;
            this.map = map;
            this.assign = assign;
            this.rootVar = rootVar;
            this.module = module;
        }

        @Override
        public Var getRootVar() {
            return this.rootVar;
        }

        @Override
        public void remove(AbstractCompiler compiler) {
            compiler.reportChangeToEnclosingScope(this.key);
            this.map.removeChild(this.key);
        }

        @Override
        public Node getPrototype() {
            return this.assign.getFirstChild();
        }

        @Override
        public Node getValue() {
            return this.value;
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }
    }

    static class AssignmentProperty
    implements Property {
        private final Node exprNode;
        private final Var rootVar;
        private final JSModule module;

        AssignmentProperty(Node node, Var rootVar, JSModule module) {
            this.exprNode = node;
            this.rootVar = rootVar;
            this.module = module;
        }

        @Override
        public Var getRootVar() {
            return this.rootVar;
        }

        @Override
        public void remove(AbstractCompiler compiler) {
            compiler.reportChangeToEnclosingScope(this.exprNode);
            NodeUtil.removeChild(this.exprNode.getParent(), this.exprNode);
        }

        @Override
        public Node getPrototype() {
            return this.getAssignNode().getFirstFirstChild();
        }

        @Override
        public Node getValue() {
            return this.getAssignNode().getLastChild();
        }

        private Node getAssignNode() {
            return this.exprNode.getFirstChild();
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }
    }

    static interface Property
    extends Symbol {
        public Node getPrototype();

        public Node getValue();
    }

    static class GlobalFunction
    implements Symbol {
        private final Node nameNode;
        private final Var var;
        private final JSModule module;

        GlobalFunction(Node nameNode, Var var, JSModule module) {
            Node parent = nameNode.getParent();
            Preconditions.checkState((parent.isVar() || NodeUtil.isFunctionDeclaration(parent) ? 1 : 0) != 0);
            this.nameNode = nameNode;
            this.var = var;
            this.module = module;
        }

        @Override
        public Var getRootVar() {
            return this.var;
        }

        @Override
        public void remove(AbstractCompiler compiler) {
            Node parent = this.nameNode.getParent();
            compiler.reportChangeToEnclosingScope(parent);
            if (parent.isFunction() || parent.hasOneChild()) {
                NodeUtil.removeChild(parent.getParent(), parent);
            } else {
                Preconditions.checkState((boolean)parent.isVar());
                parent.removeChild(this.nameNode);
            }
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }
    }

    private static enum SymbolType {
        PROPERTY,
        VAR;

    }

    static interface Symbol {
        public void remove(AbstractCompiler var1);

        public Var getRootVar();

        public JSModule getModule();
    }

    private class PropagateReferences
    implements FixedPointGraphTraversal.EdgeCallback<NameInfo, JSModule> {
        private PropagateReferences() {
        }

        @Override
        public boolean traverseEdge(NameInfo start, JSModule edge, NameInfo dest) {
            if (start.isReferenced()) {
                JSModule startModule = start.getDeepestCommonModuleRef();
                if (startModule != null && AnalyzePrototypeProperties.this.moduleGraph.dependsOn(startModule, edge)) {
                    return dest.markReference(startModule);
                }
                return dest.markReference(edge);
            }
            return false;
        }
    }

    private class ProcessExternProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.externNode, AnalyzePrototypeProperties.this.firstModule, AnalyzePrototypeProperties.this.getNameInfoForName(n.getLastChild().getString(), PROPERTY));
            }
        }
    }

    private class ProcessProperties
    implements NodeTraversal.ScopedCallback {
        private final Stack<NameContext> symbolStack = new Stack();

        private ProcessProperties() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Node n = t.getCurrentNode();
            Scope scope = t.getScope();
            Node root = scope.getRootNode();
            if (root.isFunction()) {
                String propName = this.getPrototypePropertyNameFromRValue(n);
                if (propName != null) {
                    this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(propName, PROPERTY), scope));
                } else if (this.isGlobalFunctionDeclaration(t, n)) {
                    Node parent = n.getParent();
                    String name = parent.isName() ? parent.getString() : n.getFirstChild().getString();
                    this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(name, VAR), scope.getClosestHoistScope()));
                } else {
                    this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.anonymousNode, scope));
                }
            } else if (t.inGlobalScope()) {
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.globalNode, scope));
            } else {
                Preconditions.checkState((boolean)NodeUtil.createsBlockScope(root), (Object)scope);
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.anonymousNode, scope));
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            this.symbolStack.pop();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            String propName = this.processNonFunctionPrototypeAssign(n, parent);
            if (propName != null) {
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(propName, PROPERTY), null));
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                String propName = n.getSecondChild().getString();
                if (n.isQualifiedName()) {
                    if (propName.equals("prototype")) {
                        if (this.processPrototypeRef(t, n)) {
                            return;
                        }
                    } else {
                        String rValueName;
                        if (AnalyzePrototypeProperties.this.compiler.getCodingConvention().isExported(propName)) {
                            this.addGlobalUseOfSymbol(propName, t.getModule(), PROPERTY);
                            return;
                        }
                        if (n.getParent().isAssign() && n.getNext() != null && (rValueName = this.getPrototypePropertyNameFromRValue(n)) != null) {
                            return;
                        }
                    }
                }
                this.addSymbolUse(propName, t.getModule(), PROPERTY);
            } else if (n.isObjectLit()) {
                String lValueName = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(n));
                if (lValueName != null && lValueName.endsWith(".prototype")) {
                    return;
                }
                for (Node propNameNode = n.getFirstChild(); propNameNode != null; propNameNode = propNameNode.getNext()) {
                    if (propNameNode.isQuotedString()) continue;
                    this.addSymbolUse(propNameNode.getString(), t.getModule(), PROPERTY);
                }
            } else if (n.isName()) {
                String name = n.getString();
                Var var = t.getScope().getVar(name);
                if (var != null) {
                    if (var.isGlobal()) {
                        if (var.getInitialValue() != null && var.getInitialValue().isFunction()) {
                            if (t.inGlobalHoistScope()) {
                                if (!this.processGlobalFunctionDeclaration(t, n, var)) {
                                    this.addGlobalUseOfSymbol(name, t.getModule(), VAR);
                                }
                            } else {
                                this.addSymbolUse(name, t.getModule(), VAR);
                            }
                        }
                    } else if (var.getScope() != t.getScope()) {
                        for (int i = this.symbolStack.size() - 1; i >= 0; --i) {
                            NameContext context = (NameContext)this.symbolStack.get(i);
                            if (context.scope != var.getScope()) {
                                context.name.readClosureVariables = true;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (this.processNonFunctionPrototypeAssign(n, parent) != null) {
                this.symbolStack.pop();
            }
        }

        private void addSymbolUse(String name, JSModule module, SymbolType type) {
            NameInfo info = AnalyzePrototypeProperties.this.getNameInfoForName(name, type);
            Object def = null;
            for (int i = this.symbolStack.size() - 1; i >= 0 && (def = ((NameContext)this.symbolStack.get((int)i)).name) == AnalyzePrototypeProperties.this.anonymousNode; --i) {
            }
            if (!def.equals(info)) {
                AnalyzePrototypeProperties.this.symbolGraph.connect(def, module, info);
            }
        }

        private String processNonFunctionPrototypeAssign(Node n, Node parent) {
            if (this.isAssignRValue(n, parent) && !n.isFunction()) {
                return this.getPrototypePropertyNameFromRValue(n);
            }
            return null;
        }

        private boolean isGlobalFunctionDeclaration(NodeTraversal t, Node n) {
            if (!(t.inGlobalHoistScope() || n.isFunction() && t.getScopeRoot() == n && t.getScope().getParent().getClosestHoistScope().isGlobal())) {
                return false;
            }
            return NodeUtil.isFunctionDeclaration(n) || n.isFunction() && n.getParent().isName();
        }

        private boolean isAssignRValue(Node n, Node parent) {
            return parent != null && parent.isAssign() && parent.getFirstChild() != n;
        }

        private String getPrototypePropertyNameFromRValue(Node rValue) {
            Node lValue = NodeUtil.getBestLValue(rValue);
            if (lValue == null || lValue.getParent() == null || lValue.getGrandparent() == null || (!NodeUtil.isObjectLitKey(lValue) || lValue.isQuotedString()) && !NodeUtil.isExprAssign(lValue.getGrandparent())) {
                return null;
            }
            String lValueName = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(rValue));
            if (lValueName == null) {
                return null;
            }
            int lastDot = lValueName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            String firstPart = lValueName.substring(0, lastDot);
            if (!firstPart.endsWith(".prototype")) {
                return null;
            }
            return lValueName.substring(lastDot + 1);
        }

        private boolean processGlobalFunctionDeclaration(NodeTraversal t, Node nameNode, Var v) {
            Node firstChild = nameNode.getFirstChild();
            Node parent = nameNode.getParent();
            if (this.isGlobalFunctionDeclaration(t, parent) || firstChild != null && this.isGlobalFunctionDeclaration(t, firstChild)) {
                String name = nameNode.getString();
                AnalyzePrototypeProperties.this.getNameInfoForName(name, VAR).getDeclarations().add(new GlobalFunction(nameNode, v, t.getModule()));
                if (AnalyzePrototypeProperties.this.compiler.getCodingConvention().isExported(name) || AnalyzePrototypeProperties.this.anchorUnusedVars) {
                    this.addGlobalUseOfSymbol(name, t.getModule(), VAR);
                }
                return true;
            }
            return false;
        }

        private boolean processPrototypeRef(NodeTraversal t, Node ref) {
            Node root = NodeUtil.getRootOfQualifiedName(ref);
            Node n = ref.getParent();
            switch (n.getType()) {
                case 33: {
                    Node dest = n.getSecondChild();
                    Node parent = n.getParent();
                    Node grandParent = parent.getParent();
                    if (!dest.isString() || !NodeUtil.isExprAssign(grandParent) || !NodeUtil.isVarOrSimpleAssignLhs(n, parent)) break;
                    String name = dest.getString();
                    AssignmentProperty prop = new AssignmentProperty(grandParent, this.maybeGetVar(t, root), t.getModule());
                    AnalyzePrototypeProperties.this.getNameInfoForName(name, PROPERTY).getDeclarations().add(prop);
                    return true;
                }
                case 86: {
                    Node map = n.getSecondChild();
                    if (!map.isObjectLit()) break;
                    for (Node key = map.getFirstChild(); key != null; key = key.getNext()) {
                        if (key.isQuotedString()) continue;
                        String name = key.getString();
                        LiteralProperty prop = new LiteralProperty(key, key.getFirstChild(), map, n, this.maybeGetVar(t, root), t.getModule());
                        AnalyzePrototypeProperties.this.getNameInfoForName(name, PROPERTY).getDeclarations().add(prop);
                    }
                    return true;
                }
            }
            return false;
        }

        private Var maybeGetVar(NodeTraversal t, Node maybeName) {
            return maybeName.isName() ? t.getScope().getVar(maybeName.getString()) : null;
        }

        private void addGlobalUseOfSymbol(String name, JSModule module, SymbolType type) {
            AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.globalNode, module, AnalyzePrototypeProperties.this.getNameInfoForName(name, type));
        }
    }
}

