/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class DateTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final long value;
    private final boolean dateOnly;
    private final int tzShift;

    public DateTime(Date date, TimeZone zone) {
        this(false, date.getTime(), zone == null ? null : Integer.valueOf(zone.getOffset(date.getTime()) / 60000));
    }

    public DateTime(long value) {
        this(false, value, null);
    }

    public DateTime(Date value) {
        this(value.getTime());
    }

    public DateTime(long value, int tzShift) {
        this(false, value, tzShift);
    }

    public DateTime(boolean dateOnly, long value, Integer tzShift) {
        this.dateOnly = dateOnly;
        this.value = value;
        this.tzShift = dateOnly ? 0 : (tzShift == null ? TimeZone.getDefault().getOffset(value) / 60000 : tzShift);
    }

    public DateTime(String value) {
        DateTime dateTime = DateTime.parseRfc3339(value);
        this.dateOnly = dateTime.dateOnly;
        this.value = dateTime.value;
        this.tzShift = dateTime.tzShift;
    }

    public long getValue() {
        return this.value;
    }

    public boolean isDateOnly() {
        return this.dateOnly;
    }

    public int getTimeZoneShift() {
        return this.tzShift;
    }

    public String toStringRfc3339() {
        StringBuilder sb = new StringBuilder();
        GregorianCalendar dateTime = new GregorianCalendar(GMT);
        long localTime = this.value + (long)(this.tzShift * 60000);
        dateTime.setTimeInMillis(localTime);
        DateTime.appendInt(sb, dateTime.get(1), 4);
        sb.append('-');
        DateTime.appendInt(sb, dateTime.get(2) + 1, 2);
        sb.append('-');
        DateTime.appendInt(sb, dateTime.get(5), 2);
        if (!this.dateOnly) {
            sb.append('T');
            DateTime.appendInt(sb, dateTime.get(11), 2);
            sb.append(':');
            DateTime.appendInt(sb, dateTime.get(12), 2);
            sb.append(':');
            DateTime.appendInt(sb, dateTime.get(13), 2);
            if (dateTime.isSet(14)) {
                sb.append('.');
                DateTime.appendInt(sb, dateTime.get(14), 3);
            }
            if (this.tzShift == 0) {
                sb.append('Z');
            } else {
                int absTzShift = this.tzShift;
                if (this.tzShift > 0) {
                    sb.append('+');
                } else {
                    sb.append('-');
                    absTzShift = -absTzShift;
                }
                int tzHours = absTzShift / 60;
                int tzMinutes = absTzShift % 60;
                DateTime.appendInt(sb, tzHours, 2);
                sb.append(':');
                DateTime.appendInt(sb, tzMinutes, 2);
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toStringRfc3339();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateTime)) {
            return false;
        }
        DateTime other = (DateTime)o;
        return this.dateOnly == other.dateOnly && this.value == other.value && this.tzShift == other.tzShift;
    }

    public static DateTime parseRfc3339(String str) throws NumberFormatException {
        try {
            int tzIndex;
            int year = Integer.parseInt(str.substring(0, 4));
            int month = Integer.parseInt(str.substring(5, 7)) - 1;
            int day = Integer.parseInt(str.substring(8, 10));
            int length = str.length();
            boolean dateOnly = length <= 10 || Character.toUpperCase(str.charAt(10)) != 'T';
            int hourOfDay = 0;
            int minute = 0;
            int second = 0;
            int milliseconds = 0;
            Integer tzShiftInteger = null;
            if (dateOnly) {
                tzIndex = Integer.MAX_VALUE;
            } else {
                hourOfDay = Integer.parseInt(str.substring(11, 13));
                minute = Integer.parseInt(str.substring(14, 16));
                second = Integer.parseInt(str.substring(17, 19));
                if (str.charAt(19) == '.') {
                    milliseconds = Integer.parseInt(str.substring(20, 23));
                    tzIndex = 23;
                } else {
                    tzIndex = 19;
                }
            }
            GregorianCalendar dateTime = new GregorianCalendar(GMT);
            dateTime.set(year, month, day, hourOfDay, minute, second);
            dateTime.set(14, milliseconds);
            long value = dateTime.getTimeInMillis();
            if (length > tzIndex) {
                int tzShift;
                if (Character.toUpperCase(str.charAt(tzIndex)) == 'Z') {
                    tzShift = 0;
                } else {
                    tzShift = Integer.parseInt(str.substring(tzIndex + 1, tzIndex + 3)) * 60 + Integer.parseInt(str.substring(tzIndex + 4, tzIndex + 6));
                    if (str.charAt(tzIndex) == '-') {
                        tzShift = -tzShift;
                    }
                    value -= (long)(tzShift * 60000);
                }
                tzShiftInteger = tzShift;
            }
            return new DateTime(dateOnly, value, tzShiftInteger);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new NumberFormatException("Invalid date/time format: " + str);
        }
    }

    private static void appendInt(StringBuilder sb, int num, int numDigits) {
        if (num < 0) {
            sb.append('-');
            num = -num;
        }
        int x = num;
        while (x > 0) {
            x /= 10;
            --numDigits;
        }
        for (int i = 0; i < numDigits; ++i) {
            sb.append('0');
        }
        if (num != 0) {
            sb.append(num);
        }
    }
}

