/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpRequest;
import com.google.api.client.util.SslUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public final class NetHttpTransport
extends HttpTransport {
    private static final String[] SUPPORTED_METHODS = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
    private final Proxy proxy;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;

    public NetHttpTransport() {
        this(null, null, null);
    }

    NetHttpTransport(Proxy proxy, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
        this.proxy = proxy;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
    }

    public boolean supportsMethod(String method) {
        return Arrays.binarySearch(SUPPORTED_METHODS, method) >= 0;
    }

    protected NetHttpRequest buildRequest(String method, String url) throws IOException {
        Preconditions.checkArgument((boolean)this.supportsMethod(method), (String)"HTTP method %s not supported", (Object[])new Object[]{method});
        URL connUrl = new URL(url);
        URLConnection conn = this.proxy == null ? connUrl.openConnection() : connUrl.openConnection(this.proxy);
        HttpURLConnection connection = (HttpURLConnection)conn;
        connection.setRequestMethod(method);
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
            if (this.hostnameVerifier != null) {
                secureConnection.setHostnameVerifier(this.hostnameVerifier);
            }
            if (this.sslSocketFactory != null) {
                secureConnection.setSSLSocketFactory(this.sslSocketFactory);
            }
        }
        return new NetHttpRequest(connection);
    }

    @Deprecated
    public boolean supportsHead() {
        return true;
    }

    @Deprecated
    public NetHttpRequest buildDeleteRequest(String url) throws IOException {
        return this.buildRequest("DELETE", url);
    }

    @Deprecated
    public NetHttpRequest buildGetRequest(String url) throws IOException {
        return this.buildRequest("GET", url);
    }

    @Deprecated
    public NetHttpRequest buildHeadRequest(String url) throws IOException {
        return this.buildRequest("HEAD", url);
    }

    @Deprecated
    public NetHttpRequest buildPostRequest(String url) throws IOException {
        return this.buildRequest("POST", url);
    }

    @Deprecated
    public NetHttpRequest buildPutRequest(String url) throws IOException {
        return this.buildRequest("PUT", url);
    }

    static {
        Arrays.sort(SUPPORTED_METHODS);
    }

    public static final class Builder {
        private SSLSocketFactory sslSocketFactory;
        private HostnameVerifier hostnameVerifier;
        private Proxy proxy;

        public Builder setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder doNotValidateCertificate() throws GeneralSecurityException {
            this.hostnameVerifier = SslUtils.trustAllHostnameVerifier();
            this.sslSocketFactory = SslUtils.trustAllSSLContext().getSocketFactory();
            return this;
        }

        public SSLSocketFactory getSslSocketFactory() {
            return this.sslSocketFactory;
        }

        public Builder setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public HostnameVerifier getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public Builder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public NetHttpTransport build() {
            return new NetHttpTransport(this.proxy, this.sslSocketFactory, this.hostnameVerifier);
        }
    }
}

