/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "th" locale.
 */
public class LocalizedNamesImpl_th extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "TH",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "GR",
        "GL",
        "GU",
        "GP",
        "KH",
        "GT",
        "QA",
        "GH",
        "GA",
        "GY",
        "GN",
        "GW",
        "GD",
        "KR",
        "KP",
        "CX",
        "CP",
        "GS",
        "NF",
        "BV",
        "IM",
        "AC",
        "HM",
        "GG",
        "GM",
        "CI",
        "MO",
        "HK",
        "CD",
        "CG",
        "KM",
        "CR",
        "KZ",
        "KI",
        "CU",
        "KG",
        "CW",
        "KW",
        "KE",
        "CV",
        "CA",
        "CM",
        "XK",
        "HR",
        "CO",
        "GE",
        "JO",
        "JM",
        "DJ",
        "CN",
        "JE",
        "TD",
        "CL",
        "CZ",
        "SM",
        "WS",
        "SA",
        "EH",
        "SX",
        "ZW",
        "SY",
        "SD",
        "SS",
        "SR",
        "SC",
        "KN",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "SN",
        "EA",
        "RS",
        "ST",
        "SL",
        "PM",
        "ZM",
        "SO",
        "CY",
        "JP",
        "PS",
        "DG",
        "DK",
        "DM",
        "TT",
        "TO",
        "TL",
        "TR",
        "TN",
        "TV",
        "TM",
        "TK",
        "TG",
        "TW",
        "TA",
        "TJ",
        "TZ",
        "TH",
        "VA",
        "NO",
        "NA",
        "NR",
        "NI",
        "NC",
        "NZ",
        "NU",
        "NL",
        "BQ",
        "NP",
        "NG",
        "NE",
        "BR",
        "IO",
        "BN",
        "BW",
        "BA",
        "BD",
        "BG",
        "BB",
        "BH",
        "BS",
        "BI",
        "BF",
        "BJ",
        "BE",
        "BY",
        "BZ",
        "BM",
        "BO",
        "PK",
        "PA",
        "PG",
        "PY",
        "PW",
        "PE",
        "PR",
        "PT",
        "PL",
        "FR",
        "FJ",
        "FI",
        "PH",
        "GF",
        "TF",
        "PF",
        "BT",
        "MN",
        "MS",
        "ME",
        "MU",
        "MR",
        "MD",
        "MT",
        "MV",
        "MK",
        "MG",
        "YT",
        "MQ",
        "MW",
        "ML",
        "MY",
        "MX",
        "MM",
        "MZ",
        "MC",
        "MA",
        "FM",
        "GI",
        "UG",
        "UA",
        "EZ",
        "YE",
        "DE",
        "RW",
        "RU",
        "RE",
        "RO",
        "LU",
        "LV",
        "LA",
        "LI",
        "LT",
        "LY",
        "LS",
        "LB",
        "LR",
        "VU",
        "WF",
        "VE",
        "VN",
        "LK",
        "ES",
        "SJ",
        "SK",
        "SI",
        "SZ",
        "CH",
        "SE",
        "UN",
        "EU",
        "US",
        "AE",
        "GB",
        "DO",
        "CF",
        "SG",
        "IC",
        "CK",
        "KY",
        "CC",
        "SB",
        "TC",
        "MP",
        "VG",
        "PN",
        "FK",
        "FO",
        "MH",
        "UM",
        "VI",
        "AX",
        "AS",
        "AU",
        "AT",
        "AD",
        "AF",
        "AZ",
        "AR",
        "AM",
        "AW",
        "GQ",
        "IT",
        "IN",
        "ID",
        "IQ",
        "IL",
        "IR",
        "EG",
        "UZ",
        "UY",
        "EC",
        "ET",
        "ER",
        "SV",
        "EE",
        "QO",
        "AI",
        "AO",
        "AQ",
        "AG",
        "ZA",
        "DZ",
        "AL",
        "OM",
        "IS",
        "IE",
        "HN",
        "HU",
        "HT",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "โลก");
    namesMap.put("002", "แอฟริกา");
    namesMap.put("003", "อเมริกาเหนือ");
    namesMap.put("005", "อเมริกาใต้");
    namesMap.put("009", "โอเชียเนีย");
    namesMap.put("011", "แอฟริกาตะวันตก");
    namesMap.put("013", "อเมริกากลาง");
    namesMap.put("014", "แอฟริกาตะวันออก");
    namesMap.put("015", "แอฟริกาเหนือ");
    namesMap.put("017", "แอฟริกากลาง");
    namesMap.put("018", "แอฟริกาตอนใต้");
    namesMap.put("019", "อเมริกา");
    namesMap.put("021", "อเมริกาตอนเหนือ");
    namesMap.put("029", "แคริบเบียน");
    namesMap.put("030", "เอเชียตะวันออก");
    namesMap.put("034", "เอเชียใต้");
    namesMap.put("035", "เอเชียตะวันออกเฉียงใต้");
    namesMap.put("039", "ยุโรปใต้");
    namesMap.put("053", "ออสตราเลเซีย");
    namesMap.put("054", "เมลานีเซีย");
    namesMap.put("057", "เขตไมโครนีเซีย");
    namesMap.put("061", "โปลินีเซีย");
    namesMap.put("142", "เอเชีย");
    namesMap.put("143", "เอเชียกลาง");
    namesMap.put("145", "เอเชียตะวันตก");
    namesMap.put("150", "ยุโรป");
    namesMap.put("151", "ยุโรปตะวันออก");
    namesMap.put("154", "ยุโรปเหนือ");
    namesMap.put("155", "ยุโรปตะวันตก");
    namesMap.put("202", "แอฟริกาใต้สะฮารา");
    namesMap.put("419", "ละตินอเมริกา");
    namesMap.put("AC", "เกาะแอสเซนชัน");
    namesMap.put("AD", "อันดอร์รา");
    namesMap.put("AE", "สหรัฐอาหรับเอมิเรตส์");
    namesMap.put("AF", "อัฟกานิสถาน");
    namesMap.put("AG", "แอนติกาและบาร์บูดา");
    namesMap.put("AI", "แองกวิลลา");
    namesMap.put("AL", "แอลเบเนีย");
    namesMap.put("AM", "อาร์เมเนีย");
    namesMap.put("AO", "แองโกลา");
    namesMap.put("AQ", "แอนตาร์กติกา");
    namesMap.put("AR", "อาร์เจนตินา");
    namesMap.put("AS", "อเมริกันซามัว");
    namesMap.put("AT", "ออสเตรีย");
    namesMap.put("AU", "ออสเตรเลีย");
    namesMap.put("AW", "อารูบา");
    namesMap.put("AX", "หมู่เกาะโอลันด์");
    namesMap.put("AZ", "อาเซอร์ไบจาน");
    namesMap.put("BA", "บอสเนียและเฮอร์เซโกวีนา");
    namesMap.put("BB", "บาร์เบโดส");
    namesMap.put("BD", "บังกลาเทศ");
    namesMap.put("BE", "เบลเยียม");
    namesMap.put("BF", "บูร์กินาฟาโซ");
    namesMap.put("BG", "บัลแกเรีย");
    namesMap.put("BH", "บาห์เรน");
    namesMap.put("BI", "บุรุนดี");
    namesMap.put("BJ", "เบนิน");
    namesMap.put("BL", "เซนต์บาร์เธเลมี");
    namesMap.put("BM", "เบอร์มิวดา");
    namesMap.put("BN", "บรูไน");
    namesMap.put("BO", "โบลิเวีย");
    namesMap.put("BQ", "เนเธอร์แลนด์แคริบเบียน");
    namesMap.put("BR", "บราซิล");
    namesMap.put("BS", "บาฮามาส");
    namesMap.put("BT", "ภูฏาน");
    namesMap.put("BV", "เกาะบูเวต");
    namesMap.put("BW", "บอตสวานา");
    namesMap.put("BY", "เบลารุส");
    namesMap.put("BZ", "เบลีซ");
    namesMap.put("CA", "แคนาดา");
    namesMap.put("CC", "หมู่เกาะโคโคส (คีลิง)");
    namesMap.put("CD", "คองโก - กินชาซา");
    namesMap.put("CF", "สาธารณรัฐแอฟริกากลาง");
    namesMap.put("CG", "คองโก - บราซซาวิล");
    namesMap.put("CH", "สวิตเซอร์แลนด์");
    namesMap.put("CI", "โกตดิวัวร์");
    namesMap.put("CK", "หมู่เกาะคุก");
    namesMap.put("CL", "ชิลี");
    namesMap.put("CM", "แคเมอรูน");
    namesMap.put("CN", "จีน");
    namesMap.put("CO", "โคลอมเบีย");
    namesMap.put("CP", "เกาะคลิปเปอร์ตัน");
    namesMap.put("CR", "คอสตาริกา");
    namesMap.put("CU", "คิวบา");
    namesMap.put("CV", "เคปเวิร์ด");
    namesMap.put("CW", "คูราเซา");
    namesMap.put("CX", "เกาะคริสต์มาส");
    namesMap.put("CY", "ไซปรัส");
    namesMap.put("CZ", "เช็ก");
    namesMap.put("DE", "เยอรมนี");
    namesMap.put("DG", "ดิเอโกการ์เซีย");
    namesMap.put("DJ", "จิบูตี");
    namesMap.put("DK", "เดนมาร์ก");
    namesMap.put("DM", "โดมินิกา");
    namesMap.put("DO", "สาธารณรัฐโดมินิกัน");
    namesMap.put("DZ", "แอลจีเรีย");
    namesMap.put("EA", "เซวตาและเมลียา");
    namesMap.put("EC", "เอกวาดอร์");
    namesMap.put("EE", "เอสโตเนีย");
    namesMap.put("EG", "อียิปต์");
    namesMap.put("EH", "ซาฮาราตะวันตก");
    namesMap.put("ER", "เอริเทรีย");
    namesMap.put("ES", "สเปน");
    namesMap.put("ET", "เอธิโอเปีย");
    namesMap.put("EU", "สหภาพยุโรป");
    namesMap.put("EZ", "ยูโรโซน");
    namesMap.put("FI", "ฟินแลนด์");
    namesMap.put("FJ", "ฟิจิ");
    namesMap.put("FK", "หมู่เกาะฟอล์กแลนด์");
    namesMap.put("FM", "ไมโครนีเซีย");
    namesMap.put("FO", "หมู่เกาะแฟโร");
    namesMap.put("FR", "ฝรั่งเศส");
    namesMap.put("GA", "กาบอง");
    namesMap.put("GB", "สหราชอาณาจักร");
    namesMap.put("GD", "เกรเนดา");
    namesMap.put("GE", "จอร์เจีย");
    namesMap.put("GF", "เฟรนช์เกียนา");
    namesMap.put("GG", "เกิร์นซีย์");
    namesMap.put("GH", "กานา");
    namesMap.put("GI", "ยิบรอลตาร์");
    namesMap.put("GL", "กรีนแลนด์");
    namesMap.put("GM", "แกมเบีย");
    namesMap.put("GN", "กินี");
    namesMap.put("GP", "กวาเดอลูป");
    namesMap.put("GQ", "อิเควทอเรียลกินี");
    namesMap.put("GR", "กรีซ");
    namesMap.put("GS", "เกาะเซาท์จอร์เจียและหมู่เกาะเซาท์แซนด์วิช");
    namesMap.put("GT", "กัวเตมาลา");
    namesMap.put("GU", "กวม");
    namesMap.put("GW", "กินี-บิสเซา");
    namesMap.put("GY", "กายอานา");
    namesMap.put("HK", "เขตปกครองพิเศษฮ่องกงแห่งสาธารณรัฐประชาชนจีน");
    namesMap.put("HM", "เกาะเฮิร์ดและหมู่เกาะแมกดอนัลด์");
    namesMap.put("HN", "ฮอนดูรัส");
    namesMap.put("HR", "โครเอเชีย");
    namesMap.put("HT", "เฮติ");
    namesMap.put("HU", "ฮังการี");
    namesMap.put("IC", "หมู่เกาะคานารี");
    namesMap.put("ID", "อินโดนีเซีย");
    namesMap.put("IE", "ไอร์แลนด์");
    namesMap.put("IL", "อิสราเอล");
    namesMap.put("IM", "เกาะแมน");
    namesMap.put("IN", "อินเดีย");
    namesMap.put("IO", "บริติชอินเดียนโอเชียนเทร์ริทอรี");
    namesMap.put("IQ", "อิรัก");
    namesMap.put("IR", "อิหร่าน");
    namesMap.put("IS", "ไอซ์แลนด์");
    namesMap.put("IT", "อิตาลี");
    namesMap.put("JE", "เจอร์ซีย์");
    namesMap.put("JM", "จาเมกา");
    namesMap.put("JO", "จอร์แดน");
    namesMap.put("JP", "ญี่ปุ่น");
    namesMap.put("KE", "เคนยา");
    namesMap.put("KG", "คีร์กีซสถาน");
    namesMap.put("KH", "กัมพูชา");
    namesMap.put("KI", "คิริบาส");
    namesMap.put("KM", "คอโมโรส");
    namesMap.put("KN", "เซนต์คิตส์และเนวิส");
    namesMap.put("KP", "เกาหลีเหนือ");
    namesMap.put("KR", "เกาหลีใต้");
    namesMap.put("KW", "คูเวต");
    namesMap.put("KY", "หมู่เกาะเคย์แมน");
    namesMap.put("KZ", "คาซัคสถาน");
    namesMap.put("LA", "ลาว");
    namesMap.put("LB", "เลบานอน");
    namesMap.put("LC", "เซนต์ลูเซีย");
    namesMap.put("LI", "ลิกเตนสไตน์");
    namesMap.put("LK", "ศรีลังกา");
    namesMap.put("LR", "ไลบีเรีย");
    namesMap.put("LS", "เลโซโท");
    namesMap.put("LT", "ลิทัวเนีย");
    namesMap.put("LU", "ลักเซมเบิร์ก");
    namesMap.put("LV", "ลัตเวีย");
    namesMap.put("LY", "ลิเบีย");
    namesMap.put("MA", "โมร็อกโก");
    namesMap.put("MC", "โมนาโก");
    namesMap.put("MD", "มอลโดวา");
    namesMap.put("ME", "มอนเตเนโกร");
    namesMap.put("MF", "เซนต์มาร์ติน");
    namesMap.put("MG", "มาดากัสการ์");
    namesMap.put("MH", "หมู่เกาะมาร์แชลล์");
    namesMap.put("MK", "มาซิโดเนีย");
    namesMap.put("ML", "มาลี");
    namesMap.put("MM", "เมียนมาร์ (พม่า)");
    namesMap.put("MN", "มองโกเลีย");
    namesMap.put("MO", "เขตปกครองพิเศษมาเก๊าแห่งสาธารณรัฐประชาชนจีน");
    namesMap.put("MP", "หมู่เกาะนอร์เทิร์นมาเรียนา");
    namesMap.put("MQ", "มาร์ตินีก");
    namesMap.put("MR", "มอริเตเนีย");
    namesMap.put("MS", "มอนต์เซอร์รัต");
    namesMap.put("MT", "มอลตา");
    namesMap.put("MU", "มอริเชียส");
    namesMap.put("MV", "มัลดีฟส์");
    namesMap.put("MW", "มาลาวี");
    namesMap.put("MX", "เม็กซิโก");
    namesMap.put("MY", "มาเลเซีย");
    namesMap.put("MZ", "โมซัมบิก");
    namesMap.put("NA", "นามิเบีย");
    namesMap.put("NC", "นิวแคลิโดเนีย");
    namesMap.put("NE", "ไนเจอร์");
    namesMap.put("NF", "เกาะนอร์ฟอล์ก");
    namesMap.put("NG", "ไนจีเรีย");
    namesMap.put("NI", "นิการากัว");
    namesMap.put("NL", "เนเธอร์แลนด์");
    namesMap.put("NO", "นอร์เวย์");
    namesMap.put("NP", "เนปาล");
    namesMap.put("NR", "นาอูรู");
    namesMap.put("NU", "นีอูเอ");
    namesMap.put("NZ", "นิวซีแลนด์");
    namesMap.put("OM", "โอมาน");
    namesMap.put("PA", "ปานามา");
    namesMap.put("PE", "เปรู");
    namesMap.put("PF", "เฟรนช์โปลินีเซีย");
    namesMap.put("PG", "ปาปัวนิวกินี");
    namesMap.put("PH", "ฟิลิปปินส์");
    namesMap.put("PK", "ปากีสถาน");
    namesMap.put("PL", "โปแลนด์");
    namesMap.put("PM", "แซงปีแยร์และมีเกอลง");
    namesMap.put("PN", "หมู่เกาะพิตแคร์น");
    namesMap.put("PR", "เปอร์โตริโก");
    namesMap.put("PS", "ดินแดนปาเลสไตน์");
    namesMap.put("PT", "โปรตุเกส");
    namesMap.put("PW", "ปาเลา");
    namesMap.put("PY", "ปารากวัย");
    namesMap.put("QA", "กาตาร์");
    namesMap.put("QO", "เอาต์ไลอิงโอเชียเนีย");
    namesMap.put("RE", "เรอูนียง");
    namesMap.put("RO", "โรมาเนีย");
    namesMap.put("RS", "เซอร์เบีย");
    namesMap.put("RU", "รัสเซีย");
    namesMap.put("RW", "รวันดา");
    namesMap.put("SA", "ซาอุดีอาระเบีย");
    namesMap.put("SB", "หมู่เกาะโซโลมอน");
    namesMap.put("SC", "เซเชลส์");
    namesMap.put("SD", "ซูดาน");
    namesMap.put("SE", "สวีเดน");
    namesMap.put("SG", "สิงคโปร์");
    namesMap.put("SH", "เซนต์เฮเลนา");
    namesMap.put("SI", "สโลวีเนีย");
    namesMap.put("SJ", "สฟาลบาร์และยานไมเอน");
    namesMap.put("SK", "สโลวะเกีย");
    namesMap.put("SL", "เซียร์ราลีโอน");
    namesMap.put("SM", "ซานมาริโน");
    namesMap.put("SN", "เซเนกัล");
    namesMap.put("SO", "โซมาเลีย");
    namesMap.put("SR", "ซูรินาเม");
    namesMap.put("SS", "ซูดานใต้");
    namesMap.put("ST", "เซาตูเมและปรินซิปี");
    namesMap.put("SV", "เอลซัลวาดอร์");
    namesMap.put("SX", "ซินต์มาร์เทน");
    namesMap.put("SY", "ซีเรีย");
    namesMap.put("SZ", "สวาซิแลนด์");
    namesMap.put("TA", "ทริสตันดาคูนา");
    namesMap.put("TC", "หมู่เกาะเติกส์และหมู่เกาะเคคอส");
    namesMap.put("TD", "ชาด");
    namesMap.put("TF", "เฟรนช์เซาเทิร์นเทร์ริทอรีส์");
    namesMap.put("TG", "โตโก");
    namesMap.put("TH", "ไทย");
    namesMap.put("TJ", "ทาจิกิสถาน");
    namesMap.put("TK", "โตเกเลา");
    namesMap.put("TL", "ติมอร์-เลสเต");
    namesMap.put("TM", "เติร์กเมนิสถาน");
    namesMap.put("TN", "ตูนิเซีย");
    namesMap.put("TO", "ตองกา");
    namesMap.put("TR", "ตุรกี");
    namesMap.put("TT", "ตรินิแดดและโตเบโก");
    namesMap.put("TV", "ตูวาลู");
    namesMap.put("TW", "ไต้หวัน");
    namesMap.put("TZ", "แทนซาเนีย");
    namesMap.put("UA", "ยูเครน");
    namesMap.put("UG", "ยูกันดา");
    namesMap.put("UM", "หมู่เกาะรอบนอกของสหรัฐอเมริกา");
    namesMap.put("UN", "สหประชาชาติ");
    namesMap.put("US", "สหรัฐอเมริกา");
    namesMap.put("UY", "อุรุกวัย");
    namesMap.put("UZ", "อุซเบกิสถาน");
    namesMap.put("VA", "นครวาติกัน");
    namesMap.put("VC", "เซนต์วินเซนต์และเกรนาดีนส์");
    namesMap.put("VE", "เวเนซุเอลา");
    namesMap.put("VG", "หมู่เกาะบริติชเวอร์จิน");
    namesMap.put("VI", "หมู่เกาะเวอร์จินของสหรัฐอเมริกา");
    namesMap.put("VN", "เวียดนาม");
    namesMap.put("VU", "วานูอาตู");
    namesMap.put("WF", "วาลลิสและฟุตูนา");
    namesMap.put("WS", "ซามัว");
    namesMap.put("XK", "โคโซโว");
    namesMap.put("YE", "เยเมน");
    namesMap.put("YT", "มายอต");
    namesMap.put("ZA", "แอฟริกาใต้");
    namesMap.put("ZM", "แซมเบีย");
    namesMap.put("ZW", "ซิมบับเว");
    namesMap.put("ZZ", "ภูมิภาคที่ไม่รู้จัก");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "โลก",
        "002": "แอฟริกา",
        "003": "อเมริกาเหนือ",
        "005": "อเมริกาใต้",
        "009": "โอเชียเนีย",
        "011": "แอฟริกาตะวันตก",
        "013": "อเมริกากลาง",
        "014": "แอฟริกาตะวันออก",
        "015": "แอฟริกาเหนือ",
        "017": "แอฟริกากลาง",
        "018": "แอฟริกาตอนใต้",
        "019": "อเมริกา",
        "021": "อเมริกาตอนเหนือ",
        "029": "แคริบเบียน",
        "030": "เอเชียตะวันออก",
        "034": "เอเชียใต้",
        "035": "เอเชียตะวันออกเฉียงใต้",
        "039": "ยุโรปใต้",
        "053": "ออสตราเลเซีย",
        "054": "เมลานีเซีย",
        "057": "เขตไมโครนีเซีย",
        "061": "โปลินีเซีย",
        "142": "เอเชีย",
        "143": "เอเชียกลาง",
        "145": "เอเชียตะวันตก",
        "150": "ยุโรป",
        "151": "ยุโรปตะวันออก",
        "154": "ยุโรปเหนือ",
        "155": "ยุโรปตะวันตก",
        "202": "แอฟริกาใต้สะฮารา",
        "419": "ละตินอเมริกา",
        "AC": "เกาะแอสเซนชัน",
        "AD": "อันดอร์รา",
        "AE": "สหรัฐอาหรับเอมิเรตส์",
        "AF": "อัฟกานิสถาน",
        "AG": "แอนติกาและบาร์บูดา",
        "AI": "แองกวิลลา",
        "AL": "แอลเบเนีย",
        "AM": "อาร์เมเนีย",
        "AO": "แองโกลา",
        "AQ": "แอนตาร์กติกา",
        "AR": "อาร์เจนตินา",
        "AS": "อเมริกันซามัว",
        "AT": "ออสเตรีย",
        "AU": "ออสเตรเลีย",
        "AW": "อารูบา",
        "AX": "หมู่เกาะโอลันด์",
        "AZ": "อาเซอร์ไบจาน",
        "BA": "บอสเนียและเฮอร์เซโกวีนา",
        "BB": "บาร์เบโดส",
        "BD": "บังกลาเทศ",
        "BE": "เบลเยียม",
        "BF": "บูร์กินาฟาโซ",
        "BG": "บัลแกเรีย",
        "BH": "บาห์เรน",
        "BI": "บุรุนดี",
        "BJ": "เบนิน",
        "BL": "เซนต์บาร์เธเลมี",
        "BM": "เบอร์มิวดา",
        "BN": "บรูไน",
        "BO": "โบลิเวีย",
        "BQ": "เนเธอร์แลนด์แคริบเบียน",
        "BR": "บราซิล",
        "BS": "บาฮามาส",
        "BT": "ภูฏาน",
        "BV": "เกาะบูเวต",
        "BW": "บอตสวานา",
        "BY": "เบลารุส",
        "BZ": "เบลีซ",
        "CA": "แคนาดา",
        "CC": "หมู่เกาะโคโคส (คีลิง)",
        "CD": "คองโก - กินชาซา",
        "CF": "สาธารณรัฐแอฟริกากลาง",
        "CG": "คองโก - บราซซาวิล",
        "CH": "สวิตเซอร์แลนด์",
        "CI": "โกตดิวัวร์",
        "CK": "หมู่เกาะคุก",
        "CL": "ชิลี",
        "CM": "แคเมอรูน",
        "CN": "จีน",
        "CO": "โคลอมเบีย",
        "CP": "เกาะคลิปเปอร์ตัน",
        "CR": "คอสตาริกา",
        "CU": "คิวบา",
        "CV": "เคปเวิร์ด",
        "CW": "คูราเซา",
        "CX": "เกาะคริสต์มาส",
        "CY": "ไซปรัส",
        "CZ": "เช็ก",
        "DE": "เยอรมนี",
        "DG": "ดิเอโกการ์เซีย",
        "DJ": "จิบูตี",
        "DK": "เดนมาร์ก",
        "DM": "โดมินิกา",
        "DO": "สาธารณรัฐโดมินิกัน",
        "DZ": "แอลจีเรีย",
        "EA": "เซวตาและเมลียา",
        "EC": "เอกวาดอร์",
        "EE": "เอสโตเนีย",
        "EG": "อียิปต์",
        "EH": "ซาฮาราตะวันตก",
        "ER": "เอริเทรีย",
        "ES": "สเปน",
        "ET": "เอธิโอเปีย",
        "EU": "สหภาพยุโรป",
        "EZ": "ยูโรโซน",
        "FI": "ฟินแลนด์",
        "FJ": "ฟิจิ",
        "FK": "หมู่เกาะฟอล์กแลนด์",
        "FM": "ไมโครนีเซีย",
        "FO": "หมู่เกาะแฟโร",
        "FR": "ฝรั่งเศส",
        "GA": "กาบอง",
        "GB": "สหราชอาณาจักร",
        "GD": "เกรเนดา",
        "GE": "จอร์เจีย",
        "GF": "เฟรนช์เกียนา",
        "GG": "เกิร์นซีย์",
        "GH": "กานา",
        "GI": "ยิบรอลตาร์",
        "GL": "กรีนแลนด์",
        "GM": "แกมเบีย",
        "GN": "กินี",
        "GP": "กวาเดอลูป",
        "GQ": "อิเควทอเรียลกินี",
        "GR": "กรีซ",
        "GS": "เกาะเซาท์จอร์เจียและหมู่เกาะเซาท์แซนด์วิช",
        "GT": "กัวเตมาลา",
        "GU": "กวม",
        "GW": "กินี-บิสเซา",
        "GY": "กายอานา",
        "HK": "เขตปกครองพิเศษฮ่องกงแห่งสาธารณรัฐประชาชนจีน",
        "HM": "เกาะเฮิร์ดและหมู่เกาะแมกดอนัลด์",
        "HN": "ฮอนดูรัส",
        "HR": "โครเอเชีย",
        "HT": "เฮติ",
        "HU": "ฮังการี",
        "IC": "หมู่เกาะคานารี",
        "ID": "อินโดนีเซีย",
        "IE": "ไอร์แลนด์",
        "IL": "อิสราเอล",
        "IM": "เกาะแมน",
        "IN": "อินเดีย",
        "IO": "บริติชอินเดียนโอเชียนเทร์ริทอรี",
        "IQ": "อิรัก",
        "IR": "อิหร่าน",
        "IS": "ไอซ์แลนด์",
        "IT": "อิตาลี",
        "JE": "เจอร์ซีย์",
        "JM": "จาเมกา",
        "JO": "จอร์แดน",
        "JP": "ญี่ปุ่น",
        "KE": "เคนยา",
        "KG": "คีร์กีซสถาน",
        "KH": "กัมพูชา",
        "KI": "คิริบาส",
        "KM": "คอโมโรส",
        "KN": "เซนต์คิตส์และเนวิส",
        "KP": "เกาหลีเหนือ",
        "KR": "เกาหลีใต้",
        "KW": "คูเวต",
        "KY": "หมู่เกาะเคย์แมน",
        "KZ": "คาซัคสถาน",
        "LA": "ลาว",
        "LB": "เลบานอน",
        "LC": "เซนต์ลูเซีย",
        "LI": "ลิกเตนสไตน์",
        "LK": "ศรีลังกา",
        "LR": "ไลบีเรีย",
        "LS": "เลโซโท",
        "LT": "ลิทัวเนีย",
        "LU": "ลักเซมเบิร์ก",
        "LV": "ลัตเวีย",
        "LY": "ลิเบีย",
        "MA": "โมร็อกโก",
        "MC": "โมนาโก",
        "MD": "มอลโดวา",
        "ME": "มอนเตเนโกร",
        "MF": "เซนต์มาร์ติน",
        "MG": "มาดากัสการ์",
        "MH": "หมู่เกาะมาร์แชลล์",
        "MK": "มาซิโดเนีย",
        "ML": "มาลี",
        "MM": "เมียนมาร์ (พม่า)",
        "MN": "มองโกเลีย",
        "MO": "เขตปกครองพิเศษมาเก๊าแห่งสาธารณรัฐประชาชนจีน",
        "MP": "หมู่เกาะนอร์เทิร์นมาเรียนา",
        "MQ": "มาร์ตินีก",
        "MR": "มอริเตเนีย",
        "MS": "มอนต์เซอร์รัต",
        "MT": "มอลตา",
        "MU": "มอริเชียส",
        "MV": "มัลดีฟส์",
        "MW": "มาลาวี",
        "MX": "เม็กซิโก",
        "MY": "มาเลเซีย",
        "MZ": "โมซัมบิก",
        "NA": "นามิเบีย",
        "NC": "นิวแคลิโดเนีย",
        "NE": "ไนเจอร์",
        "NF": "เกาะนอร์ฟอล์ก",
        "NG": "ไนจีเรีย",
        "NI": "นิการากัว",
        "NL": "เนเธอร์แลนด์",
        "NO": "นอร์เวย์",
        "NP": "เนปาล",
        "NR": "นาอูรู",
        "NU": "นีอูเอ",
        "NZ": "นิวซีแลนด์",
        "OM": "โอมาน",
        "PA": "ปานามา",
        "PE": "เปรู",
        "PF": "เฟรนช์โปลินีเซีย",
        "PG": "ปาปัวนิวกินี",
        "PH": "ฟิลิปปินส์",
        "PK": "ปากีสถาน",
        "PL": "โปแลนด์",
        "PM": "แซงปีแยร์และมีเกอลง",
        "PN": "หมู่เกาะพิตแคร์น",
        "PR": "เปอร์โตริโก",
        "PS": "ดินแดนปาเลสไตน์",
        "PT": "โปรตุเกส",
        "PW": "ปาเลา",
        "PY": "ปารากวัย",
        "QA": "กาตาร์",
        "QO": "เอาต์ไลอิงโอเชียเนีย",
        "RE": "เรอูนียง",
        "RO": "โรมาเนีย",
        "RS": "เซอร์เบีย",
        "RU": "รัสเซีย",
        "RW": "รวันดา",
        "SA": "ซาอุดีอาระเบีย",
        "SB": "หมู่เกาะโซโลมอน",
        "SC": "เซเชลส์",
        "SD": "ซูดาน",
        "SE": "สวีเดน",
        "SG": "สิงคโปร์",
        "SH": "เซนต์เฮเลนา",
        "SI": "สโลวีเนีย",
        "SJ": "สฟาลบาร์และยานไมเอน",
        "SK": "สโลวะเกีย",
        "SL": "เซียร์ราลีโอน",
        "SM": "ซานมาริโน",
        "SN": "เซเนกัล",
        "SO": "โซมาเลีย",
        "SR": "ซูรินาเม",
        "SS": "ซูดานใต้",
        "ST": "เซาตูเมและปรินซิปี",
        "SV": "เอลซัลวาดอร์",
        "SX": "ซินต์มาร์เทน",
        "SY": "ซีเรีย",
        "SZ": "สวาซิแลนด์",
        "TA": "ทริสตันดาคูนา",
        "TC": "หมู่เกาะเติกส์และหมู่เกาะเคคอส",
        "TD": "ชาด",
        "TF": "เฟรนช์เซาเทิร์นเทร์ริทอรีส์",
        "TG": "โตโก",
        "TH": "ไทย",
        "TJ": "ทาจิกิสถาน",
        "TK": "โตเกเลา",
        "TL": "ติมอร์-เลสเต",
        "TM": "เติร์กเมนิสถาน",
        "TN": "ตูนิเซีย",
        "TO": "ตองกา",
        "TR": "ตุรกี",
        "TT": "ตรินิแดดและโตเบโก",
        "TV": "ตูวาลู",
        "TW": "ไต้หวัน",
        "TZ": "แทนซาเนีย",
        "UA": "ยูเครน",
        "UG": "ยูกันดา",
        "UM": "หมู่เกาะรอบนอกของสหรัฐอเมริกา",
        "UN": "สหประชาชาติ",
        "US": "สหรัฐอเมริกา",
        "UY": "อุรุกวัย",
        "UZ": "อุซเบกิสถาน",
        "VA": "นครวาติกัน",
        "VC": "เซนต์วินเซนต์และเกรนาดีนส์",
        "VE": "เวเนซุเอลา",
        "VG": "หมู่เกาะบริติชเวอร์จิน",
        "VI": "หมู่เกาะเวอร์จินของสหรัฐอเมริกา",
        "VN": "เวียดนาม",
        "VU": "วานูอาตู",
        "WF": "วาลลิสและฟุตูนา",
        "WS": "ซามัว",
        "XK": "โคโซโว",
        "YE": "เยเมน",
        "YT": "มายอต",
        "ZA": "แอฟริกาใต้",
        "ZM": "แซมเบีย",
        "ZW": "ซิมบับเว",
        "ZZ": "ภูมิภาคที่ไม่รู้จัก"
    };
  }-*/;
}
