/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "my" locale.
 */
public class LocalizedNamesImpl_my extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "MM",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "KE",
        "CM",
        "CA",
        "KH",
        "CP",
        "KZ",
        "QA",
        "IC",
        "BQ",
        "CC",
        "XK",
        "KM",
        "CO",
        "KW",
        "KY",
        "CR",
        "CU",
        "CK",
        "CD",
        "CG",
        "CX",
        "HR",
        "KG",
        "KI",
        "CW",
        "CV",
        "CZ",
        "TD",
        "CL",
        "GM",
        "GL",
        "GR",
        "GD",
        "GH",
        "GA",
        "GW",
        "GN",
        "GY",
        "GU",
        "GP",
        "JP",
        "JM",
        "JE",
        "DE",
        "GI",
        "DJ",
        "GE",
        "JO",
        "GG",
        "GT",
        "SG",
        "ES",
        "SJ",
        "SK",
        "SI",
        "KN",
        "ST",
        "PM",
        "VC",
        "BL",
        "MF",
        "LC",
        "SH",
        "SZ",
        "SX",
        "EA",
        "WS",
        "RS",
        "CY",
        "SO",
        "SN",
        "SL",
        "SY",
        "SD",
        "SR",
        "SM",
        "SA",
        "SB",
        "SC",
        "CH",
        "SE",
        "ZW",
        "ZM",
        "TC",
        "TZ",
        "CN",
        "MO",
        "HK",
        "TM",
        "TJ",
        "TG",
        "TN",
        "TR",
        "KR",
        "GS",
        "MP",
        "ZA",
        "TO",
        "TA",
        "TT",
        "TW",
        "TH",
        "TK",
        "TV",
        "DK",
        "DO",
        "DM",
        "DG",
        "NA",
        "NC",
        "NZ",
        "NL",
        "NR",
        "NE",
        "NG",
        "NI",
        "NP",
        "NU",
        "NF",
        "NO",
        "PN",
        "PA",
        "PW",
        "PK",
        "PG",
        "PY",
        "PS",
        "PL",
        "PE",
        "PT",
        "PR",
        "FR",
        "GF",
        "TF",
        "PF",
        "FI",
        "FO",
        "PH",
        "FJ",
        "FK",
        "VE",
        "VA",
        "VU",
        "VN",
        "VG",
        "IO",
        "BD",
        "BE",
        "BR",
        "BN",
        "BS",
        "BF",
        "BB",
        "BM",
        "BH",
        "BO",
        "BJ",
        "BY",
        "BG",
        "BT",
        "BV",
        "BI",
        "BZ",
        "BA",
        "BW",
        "MX",
        "IM",
        "MY",
        "MK",
        "MQ",
        "MG",
        "MH",
        "MW",
        "ML",
        "FM",
        "MZ",
        "MC",
        "YT",
        "MS",
        "MR",
        "MT",
        "MD",
        "MA",
        "MU",
        "MV",
        "MM",
        "KP",
        "SS",
        "MN",
        "ME",
        "YE",
        "UA",
        "UG",
        "GB",
        "US",
        "UM",
        "VI",
        "AE",
        "RW",
        "RO",
        "RU",
        "RE",
        "LB",
        "LI",
        "LT",
        "LV",
        "LA",
        "LR",
        "LS",
        "LY",
        "LU",
        "WF",
        "QO",
        "LK",
        "HM",
        "HU",
        "HT",
        "HN",
        "EE",
        "AC",
        "AO",
        "ID",
        "IL",
        "AZ",
        "EH",
        "AQ",
        "AI",
        "AG",
        "AD",
        "AS",
        "DZ",
        "SV",
        "TL",
        "CF",
        "AR",
        "AF",
        "AM",
        "AW",
        "AX",
        "IN",
        "IS",
        "CI",
        "IE",
        "OM",
        "GQ",
        "EC",
        "EG",
        "IT",
        "IQ",
        "IR",
        "ER",
        "ET",
        "AL",
        "UZ",
        "UY",
        "EU",
        "AT",
        "AU",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ကမ္ဘာ");
    namesMap.put("002", "အာဖရိက");
    namesMap.put("003", "မြောက် အမေရိက");
    namesMap.put("005", "တောင် အမေရိက");
    namesMap.put("009", "သမုဒ္ဒရာဒေသ");
    namesMap.put("011", "အနောက် အာဖရိက");
    namesMap.put("013", "အလယ်ပိုင်း အမေရိက");
    namesMap.put("014", "အရှေ့ပိုင်း အာဖရိက");
    namesMap.put("015", "မြောက်ပိုင်း အာဖရိက");
    namesMap.put("017", "အလယ်ပိုင်း အာဖရိက");
    namesMap.put("018", "တောင်ပိုင်း အာဖရိက");
    namesMap.put("019", "အမေရိကများ");
    namesMap.put("021", "မြောက်ပိုင်း အမေရိက");
    namesMap.put("029", "ကာရီဘီယံ");
    namesMap.put("030", "အရှေ့ပိုင်း အာရှ");
    namesMap.put("034", "တောင်ပိုင်း အာရှ");
    namesMap.put("035", "အရှေ့တောင်ပိုင်းအာရှ");
    namesMap.put("039", "တောင်ပိုင်း ဥရောပ");
    namesMap.put("053", "ဩစတြေးလျနှင့် နယူးဇီလန်");
    namesMap.put("054", "မီလာနီးရှား");
    namesMap.put("057", "မိုင်ခရိုနီရှားနယ်");
    namesMap.put("061", "ပိုလီနီရှား");
    namesMap.put("142", "အာရှ");
    namesMap.put("143", "အလယ် အာရှ");
    namesMap.put("145", "အနောက် အာရှ");
    namesMap.put("150", "ဥရောပ");
    namesMap.put("151", "အရှေ့ပိုင်း ဥရောပ");
    namesMap.put("154", "မြောက်ပိုင်း ဥရောပ");
    namesMap.put("155", "အနောက်ပိုင်း ဥရောပ");
    namesMap.put("419", "လက်တင်အမေရိက");
    namesMap.put("AC", "အက်စ်စင်ရှီအွန်ကျွန်း");
    namesMap.put("AD", "အန်ဒိုရာ");
    namesMap.put("AE", "ယူအေအီး");
    namesMap.put("AF", "အာဖဂန်နစ္စတန်");
    namesMap.put("AG", "အန်တီဂုအာနှင့်ဘာဘုဒါ");
    namesMap.put("AI", "အန်ဂွီလာ");
    namesMap.put("AL", "အဲလ်ဘာနီအာ");
    namesMap.put("AM", "အာမေနီးယား");
    namesMap.put("AO", "အင်ဂိုလာ");
    namesMap.put("AQ", "အန္တာတိက");
    namesMap.put("AR", "အာဂျင်တီးနား");
    namesMap.put("AS", "အမေရိကန် စမိုအ");
    namesMap.put("AT", "ဩစတြီးယား");
    namesMap.put("AU", "ဩစတြေးလျ");
    namesMap.put("AW", "အာရုဘာ");
    namesMap.put("AX", "အာလန်ကျွန်း");
    namesMap.put("AZ", "အဇာဘိုင်ဂျန်");
    namesMap.put("BA", "ဘော့စနီးယား နှင့် ဟာဇီဂိုဘီးနား");
    namesMap.put("BB", "ဘာဘဒိုးစ်");
    namesMap.put("BD", "ဘင်္ဂလားဒေ့ရှ်");
    namesMap.put("BE", "ဘယ်လ်ဂျီယမ်");
    namesMap.put("BF", "ဘာကီနာ ဖာဆို");
    namesMap.put("BG", "ဘူဂေးရီးယား");
    namesMap.put("BH", "ဘာရိန်း");
    namesMap.put("BI", "ဘူရွန်ဒီ");
    namesMap.put("BJ", "ဘီနင်");
    namesMap.put("BL", "စိန့်ဘာသီလီမိုင်");
    namesMap.put("BM", "ဘာမူဒါ");
    namesMap.put("BN", "ဘရူနိုင်း");
    namesMap.put("BO", "ဘိုလီးဘီးယား");
    namesMap.put("BQ", "ကာရီဘီယံနယ်သာလန်");
    namesMap.put("BR", "ဘရာဇီး");
    namesMap.put("BS", "ဘဟားမား");
    namesMap.put("BT", "ဘူတန်");
    namesMap.put("BV", "ဘူဗက်ကျွန်း");
    namesMap.put("BW", "ဘော့စ်ဝါနာ");
    namesMap.put("BY", "ဘီလာရုစ်");
    namesMap.put("BZ", "ဘေလီဇ်");
    namesMap.put("CA", "ကနေဒါ");
    namesMap.put("CC", "ကိုကိုး ကျွန်းစု");
    namesMap.put("CD", "ကွန်ဂို-ကင်ရှာစ");
    namesMap.put("CF", "အလယ်ပိုင်း အာဖရိက ပြည်ထောင်စု");
    namesMap.put("CG", "ကွန်ဂို-ဘရာဇာဗီလ်");
    namesMap.put("CH", "ဆွစ်ဇလန်");
    namesMap.put("CI", "အိုင်ဗရီကိုစ့်");
    namesMap.put("CK", "ကွတ် ကျွန်းစု");
    namesMap.put("CL", "ချီလီ");
    namesMap.put("CM", "ကင်မရွန်း");
    namesMap.put("CN", "တရုတ်");
    namesMap.put("CO", "ကိုလံဘီယာ");
    namesMap.put("CP", "ကလစ်ပါတန်ကျွန်း");
    namesMap.put("CR", "ကော့စ်တာရီကာ");
    namesMap.put("CU", "ကျူးဘား");
    namesMap.put("CV", "ခေ့ပ်ဗာဒူ");
    namesMap.put("CW", "ခူရာကာအို");
    namesMap.put("CX", "ခရစ်စမတ် ကျွန်း");
    namesMap.put("CY", "ဆိုက်ပရက်စ်");
    namesMap.put("CZ", "ချက် ပြည်ထောင်စု");
    namesMap.put("DE", "ဂျာမဏီ");
    namesMap.put("DG", "ဒီအေဂိုဂရာစီအာ");
    namesMap.put("DJ", "ဂျီဘူတီ");
    namesMap.put("DK", "ဒိန်းမတ်");
    namesMap.put("DM", "ဒိုမီနီကာ");
    namesMap.put("DO", "ဒိုမီနီကန်");
    namesMap.put("DZ", "အယ်လ်ဂျီးရီးယား");
    namesMap.put("EA", "ဆယ်ဥတာနှင့်မယ်လီလ်လာ");
    namesMap.put("EC", "အီကွေဒေါ");
    namesMap.put("EE", "အက်စတိုးနီးယား");
    namesMap.put("EG", "အီဂျစ်");
    namesMap.put("EH", "အနောက်ပိုင်း ဆာဟာရ");
    namesMap.put("ER", "အီရီတရီအာ");
    namesMap.put("ES", "စပိန်");
    namesMap.put("ET", "အီသီယိုးပီးယား");
    namesMap.put("EU", "ဥရောပသမဂ္ဂ");
    namesMap.put("FI", "ဖင်လန်");
    namesMap.put("FJ", "ဖီဂျီ");
    namesMap.put("FK", "ဖောက်ကလန် ကျွန်းစု");
    namesMap.put("FM", "မိုင်ခရိုနီရှား");
    namesMap.put("FO", "ဖာရိုး ကျွန်းစုများ");
    namesMap.put("FR", "ပြင်သစ်");
    namesMap.put("GA", "ဂါဘွန်");
    namesMap.put("GB", "ယူနိုက်တက်ကင်းဒမ်း");
    namesMap.put("GD", "ဂရီနာဒါ");
    namesMap.put("GE", "ဂျော်ဂျီယာ");
    namesMap.put("GF", "ပြင်သစ် ဂီယာနာ");
    namesMap.put("GG", "ဂွန်းဇီ");
    namesMap.put("GH", "ဂါနာ");
    namesMap.put("GI", "ဂျီဘရော်လ်တာ");
    namesMap.put("GL", "ဂရင်းလန်း");
    namesMap.put("GM", "ဂန်ဘီရာ");
    namesMap.put("GN", "ဂီးနီ");
    namesMap.put("GP", "ဂူအာဒီလုပ်");
    namesMap.put("GQ", "အီကွေတာ ဂီရာနာ");
    namesMap.put("GR", "ဂရိ");
    namesMap.put("GS", "တောင် ဂျော်ဂျီယာ နှင့် တောင် ဆင်းဒဝစ်ဂျ် ကျွန်းစုများ");
    namesMap.put("GT", "ဂွာတီမာလာ");
    namesMap.put("GU", "ဂူအမ်");
    namesMap.put("GW", "ဂီရာနာ-ဘီစ်စာဥ");
    namesMap.put("GY", "ဂူရာနာ");
    namesMap.put("HK", "တရုတ်၏ အထူးအုပ်ချုပ်ခွင့်ရ ဟောင်ကောင်");
    namesMap.put("HM", "ဟတ်ကျွန်းနှင့်မက်ဒေါနယ်ကျွန်းစု");
    namesMap.put("HN", "ဟွန်ဒူးရပ်စ်");
    namesMap.put("HR", "ခရိုအေးရှား");
    namesMap.put("HT", "ဟေတီ");
    namesMap.put("HU", "ဟန်ဂေရီ");
    namesMap.put("IC", "ကာနာရီကျွန်းစု");
    namesMap.put("ID", "အင်ဒိုနီးရှား");
    namesMap.put("IE", "အိုင်ယာလန်");
    namesMap.put("IL", "အစ္စရေး");
    namesMap.put("IM", "မန်ကျွန်း");
    namesMap.put("IN", "အိန္ဒိယ");
    namesMap.put("IO", "ဗြိတိသျှ အိန္ဒြိယ သမုဒ္ဒရာ ပိုင်နက်");
    namesMap.put("IQ", "အီရတ်");
    namesMap.put("IR", "အီရန်");
    namesMap.put("IS", "အိုက်စလန်");
    namesMap.put("IT", "အီတလီ");
    namesMap.put("JE", "ဂျာစီ");
    namesMap.put("JM", "ဂျမေကာ");
    namesMap.put("JO", "ဂျော်ဒန်");
    namesMap.put("JP", "ဂျပန်");
    namesMap.put("KE", "ကင်ညာ");
    namesMap.put("KG", "ခရူဂစ်စတန်");
    namesMap.put("KH", "ကမ္ဘောဒီးယား");
    namesMap.put("KI", "ခီရီဘာတီ");
    namesMap.put("KM", "ကိုမိုရိုစ်");
    namesMap.put("KN", "စိန့်ကစ်နှင့်နီဗီစ်");
    namesMap.put("KP", "မြောက်ကိုရီးယား");
    namesMap.put("KR", "တောင်ကိုရီးယား");
    namesMap.put("KW", "ကူဝိတ်");
    namesMap.put("KY", "ကေမန် ကျွန်းစု");
    namesMap.put("KZ", "ကာဇက်စတန်");
    namesMap.put("LA", "လာအို");
    namesMap.put("LB", "လက်ဘနွန်");
    namesMap.put("LC", "စိန့်လူစီအာ");
    namesMap.put("LI", "လစ်ခ်ထင်စတိုင်");
    namesMap.put("LK", "သီရိလင်္ကာ");
    namesMap.put("LR", "လိုင်ဘေးရီးယား");
    namesMap.put("LS", "လီဆိုသို");
    namesMap.put("LT", "လစ်သူယေးနီးယား");
    namesMap.put("LU", "လူဇင်ဘတ်");
    namesMap.put("LV", "လတ်ဗီးယား");
    namesMap.put("LY", "လီဗရာ");
    namesMap.put("MA", "မော်ရိုကို");
    namesMap.put("MC", "မိုနာကို");
    namesMap.put("MD", "မောလ်ဒိုဗာ");
    namesMap.put("ME", "မွန်တီနိဂရိုး");
    namesMap.put("MF", "စိန့်မာတင်");
    namesMap.put("MG", "မာဒါဂတ်စကာ");
    namesMap.put("MH", "မာရှယ် ကျွန်းစု");
    namesMap.put("MK", "မာစီဒိုးနီးယား");
    namesMap.put("ML", "မာလီ");
    namesMap.put("MM", "မြန်မာ");
    namesMap.put("MN", "မွန်ဂိုးလီးယား");
    namesMap.put("MO", "တရုတ်၏ အထူးအုပ်ချုပ်ခွင့်ရ မကာအို");
    namesMap.put("MP", "တောင်ပိုင်းမာရီအာနာကျွန်းစု");
    namesMap.put("MQ", "မာတီနီကီ");
    namesMap.put("MR", "မောရီတာနီအာ");
    namesMap.put("MS", "မောင့်စဲရက်");
    namesMap.put("MT", "မောလ်တာ");
    namesMap.put("MU", "မော်ရေရှားစ်");
    namesMap.put("MV", "မော်လ်ဒိုက်");
    namesMap.put("MW", "မာလာဝီ");
    namesMap.put("MX", "မက္ကဆီကို");
    namesMap.put("MY", "မလေးရှား");
    namesMap.put("MZ", "မိုဇန်ဘစ်");
    namesMap.put("NA", "နမ်မီးဘီးယား");
    namesMap.put("NC", "နယူး ကယ်လီဒိုနီးယား");
    namesMap.put("NE", "နိုင်ဂျာ");
    namesMap.put("NF", "နောဖော့ခ်ကျွန်း");
    namesMap.put("NG", "နိုင်ဂျီးရီးယား");
    namesMap.put("NI", "နီကာရာဂွာ");
    namesMap.put("NL", "နယ်သာလန်");
    namesMap.put("NO", "နော်ဝေ");
    namesMap.put("NP", "နီပေါ");
    namesMap.put("NR", "နာဥူရူ");
    namesMap.put("NU", "နီဥူအေ");
    namesMap.put("NZ", "နယူးဇီလန်");
    namesMap.put("OM", "အိုမန်");
    namesMap.put("PA", "ပနားမား");
    namesMap.put("PE", "ပီရူး");
    namesMap.put("PF", "ပြင်သစ် ပေါ်လီနေးရှား");
    namesMap.put("PG", "ပါပူရာနယူးဂီနီ");
    namesMap.put("PH", "ဖိလစ်ပိုင်");
    namesMap.put("PK", "ပါကစ္စတန်");
    namesMap.put("PL", "ပိုလန်");
    namesMap.put("PM", "စိန့်ပီအဲရီနှင့်မီကွီလွန်");
    namesMap.put("PN", "ပစ်တ်ကိန်းကျွန်းစု");
    namesMap.put("PR", "ပေါ်တူရီကို");
    namesMap.put("PS", "ပါလက်စတိုင်း ပိုင်နက်");
    namesMap.put("PT", "ပေါ်တူဂီ");
    namesMap.put("PW", "ပလောင်");
    namesMap.put("PY", "ပါရာဂွေး");
    namesMap.put("QA", "ကာတာ");
    namesMap.put("QO", "သမုဒ္ဒရာဒေသအပြင်ထွက်နေသောဒေသများ");
    namesMap.put("RE", "ရဲအူနီရွန်");
    namesMap.put("RO", "ရိုမေးနီးယား");
    namesMap.put("RS", "ဆားဘီးယား");
    namesMap.put("RU", "ရုရှ");
    namesMap.put("RW", "ရဝန်ဒါ");
    namesMap.put("SA", "ဆော်ဒီအာရေးဗီးယား");
    namesMap.put("SB", "ဆော်လမွန်ကျွန်းစု");
    namesMap.put("SC", "ဆေးရှလ်");
    namesMap.put("SD", "ဆူဒန်");
    namesMap.put("SE", "ဆွီဒင်");
    namesMap.put("SG", "စင်္ကာပူ");
    namesMap.put("SH", "စိန့်ဟဲလီနာ");
    namesMap.put("SI", "စလိုဗေးနီးယား");
    namesMap.put("SJ", "စဗိုလ်ဘတ်နှင့်ဂျန်မေရန်");
    namesMap.put("SK", "စလိုဗေးကီးယား");
    namesMap.put("SL", "ဆီအဲရာ လီအိုနီ");
    namesMap.put("SM", "ဆော့န်မာရီနို");
    namesMap.put("SN", "ဆီနီဂေါ");
    namesMap.put("SO", "ဆိုမာလီယာ");
    namesMap.put("SR", "ဆူရီနိမ်း");
    namesMap.put("SS", "မြောက်ဆူဒန်");
    namesMap.put("ST", "စိန့်တိုမီနှင့်ပရင်စီပ့်");
    namesMap.put("SV", "အယ်လ်ဆာဗေးဒိုး");
    namesMap.put("SX", "ဆင့်မာအာတင်");
    namesMap.put("SY", "ဆီးရီးယား");
    namesMap.put("SZ", "စွာဇီလန်");
    namesMap.put("TA", "ထရစ်တန်ဒါကွန်ဟာ");
    namesMap.put("TC", "တခ်စ်နှင့်ကာအီကိုစ်ကျွန်းစု");
    namesMap.put("TD", "ချဒ်");
    namesMap.put("TF", "ပြင်သစ် တောင်ပိုင်း ပိုင်နက်များ");
    namesMap.put("TG", "တိုဂို");
    namesMap.put("TH", "ထိုင်း");
    namesMap.put("TJ", "တာဂျီကစ္စတန်");
    namesMap.put("TK", "ထိုးခါလူ");
    namesMap.put("TL", "အရှေ့တီမော");
    namesMap.put("TM", "တာခ်မီန့စ်တန်");
    namesMap.put("TN", "တူနီးရှား");
    namesMap.put("TO", "တွန်ဂါ");
    namesMap.put("TR", "တူရကီ");
    namesMap.put("TT", "ထရိုင်နီဒတ်နှင့်တိုဘာဂို");
    namesMap.put("TV", "ထူးဗလူ");
    namesMap.put("TW", "ထိုင်ဝမ်");
    namesMap.put("TZ", "တန်ဇန်းနီးယား");
    namesMap.put("UA", "ယူကရိန်း");
    namesMap.put("UG", "ယူဂန္ဓာ");
    namesMap.put("UM", "ယူနိုက်တက်စတိတ် အပြင်ထွက် နေသည့် သေးငယ်သောကျွန်းများ");
    namesMap.put("US", "ယူနိုက်တက်စတိတ်");
    namesMap.put("UY", "ဥရုဂွေး");
    namesMap.put("UZ", "ဥဘက်ကစ္စတန်");
    namesMap.put("VA", "ဗာတီကန်စီတီး");
    namesMap.put("VC", "စိန့်ဗင့်ဆင့်နှင့် သည်ဂရဲနာဒင်းစ်");
    namesMap.put("VE", "ဗင်နီဇွဲလား");
    namesMap.put("VG", "ဗြိတိသျှ ဗာဂျင်း ကျွန်းစု");
    namesMap.put("VI", "ယူအက်စ် ဗာဂျင်း ကျွန်းစု");
    namesMap.put("VN", "ဗီယက်နမ်");
    namesMap.put("VU", "ဗာနုအာတူ");
    namesMap.put("WF", "ဝေါလစ်နှင့်ဖူထူးနား");
    namesMap.put("WS", "ဆာမိုအာ");
    namesMap.put("XK", "ကိုဆိုဗို");
    namesMap.put("YE", "ယီမင်");
    namesMap.put("YT", "မေအိုတီ");
    namesMap.put("ZA", "တောင်အာဖရိက");
    namesMap.put("ZM", "ဇမ်ဘီယာ");
    namesMap.put("ZW", "ဇင်ဘာဘွေ");
    namesMap.put("ZZ", "မသိ သို့မဟုတ် မရှိ သော နေရာ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ကမ္ဘာ",
        "002": "အာဖရိက",
        "003": "မြောက် အမေရိက",
        "005": "တောင် အမေရိက",
        "009": "သမုဒ္ဒရာဒေသ",
        "011": "အနောက် အာဖရိက",
        "013": "အလယ်ပိုင်း အမေရိက",
        "014": "အရှေ့ပိုင်း အာဖရိက",
        "015": "မြောက်ပိုင်း အာဖရိက",
        "017": "အလယ်ပိုင်း အာဖရိက",
        "018": "တောင်ပိုင်း အာဖရိက",
        "019": "အမေရိကများ",
        "021": "မြောက်ပိုင်း အမေရိက",
        "029": "ကာရီဘီယံ",
        "030": "အရှေ့ပိုင်း အာရှ",
        "034": "တောင်ပိုင်း အာရှ",
        "035": "အရှေ့တောင်ပိုင်းအာရှ",
        "039": "တောင်ပိုင်း ဥရောပ",
        "053": "ဩစတြေးလျနှင့် နယူးဇီလန်",
        "054": "မီလာနီးရှား",
        "057": "မိုင်ခရိုနီရှားနယ်",
        "061": "ပိုလီနီရှား",
        "142": "အာရှ",
        "143": "အလယ် အာရှ",
        "145": "အနောက် အာရှ",
        "150": "ဥရောပ",
        "151": "အရှေ့ပိုင်း ဥရောပ",
        "154": "မြောက်ပိုင်း ဥရောပ",
        "155": "အနောက်ပိုင်း ဥရောပ",
        "419": "လက်တင်အမေရိက",
        "AC": "အက်စ်စင်ရှီအွန်ကျွန်း",
        "AD": "အန်ဒိုရာ",
        "AE": "ယူအေအီး",
        "AF": "အာဖဂန်နစ္စတန်",
        "AG": "အန်တီဂုအာနှင့်ဘာဘုဒါ",
        "AI": "အန်ဂွီလာ",
        "AL": "အဲလ်ဘာနီအာ",
        "AM": "အာမေနီးယား",
        "AO": "အင်ဂိုလာ",
        "AQ": "အန္တာတိက",
        "AR": "အာဂျင်တီးနား",
        "AS": "အမေရိကန် စမိုအ",
        "AT": "ဩစတြီးယား",
        "AU": "ဩစတြေးလျ",
        "AW": "အာရုဘာ",
        "AX": "အာလန်ကျွန်း",
        "AZ": "အဇာဘိုင်ဂျန်",
        "BA": "ဘော့စနီးယား နှင့် ဟာဇီဂိုဘီးနား",
        "BB": "ဘာဘဒိုးစ်",
        "BD": "ဘင်္ဂလားဒေ့ရှ်",
        "BE": "ဘယ်လ်ဂျီယမ်",
        "BF": "ဘာကီနာ ဖာဆို",
        "BG": "ဘူဂေးရီးယား",
        "BH": "ဘာရိန်း",
        "BI": "ဘူရွန်ဒီ",
        "BJ": "ဘီနင်",
        "BL": "စိန့်ဘာသီလီမိုင်",
        "BM": "ဘာမူဒါ",
        "BN": "ဘရူနိုင်း",
        "BO": "ဘိုလီးဘီးယား",
        "BQ": "ကာရီဘီယံနယ်သာလန်",
        "BR": "ဘရာဇီး",
        "BS": "ဘဟားမား",
        "BT": "ဘူတန်",
        "BV": "ဘူဗက်ကျွန်း",
        "BW": "ဘော့စ်ဝါနာ",
        "BY": "ဘီလာရုစ်",
        "BZ": "ဘေလီဇ်",
        "CA": "ကနေဒါ",
        "CC": "ကိုကိုး ကျွန်းစု",
        "CD": "ကွန်ဂို-ကင်ရှာစ",
        "CF": "အလယ်ပိုင်း အာဖရိက ပြည်ထောင်စု",
        "CG": "ကွန်ဂို-ဘရာဇာဗီလ်",
        "CH": "ဆွစ်ဇလန်",
        "CI": "အိုင်ဗရီကိုစ့်",
        "CK": "ကွတ် ကျွန်းစု",
        "CL": "ချီလီ",
        "CM": "ကင်မရွန်း",
        "CN": "တရုတ်",
        "CO": "ကိုလံဘီယာ",
        "CP": "ကလစ်ပါတန်ကျွန်း",
        "CR": "ကော့စ်တာရီကာ",
        "CU": "ကျူးဘား",
        "CV": "ခေ့ပ်ဗာဒူ",
        "CW": "ခူရာကာအို",
        "CX": "ခရစ်စမတ် ကျွန်း",
        "CY": "ဆိုက်ပရက်စ်",
        "CZ": "ချက် ပြည်ထောင်စု",
        "DE": "ဂျာမဏီ",
        "DG": "ဒီအေဂိုဂရာစီအာ",
        "DJ": "ဂျီဘူတီ",
        "DK": "ဒိန်းမတ်",
        "DM": "ဒိုမီနီကာ",
        "DO": "ဒိုမီနီကန်",
        "DZ": "အယ်လ်ဂျီးရီးယား",
        "EA": "ဆယ်ဥတာနှင့်မယ်လီလ်လာ",
        "EC": "အီကွေဒေါ",
        "EE": "အက်စတိုးနီးယား",
        "EG": "အီဂျစ်",
        "EH": "အနောက်ပိုင်း ဆာဟာရ",
        "ER": "အီရီတရီအာ",
        "ES": "စပိန်",
        "ET": "အီသီယိုးပီးယား",
        "EU": "ဥရောပသမဂ္ဂ",
        "FI": "ဖင်လန်",
        "FJ": "ဖီဂျီ",
        "FK": "ဖောက်ကလန် ကျွန်းစု",
        "FM": "မိုင်ခရိုနီရှား",
        "FO": "ဖာရိုး ကျွန်းစုများ",
        "FR": "ပြင်သစ်",
        "GA": "ဂါဘွန်",
        "GB": "ယူနိုက်တက်ကင်းဒမ်း",
        "GD": "ဂရီနာဒါ",
        "GE": "ဂျော်ဂျီယာ",
        "GF": "ပြင်သစ် ဂီယာနာ",
        "GG": "ဂွန်းဇီ",
        "GH": "ဂါနာ",
        "GI": "ဂျီဘရော်လ်တာ",
        "GL": "ဂရင်းလန်း",
        "GM": "ဂန်ဘီရာ",
        "GN": "ဂီးနီ",
        "GP": "ဂူအာဒီလုပ်",
        "GQ": "အီကွေတာ ဂီရာနာ",
        "GR": "ဂရိ",
        "GS": "တောင် ဂျော်ဂျီယာ နှင့် တောင် ဆင်းဒဝစ်ဂျ် ကျွန်းစုများ",
        "GT": "ဂွာတီမာလာ",
        "GU": "ဂူအမ်",
        "GW": "ဂီရာနာ-ဘီစ်စာဥ",
        "GY": "ဂူရာနာ",
        "HK": "တရုတ်၏ အထူးအုပ်ချုပ်ခွင့်ရ ဟောင်ကောင်",
        "HM": "ဟတ်ကျွန်းနှင့်မက်ဒေါနယ်ကျွန်းစု",
        "HN": "ဟွန်ဒူးရပ်စ်",
        "HR": "ခရိုအေးရှား",
        "HT": "ဟေတီ",
        "HU": "ဟန်ဂေရီ",
        "IC": "ကာနာရီကျွန်းစု",
        "ID": "အင်ဒိုနီးရှား",
        "IE": "အိုင်ယာလန်",
        "IL": "အစ္စရေး",
        "IM": "မန်ကျွန်း",
        "IN": "အိန္ဒိယ",
        "IO": "ဗြိတိသျှ အိန္ဒြိယ သမုဒ္ဒရာ ပိုင်နက်",
        "IQ": "အီရတ်",
        "IR": "အီရန်",
        "IS": "အိုက်စလန်",
        "IT": "အီတလီ",
        "JE": "ဂျာစီ",
        "JM": "ဂျမေကာ",
        "JO": "ဂျော်ဒန်",
        "JP": "ဂျပန်",
        "KE": "ကင်ညာ",
        "KG": "ခရူဂစ်စတန်",
        "KH": "ကမ္ဘောဒီးယား",
        "KI": "ခီရီဘာတီ",
        "KM": "ကိုမိုရိုစ်",
        "KN": "စိန့်ကစ်နှင့်နီဗီစ်",
        "KP": "မြောက်ကိုရီးယား",
        "KR": "တောင်ကိုရီးယား",
        "KW": "ကူဝိတ်",
        "KY": "ကေမန် ကျွန်းစု",
        "KZ": "ကာဇက်စတန်",
        "LA": "လာအို",
        "LB": "လက်ဘနွန်",
        "LC": "စိန့်လူစီအာ",
        "LI": "လစ်ခ်ထင်စတိုင်",
        "LK": "သီရိလင်္ကာ",
        "LR": "လိုင်ဘေးရီးယား",
        "LS": "လီဆိုသို",
        "LT": "လစ်သူယေးနီးယား",
        "LU": "လူဇင်ဘတ်",
        "LV": "လတ်ဗီးယား",
        "LY": "လီဗရာ",
        "MA": "မော်ရိုကို",
        "MC": "မိုနာကို",
        "MD": "မောလ်ဒိုဗာ",
        "ME": "မွန်တီနိဂရိုး",
        "MF": "စိန့်မာတင်",
        "MG": "မာဒါဂတ်စကာ",
        "MH": "မာရှယ် ကျွန်းစု",
        "MK": "မာစီဒိုးနီးယား",
        "ML": "မာလီ",
        "MM": "မြန်မာ",
        "MN": "မွန်ဂိုးလီးယား",
        "MO": "တရုတ်၏ အထူးအုပ်ချုပ်ခွင့်ရ မကာအို",
        "MP": "တောင်ပိုင်းမာရီအာနာကျွန်းစု",
        "MQ": "မာတီနီကီ",
        "MR": "မောရီတာနီအာ",
        "MS": "မောင့်စဲရက်",
        "MT": "မောလ်တာ",
        "MU": "မော်ရေရှားစ်",
        "MV": "မော်လ်ဒိုက်",
        "MW": "မာလာဝီ",
        "MX": "မက္ကဆီကို",
        "MY": "မလေးရှား",
        "MZ": "မိုဇန်ဘစ်",
        "NA": "နမ်မီးဘီးယား",
        "NC": "နယူး ကယ်လီဒိုနီးယား",
        "NE": "နိုင်ဂျာ",
        "NF": "နောဖော့ခ်ကျွန်း",
        "NG": "နိုင်ဂျီးရီးယား",
        "NI": "နီကာရာဂွာ",
        "NL": "နယ်သာလန်",
        "NO": "နော်ဝေ",
        "NP": "နီပေါ",
        "NR": "နာဥူရူ",
        "NU": "နီဥူအေ",
        "NZ": "နယူးဇီလန်",
        "OM": "အိုမန်",
        "PA": "ပနားမား",
        "PE": "ပီရူး",
        "PF": "ပြင်သစ် ပေါ်လီနေးရှား",
        "PG": "ပါပူရာနယူးဂီနီ",
        "PH": "ဖိလစ်ပိုင်",
        "PK": "ပါကစ္စတန်",
        "PL": "ပိုလန်",
        "PM": "စိန့်ပီအဲရီနှင့်မီကွီလွန်",
        "PN": "ပစ်တ်ကိန်းကျွန်းစု",
        "PR": "ပေါ်တူရီကို",
        "PS": "ပါလက်စတိုင်း ပိုင်နက်",
        "PT": "ပေါ်တူဂီ",
        "PW": "ပလောင်",
        "PY": "ပါရာဂွေး",
        "QA": "ကာတာ",
        "QO": "သမုဒ္ဒရာဒေသအပြင်ထွက်နေသောဒေသများ",
        "RE": "ရဲအူနီရွန်",
        "RO": "ရိုမေးနီးယား",
        "RS": "ဆားဘီးယား",
        "RU": "ရုရှ",
        "RW": "ရဝန်ဒါ",
        "SA": "ဆော်ဒီအာရေးဗီးယား",
        "SB": "ဆော်လမွန်ကျွန်းစု",
        "SC": "ဆေးရှလ်",
        "SD": "ဆူဒန်",
        "SE": "ဆွီဒင်",
        "SG": "စင်္ကာပူ",
        "SH": "စိန့်ဟဲလီနာ",
        "SI": "စလိုဗေးနီးယား",
        "SJ": "စဗိုလ်ဘတ်နှင့်ဂျန်မေရန်",
        "SK": "စလိုဗေးကီးယား",
        "SL": "ဆီအဲရာ လီအိုနီ",
        "SM": "ဆော့န်မာရီနို",
        "SN": "ဆီနီဂေါ",
        "SO": "ဆိုမာလီယာ",
        "SR": "ဆူရီနိမ်း",
        "SS": "မြောက်ဆူဒန်",
        "ST": "စိန့်တိုမီနှင့်ပရင်စီပ့်",
        "SV": "အယ်လ်ဆာဗေးဒိုး",
        "SX": "ဆင့်မာအာတင်",
        "SY": "ဆီးရီးယား",
        "SZ": "စွာဇီလန်",
        "TA": "ထရစ်တန်ဒါကွန်ဟာ",
        "TC": "တခ်စ်နှင့်ကာအီကိုစ်ကျွန်းစု",
        "TD": "ချဒ်",
        "TF": "ပြင်သစ် တောင်ပိုင်း ပိုင်နက်များ",
        "TG": "တိုဂို",
        "TH": "ထိုင်း",
        "TJ": "တာဂျီကစ္စတန်",
        "TK": "ထိုးခါလူ",
        "TL": "အရှေ့တီမော",
        "TM": "တာခ်မီန့စ်တန်",
        "TN": "တူနီးရှား",
        "TO": "တွန်ဂါ",
        "TR": "တူရကီ",
        "TT": "ထရိုင်နီဒတ်နှင့်တိုဘာဂို",
        "TV": "ထူးဗလူ",
        "TW": "ထိုင်ဝမ်",
        "TZ": "တန်ဇန်းနီးယား",
        "UA": "ယူကရိန်း",
        "UG": "ယူဂန္ဓာ",
        "UM": "ယူနိုက်တက်စတိတ် အပြင်ထွက် နေသည့် သေးငယ်သောကျွန်းများ",
        "US": "ယူနိုက်တက်စတိတ်",
        "UY": "ဥရုဂွေး",
        "UZ": "ဥဘက်ကစ္စတန်",
        "VA": "ဗာတီကန်စီတီး",
        "VC": "စိန့်ဗင့်ဆင့်နှင့် သည်ဂရဲနာဒင်းစ်",
        "VE": "ဗင်နီဇွဲလား",
        "VG": "ဗြိတိသျှ ဗာဂျင်း ကျွန်းစု",
        "VI": "ယူအက်စ် ဗာဂျင်း ကျွန်းစု",
        "VN": "ဗီယက်နမ်",
        "VU": "ဗာနုအာတူ",
        "WF": "ဝေါလစ်နှင့်ဖူထူးနား",
        "WS": "ဆာမိုအာ",
        "XK": "ကိုဆိုဗို",
        "YE": "ယီမင်",
        "YT": "မေအိုတီ",
        "ZA": "တောင်အာဖရိက",
        "ZM": "ဇမ်ဘီယာ",
        "ZW": "ဇင်ဘာဘွေ",
        "ZZ": "မသိ သို့မဟုတ် မရှိ သော နေရာ"
    };
  }-*/;
}
