/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "az" locale.
 */
public class LocalizedNamesImpl_az extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "VI",
        "AX",
        "AL",
        "DE",
        "US",
        "AS",
        "AD",
        "AI",
        "AO",
        "AQ",
        "AG",
        "AR",
        "AW",
        "EU",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "GB",
        "UM",
        "AE",
        "BO",
        "BG",
        "BA",
        "BW",
        "BR",
        "IO",
        "VG",
        "BN",
        "BF",
        "BI",
        "BT",
        "BV",
        "BH",
        "TD",
        "JE",
        "CZ",
        "DJ",
        "CL",
        "CN",
        "ZA",
        "GS",
        "KR",
        "SS",
        "DK",
        "DG",
        "DM",
        "DO",
        "ET",
        "EC",
        "GQ",
        "ER",
        "AM",
        "EE",
        "FO",
        "FJ",
        "CI",
        "PH",
        "FI",
        "FK",
        "FR",
        "TF",
        "PF",
        "GF",
        "PS",
        "GG",
        "GI",
        "GE",
        "HT",
        "HM",
        "IN",
        "AN",
        "HN",
        "HK",
        "ID",
        "JO",
        "IR",
        "IQ",
        "IE",
        "IS",
        "ES",
        "IL",
        "SE",
        "CH",
        "IT",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "BQ",
        "KY",
        "KE",
        "CY",
        "KI",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CU",
        "CK",
        "CW",
        "KW",
        "LA",
        "LV",
        "LS",
        "LR",
        "LT",
        "LB",
        "LY",
        "LI",
        "LU",
        "HU",
        "MG",
        "MO",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MH",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "IM",
        "FM",
        "CX",
        "EG",
        "MD",
        "MC",
        "MN",
        "MS",
        "ME",
        "MZ",
        "SH",
        "MM",
        "MA",
        "CF",
        "NA",
        "NR",
        "NP",
        "NL",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "OM",
        "UZ",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "GA",
        "GM",
        "GH",
        "QA",
        "KZ",
        "GD",
        "GL",
        "GU",
        "GP",
        "GT",
        "GN",
        "GW",
        "GY",
        "KG",
        "EH",
        "RE",
        "RW",
        "RO",
        "RU",
        "SV",
        "WS",
        "BL",
        "KN",
        "LC",
        "SM",
        "MF",
        "PM",
        "VC",
        "ST",
        "SN",
        "RS",
        "EA",
        "SC",
        "SL",
        "KP",
        "MP",
        "SG",
        "SX",
        "SK",
        "SI",
        "SB",
        "SO",
        "LK",
        "SD",
        "SR",
        "SY",
        "SJ",
        "SZ",
        "TL",
        "SA",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TK",
        "TO",
        "TG",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UA",
        "WF",
        "UG",
        "UY",
        "QO",
        "VU",
        "VA",
        "VE",
        "VN",
        "HR",
        "JM",
        "JP",
        "NC",
        "NZ",
        "AC",
        "GR",
        "YE",
        "ZM",
        "ZW",
        "AF",
        "DZ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dünya");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Şimali Amerika");
    namesMap.put("005", "Cənubi Amerika");
    namesMap.put("009", "Okeaniya");
    namesMap.put("011", "Qərbi Afrika");
    namesMap.put("013", "Mərkəzi Amerika");
    namesMap.put("014", "Şərqi Afrika");
    namesMap.put("015", "Şimali Afrika");
    namesMap.put("017", "Mərkəzi Afrika");
    namesMap.put("018", "Cənubi Afrika");
    namesMap.put("019", "Amerikalar");
    namesMap.put("021", "Şimal Amerikası");
    namesMap.put("029", "Karib");
    namesMap.put("030", "Şərqi Asiya");
    namesMap.put("034", "Cənubi Asiya");
    namesMap.put("035", "Cənub-Şərqi Asiya");
    namesMap.put("039", "Cənubi Avropa");
    namesMap.put("053", "Avstralaziya");
    namesMap.put("054", "Melaneziya");
    namesMap.put("057", "Mikroneziya Regionu");
    namesMap.put("061", "Polineziya");
    namesMap.put("142", "Asiya");
    namesMap.put("143", "Mərkəzi Asiya");
    namesMap.put("145", "Qərbi Asiya");
    namesMap.put("150", "Avropa");
    namesMap.put("151", "Şərqi Avropa");
    namesMap.put("154", "Şimali Avropa");
    namesMap.put("155", "Qərbi Avropa");
    namesMap.put("419", "Latın Amerikası");
    namesMap.put("AC", "Yüksəliş Adası");
    namesMap.put("AE", "Birləşmiş Ərəb Əmirlikləri");
    namesMap.put("AF", "Əfqanıstan");
    namesMap.put("AG", "Antiqua və Barbuda");
    namesMap.put("AI", "Angila");
    namesMap.put("AL", "Albaniya");
    namesMap.put("AM", "Ermənistan");
    namesMap.put("AN", "Hollandiya antilleri");
    namesMap.put("AO", "Anqola");
    namesMap.put("AQ", "Antarktika");
    namesMap.put("AS", "Amerika Samoası");
    namesMap.put("AT", "Avstriya");
    namesMap.put("AU", "Avstraliya");
    namesMap.put("AX", "Aland Adaları");
    namesMap.put("AZ", "Azərbaycan");
    namesMap.put("BA", "Bosniya və Hersoqovina");
    namesMap.put("BD", "Banqladeş");
    namesMap.put("BE", "Belçika");
    namesMap.put("BG", "Bolqariya");
    namesMap.put("BH", "Bəhreyn");
    namesMap.put("BL", "San Bartolomey");
    namesMap.put("BN", "Bruney");
    namesMap.put("BO", "Boliviya");
    namesMap.put("BQ", "Karib Niderlandı");
    namesMap.put("BR", "Braziliya");
    namesMap.put("BS", "Baham Adaları");
    namesMap.put("BT", "Butan");
    namesMap.put("BV", "Buve Adası");
    namesMap.put("BW", "Botsvana");
    namesMap.put("BZ", "Beliz");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokos Adaları");
    namesMap.put("CD", "Konqo - Kinşasa");
    namesMap.put("CF", "Mərkəzi Afrika Respublikası");
    namesMap.put("CG", "Konqo - Brazzavil");
    namesMap.put("CH", "İsveçrə");
    namesMap.put("CI", "Fil Dişi Sahili");
    namesMap.put("CK", "Kuk Adaları");
    namesMap.put("CL", "Çili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Çin");
    namesMap.put("CO", "Kolumbiya");
    namesMap.put("CP", "Klipperton Adası");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kape Verde");
    namesMap.put("CW", "Kurasao");
    namesMap.put("CX", "Milad Adası");
    namesMap.put("CY", "Kipr");
    namesMap.put("CZ", "Çexiya");
    namesMap.put("DE", "Almaniya");
    namesMap.put("DG", "Dieqo Qarsiya");
    namesMap.put("DJ", "Cibuti");
    namesMap.put("DK", "Danimarka");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikan Respublikası");
    namesMap.put("DZ", "Əlcəzair");
    namesMap.put("EA", "Seuta və Melilya");
    namesMap.put("EC", "Ekvador");
    namesMap.put("EE", "Estoniya");
    namesMap.put("EG", "Misir");
    namesMap.put("EH", "Qərbi Sahara");
    namesMap.put("ER", "Eritreya");
    namesMap.put("ES", "İspaniya");
    namesMap.put("ET", "Efiopiya");
    namesMap.put("EU", "Avropa Birliyi");
    namesMap.put("FI", "Finlandiya");
    namesMap.put("FJ", "Fici");
    namesMap.put("FK", "Folklend Adaları");
    namesMap.put("FM", "Mikroneziya");
    namesMap.put("FO", "Farer Adaları");
    namesMap.put("FR", "Fransa");
    namesMap.put("GA", "Qabon");
    namesMap.put("GB", "Birləşmiş Krallıq");
    namesMap.put("GD", "Qrenada");
    namesMap.put("GE", "Gürcüstan");
    namesMap.put("GF", "Fransız Qviyanası");
    namesMap.put("GG", "Gernsey");
    namesMap.put("GH", "Qana");
    namesMap.put("GL", "Qrenlandiya");
    namesMap.put("GM", "Qambiya");
    namesMap.put("GN", "Qvineya");
    namesMap.put("GP", "Qvadelupa");
    namesMap.put("GQ", "Ekvatorial Qvineya");
    namesMap.put("GR", "Yunanıstan");
    namesMap.put("GS", "Cənubi Corciya və Cənubi Sendviç Adaları");
    namesMap.put("GT", "Qvatemala");
    namesMap.put("GU", "Quam");
    namesMap.put("GW", "Qvineya-Bisau");
    namesMap.put("GY", "Qviyana");
    namesMap.put("HK", "Honq Konq Xüsusi İnzibati Ərazi Çin");
    namesMap.put("HM", "Herd və Mak Donald Adaları");
    namesMap.put("HR", "Xorvatiya");
    namesMap.put("HU", "Macarıstan");
    namesMap.put("IC", "Kanar Adaları");
    namesMap.put("ID", "İndoneziya");
    namesMap.put("IE", "İrlandiya");
    namesMap.put("IL", "İsrail");
    namesMap.put("IM", "Men Adası");
    namesMap.put("IN", "Hindistan");
    namesMap.put("IO", "Britaniya Hind Okeanı Ərazisi");
    namesMap.put("IQ", "İraq");
    namesMap.put("IR", "İran");
    namesMap.put("IS", "İslandiya");
    namesMap.put("IT", "İtaliya");
    namesMap.put("JE", "Cersi");
    namesMap.put("JM", "Yamayka");
    namesMap.put("JO", "İordaniya");
    namesMap.put("JP", "Yaponiya");
    namesMap.put("KE", "Keniya");
    namesMap.put("KG", "Qırğızıstan");
    namesMap.put("KH", "Kamboca");
    namesMap.put("KM", "Komor Adaları");
    namesMap.put("KN", "San Kits və Nevis");
    namesMap.put("KP", "Şimali Koreya");
    namesMap.put("KR", "Cənubi Koreya");
    namesMap.put("KW", "Küveyt");
    namesMap.put("KY", "Kayman Adaları");
    namesMap.put("KZ", "Qazaxıstan");
    namesMap.put("LB", "Livan");
    namesMap.put("LC", "San Lüsiya");
    namesMap.put("LI", "Lixtenşteyn");
    namesMap.put("LK", "Şri Lanka");
    namesMap.put("LR", "Liberiya");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litva");
    namesMap.put("LU", "Lüksemburq");
    namesMap.put("LV", "Latviya");
    namesMap.put("LY", "Liviya");
    namesMap.put("MA", "Mərakeş");
    namesMap.put("MC", "Monako");
    namesMap.put("ME", "Monteneqro");
    namesMap.put("MF", "San Martin");
    namesMap.put("MG", "Madaqaskar");
    namesMap.put("MH", "Marşal Adaları");
    namesMap.put("MK", "Makedoniya");
    namesMap.put("MM", "Myanma");
    namesMap.put("MN", "Monqoliya");
    namesMap.put("MO", "Makao Xüsusi İnzibati Ərazi Çin");
    namesMap.put("MP", "Şimali Mariana Adaları");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Mavritaniya");
    namesMap.put("MS", "Monserat");
    namesMap.put("MU", "Mavriki");
    namesMap.put("MV", "Maldiv Adaları");
    namesMap.put("MW", "Malavi");
    namesMap.put("MX", "Meksika");
    namesMap.put("MY", "Malayziya");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namibiya");
    namesMap.put("NC", "Yeni Kaledoniya");
    namesMap.put("NF", "Norfolk Adası");
    namesMap.put("NG", "Nigeriya");
    namesMap.put("NI", "Nikaraqua");
    namesMap.put("NL", "Niderland");
    namesMap.put("NO", "Norveç");
    namesMap.put("NZ", "Yeni Zelandiya");
    namesMap.put("PF", "Fransız Polineziyası");
    namesMap.put("PG", "Papua Yeni Qvineya");
    namesMap.put("PH", "Filippin");
    namesMap.put("PL", "Polşa");
    namesMap.put("PM", "San Pier və Mikelon");
    namesMap.put("PN", "Pitkern Adaları");
    namesMap.put("PR", "Puerto Riko");
    namesMap.put("PS", "Fələstin Əraziləri");
    namesMap.put("PT", "Portuqal");
    namesMap.put("PY", "Paraqvay");
    namesMap.put("QO", "Uzaq Okeaniya");
    namesMap.put("RE", "Reunion");
    namesMap.put("RO", "Rumıniya");
    namesMap.put("RS", "Serbiya");
    namesMap.put("RU", "Rusiya");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Səudiyyə Ərəbistanı");
    namesMap.put("SB", "Solomon Adaları");
    namesMap.put("SC", "Seyşel Adaları");
    namesMap.put("SE", "İsveç");
    namesMap.put("SG", "Sinqapur");
    namesMap.put("SH", "Müqəddəs Yelena");
    namesMap.put("SI", "Sloveniya");
    namesMap.put("SJ", "Svalbard və Yan Mayen");
    namesMap.put("SK", "Slovakiya");
    namesMap.put("SL", "Siera Leon");
    namesMap.put("SN", "Seneqal");
    namesMap.put("SO", "Somali");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Cənubi Sudan");
    namesMap.put("ST", "Sao Tome və Prinsip");
    namesMap.put("SV", "Salvador");
    namesMap.put("SY", "Suriya");
    namesMap.put("SZ", "Svazilend");
    namesMap.put("TA", "Tristan da Kunya");
    namesMap.put("TC", "Turks və Kaikos Adaları");
    namesMap.put("TD", "Çad");
    namesMap.put("TF", "Fransa Cənub Əraziləri");
    namesMap.put("TG", "Toqo");
    namesMap.put("TH", "Tayland");
    namesMap.put("TJ", "Tacikistan");
    namesMap.put("TL", "Şərqi Timor");
    namesMap.put("TM", "Türkmənistan");
    namesMap.put("TN", "Tunis");
    namesMap.put("TO", "Tonqa");
    namesMap.put("TR", "Türkiya");
    namesMap.put("TT", "Trinidad və Tobaqo");
    namesMap.put("TW", "Tayvan");
    namesMap.put("TZ", "Tanzaniya");
    namesMap.put("UA", "Ukrayna");
    namesMap.put("UG", "Uqanda");
    namesMap.put("UM", "Birləşmiş Ştatlar Uzaq Adalar");
    namesMap.put("US", "Amerika Birləşmiş Ştatları");
    namesMap.put("UY", "Uruqvay");
    namesMap.put("UZ", "Özbəkistan");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "San Vinsent və Qrenada");
    namesMap.put("VE", "Venesuela");
    namesMap.put("VG", "Britaniya Vircin Adaları");
    namesMap.put("VI", "ABŞ Vircin Adaları");
    namesMap.put("VN", "Vyetnam");
    namesMap.put("WF", "Uolis və Futuna");
    namesMap.put("YE", "Yəmən");
    namesMap.put("YT", "Mayot");
    namesMap.put("ZA", "Cənub Afrika");
    namesMap.put("ZM", "Zambiya");
    namesMap.put("ZW", "Zimbabve");
    namesMap.put("ZZ", "Naməlum Region");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dünya",
        "002": "Afrika",
        "003": "Şimali Amerika",
        "005": "Cənubi Amerika",
        "009": "Okeaniya",
        "011": "Qərbi Afrika",
        "013": "Mərkəzi Amerika",
        "014": "Şərqi Afrika",
        "015": "Şimali Afrika",
        "017": "Mərkəzi Afrika",
        "018": "Cənubi Afrika",
        "019": "Amerikalar",
        "021": "Şimal Amerikası",
        "029": "Karib",
        "030": "Şərqi Asiya",
        "034": "Cənubi Asiya",
        "035": "Cənub-Şərqi Asiya",
        "039": "Cənubi Avropa",
        "053": "Avstralaziya",
        "054": "Melaneziya",
        "057": "Mikroneziya Regionu",
        "061": "Polineziya",
        "142": "Asiya",
        "143": "Mərkəzi Asiya",
        "145": "Qərbi Asiya",
        "150": "Avropa",
        "151": "Şərqi Avropa",
        "154": "Şimali Avropa",
        "155": "Qərbi Avropa",
        "419": "Latın Amerikası",
        "AC": "Yüksəliş Adası",
        "AE": "Birləşmiş Ərəb Əmirlikləri",
        "AF": "Əfqanıstan",
        "AG": "Antiqua və Barbuda",
        "AI": "Angila",
        "AL": "Albaniya",
        "AM": "Ermənistan",
        "AN": "Hollandiya antilleri",
        "AO": "Anqola",
        "AQ": "Antarktika",
        "AS": "Amerika Samoası",
        "AT": "Avstriya",
        "AU": "Avstraliya",
        "AX": "Aland Adaları",
        "AZ": "Azərbaycan",
        "BA": "Bosniya və Hersoqovina",
        "BD": "Banqladeş",
        "BE": "Belçika",
        "BG": "Bolqariya",
        "BH": "Bəhreyn",
        "BL": "San Bartolomey",
        "BN": "Bruney",
        "BO": "Boliviya",
        "BQ": "Karib Niderlandı",
        "BR": "Braziliya",
        "BS": "Baham Adaları",
        "BT": "Butan",
        "BV": "Buve Adası",
        "BW": "Botsvana",
        "BZ": "Beliz",
        "CA": "Kanada",
        "CC": "Kokos Adaları",
        "CD": "Konqo - Kinşasa",
        "CF": "Mərkəzi Afrika Respublikası",
        "CG": "Konqo - Brazzavil",
        "CH": "İsveçrə",
        "CI": "Fil Dişi Sahili",
        "CK": "Kuk Adaları",
        "CL": "Çili",
        "CM": "Kamerun",
        "CN": "Çin",
        "CO": "Kolumbiya",
        "CP": "Klipperton Adası",
        "CR": "Kosta Rika",
        "CU": "Kuba",
        "CV": "Kape Verde",
        "CW": "Kurasao",
        "CX": "Milad Adası",
        "CY": "Kipr",
        "CZ": "Çexiya",
        "DE": "Almaniya",
        "DG": "Dieqo Qarsiya",
        "DJ": "Cibuti",
        "DK": "Danimarka",
        "DM": "Dominika",
        "DO": "Dominikan Respublikası",
        "DZ": "Əlcəzair",
        "EA": "Seuta və Melilya",
        "EC": "Ekvador",
        "EE": "Estoniya",
        "EG": "Misir",
        "EH": "Qərbi Sahara",
        "ER": "Eritreya",
        "ES": "İspaniya",
        "ET": "Efiopiya",
        "EU": "Avropa Birliyi",
        "FI": "Finlandiya",
        "FJ": "Fici",
        "FK": "Folklend Adaları",
        "FM": "Mikroneziya",
        "FO": "Farer Adaları",
        "FR": "Fransa",
        "GA": "Qabon",
        "GB": "Birləşmiş Krallıq",
        "GD": "Qrenada",
        "GE": "Gürcüstan",
        "GF": "Fransız Qviyanası",
        "GG": "Gernsey",
        "GH": "Qana",
        "GL": "Qrenlandiya",
        "GM": "Qambiya",
        "GN": "Qvineya",
        "GP": "Qvadelupa",
        "GQ": "Ekvatorial Qvineya",
        "GR": "Yunanıstan",
        "GS": "Cənubi Corciya və Cənubi Sendviç Adaları",
        "GT": "Qvatemala",
        "GU": "Quam",
        "GW": "Qvineya-Bisau",
        "GY": "Qviyana",
        "HK": "Honq Konq Xüsusi İnzibati Ərazi Çin",
        "HM": "Herd və Mak Donald Adaları",
        "HR": "Xorvatiya",
        "HU": "Macarıstan",
        "IC": "Kanar Adaları",
        "ID": "İndoneziya",
        "IE": "İrlandiya",
        "IL": "İsrail",
        "IM": "Men Adası",
        "IN": "Hindistan",
        "IO": "Britaniya Hind Okeanı Ərazisi",
        "IQ": "İraq",
        "IR": "İran",
        "IS": "İslandiya",
        "IT": "İtaliya",
        "JE": "Cersi",
        "JM": "Yamayka",
        "JO": "İordaniya",
        "JP": "Yaponiya",
        "KE": "Keniya",
        "KG": "Qırğızıstan",
        "KH": "Kamboca",
        "KM": "Komor Adaları",
        "KN": "San Kits və Nevis",
        "KP": "Şimali Koreya",
        "KR": "Cənubi Koreya",
        "KW": "Küveyt",
        "KY": "Kayman Adaları",
        "KZ": "Qazaxıstan",
        "LB": "Livan",
        "LC": "San Lüsiya",
        "LI": "Lixtenşteyn",
        "LK": "Şri Lanka",
        "LR": "Liberiya",
        "LS": "Lesoto",
        "LT": "Litva",
        "LU": "Lüksemburq",
        "LV": "Latviya",
        "LY": "Liviya",
        "MA": "Mərakeş",
        "MC": "Monako",
        "ME": "Monteneqro",
        "MF": "San Martin",
        "MG": "Madaqaskar",
        "MH": "Marşal Adaları",
        "MK": "Makedoniya",
        "MM": "Myanma",
        "MN": "Monqoliya",
        "MO": "Makao Xüsusi İnzibati Ərazi Çin",
        "MP": "Şimali Mariana Adaları",
        "MQ": "Martinik",
        "MR": "Mavritaniya",
        "MS": "Monserat",
        "MU": "Mavriki",
        "MV": "Maldiv Adaları",
        "MW": "Malavi",
        "MX": "Meksika",
        "MY": "Malayziya",
        "MZ": "Mozambik",
        "NA": "Namibiya",
        "NC": "Yeni Kaledoniya",
        "NF": "Norfolk Adası",
        "NG": "Nigeriya",
        "NI": "Nikaraqua",
        "NL": "Niderland",
        "NO": "Norveç",
        "NZ": "Yeni Zelandiya",
        "PF": "Fransız Polineziyası",
        "PG": "Papua Yeni Qvineya",
        "PH": "Filippin",
        "PL": "Polşa",
        "PM": "San Pier və Mikelon",
        "PN": "Pitkern Adaları",
        "PR": "Puerto Riko",
        "PS": "Fələstin Əraziləri",
        "PT": "Portuqal",
        "PY": "Paraqvay",
        "QO": "Uzaq Okeaniya",
        "RE": "Reunion",
        "RO": "Rumıniya",
        "RS": "Serbiya",
        "RU": "Rusiya",
        "RW": "Ruanda",
        "SA": "Səudiyyə Ərəbistanı",
        "SB": "Solomon Adaları",
        "SC": "Seyşel Adaları",
        "SE": "İsveç",
        "SG": "Sinqapur",
        "SH": "Müqəddəs Yelena",
        "SI": "Sloveniya",
        "SJ": "Svalbard və Yan Mayen",
        "SK": "Slovakiya",
        "SL": "Siera Leon",
        "SN": "Seneqal",
        "SO": "Somali",
        "SR": "Surinam",
        "SS": "Cənubi Sudan",
        "ST": "Sao Tome və Prinsip",
        "SV": "Salvador",
        "SY": "Suriya",
        "SZ": "Svazilend",
        "TA": "Tristan da Kunya",
        "TC": "Turks və Kaikos Adaları",
        "TD": "Çad",
        "TF": "Fransa Cənub Əraziləri",
        "TG": "Toqo",
        "TH": "Tayland",
        "TJ": "Tacikistan",
        "TL": "Şərqi Timor",
        "TM": "Türkmənistan",
        "TN": "Tunis",
        "TO": "Tonqa",
        "TR": "Türkiya",
        "TT": "Trinidad və Tobaqo",
        "TW": "Tayvan",
        "TZ": "Tanzaniya",
        "UA": "Ukrayna",
        "UG": "Uqanda",
        "UM": "Birləşmiş Ştatlar Uzaq Adalar",
        "US": "Amerika Birləşmiş Ştatları",
        "UY": "Uruqvay",
        "UZ": "Özbəkistan",
        "VA": "Vatikan",
        "VC": "San Vinsent və Qrenada",
        "VE": "Venesuela",
        "VG": "Britaniya Vircin Adaları",
        "VI": "ABŞ Vircin Adaları",
        "VN": "Vyetnam",
        "WF": "Uolis və Futuna",
        "YE": "Yəmən",
        "YT": "Mayot",
        "ZA": "Cənub Afrika",
        "ZM": "Zambiya",
        "ZW": "Zimbabve",
        "ZZ": "Naməlum Region"
    };
  }-*/;
}
