/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "haw" locale.
 */
public class LocalizedNamesImpl_haw extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AD",
        "AE",
        "AF",
        "AG",
        "AI",
        "AL",
        "AM",
        "AO",
        "NZ",
        "AQ",
        "AR",
        "AS",
        "AT",
        "GB",
        "AW",
        "AX",
        "AZ",
        "BA",
        "BB",
        "BD",
        "BE",
        "BF",
        "BG",
        "BH",
        "BI",
        "BJ",
        "BL",
        "BM",
        "BN",
        "BO",
        "BQ",
        "BR",
        "BS",
        "BT",
        "BV",
        "BW",
        "BY",
        "BZ",
        "CC",
        "CD",
        "CF",
        "CG",
        "CH",
        "CI",
        "CK",
        "CL",
        "CM",
        "CO",
        "CP",
        "CR",
        "CU",
        "CV",
        "CW",
        "CX",
        "CY",
        "CZ",
        "DG",
        "DJ",
        "DM",
        "DO",
        "DZ",
        "EA",
        "EC",
        "EE",
        "EG",
        "EH",
        "ER",
        "ET",
        "EU",
        "FI",
        "FJ",
        "FK",
        "FM",
        "FO",
        "GA",
        "GD",
        "GE",
        "GF",
        "GG",
        "GH",
        "GI",
        "GL",
        "GM",
        "GN",
        "GP",
        "GQ",
        "GS",
        "GT",
        "GU",
        "GW",
        "GY",
        "GR",
        "HK",
        "HM",
        "HN",
        "NL",
        "HR",
        "HT",
        "HU",
        "JP",
        "IC",
        "ID",
        "IM",
        "IO",
        "IQ",
        "IR",
        "IS",
        "JE",
        "JM",
        "JO",
        "CA",
        "KE",
        "DE",
        "DK",
        "ES",
        "KG",
        "KH",
        "KI",
        "CN",
        "KM",
        "KN",
        "KP",
        "KR",
        "KW",
        "KY",
        "KZ",
        "LA",
        "LB",
        "LC",
        "LI",
        "LK",
        "LR",
        "LS",
        "LT",
        "LU",
        "RU",
        "LV",
        "LY",
        "MA",
        "MC",
        "MD",
        "ME",
        "MX",
        "MF",
        "MG",
        "MH",
        "MK",
        "ML",
        "MM",
        "MN",
        "MO",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "MV",
        "MW",
        "MY",
        "MZ",
        "NA",
        "NC",
        "NE",
        "NF",
        "NG",
        "NI",
        "NO",
        "NP",
        "NR",
        "NU",
        "AU",
        "OM",
        "PA",
        "FR",
        "PE",
        "PF",
        "PG",
        "PK",
        "PL",
        "PM",
        "PN",
        "PR",
        "PS",
        "PT",
        "PW",
        "PY",
        "QA",
        "QO",
        "RE",
        "RO",
        "RS",
        "RW",
        "SA",
        "SB",
        "SC",
        "SD",
        "SE",
        "SG",
        "SH",
        "SI",
        "SJ",
        "SK",
        "SL",
        "SM",
        "SN",
        "SO",
        "SR",
        "SS",
        "ST",
        "SV",
        "SX",
        "SY",
        "SZ",
        "TA",
        "TC",
        "TD",
        "TF",
        "TG",
        "TH",
        "TJ",
        "TK",
        "TL",
        "TM",
        "TN",
        "TO",
        "TR",
        "TT",
        "TV",
        "TW",
        "TZ",
        "UA",
        "UG",
        "UM",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "YE",
        "YT",
        "ZA",
        "ZM",
        "ZW",
        "PH",
        "US",
        "IT",
        "IE",
        "IN",
        "IL",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AU", "Nūhōlani");
    namesMap.put("CA", "Kanakā");
    namesMap.put("CN", "Kina");
    namesMap.put("DE", "Kelemānia");
    namesMap.put("DK", "Kenemaka");
    namesMap.put("ES", "Kepania");
    namesMap.put("FR", "Palani");
    namesMap.put("GB", "Aupuni Mōʻī Hui Pū ʻIa");
    namesMap.put("GR", "Helene");
    namesMap.put("IE", "ʻIlelani");
    namesMap.put("IL", "ʻIseraʻela");
    namesMap.put("IN", "ʻĪnia");
    namesMap.put("IT", "ʻĪkālia");
    namesMap.put("JP", "Iāpana");
    namesMap.put("MX", "Mekiko");
    namesMap.put("NL", "Hōlani");
    namesMap.put("NZ", "Aotearoa");
    namesMap.put("PH", "ʻĀina Pilipino");
    namesMap.put("RU", "Lūkia");
    namesMap.put("US", "ʻAmelika Hui Pū ʻIa");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AU": "Nūhōlani",
        "CA": "Kanakā",
        "CN": "Kina",
        "DE": "Kelemānia",
        "DK": "Kenemaka",
        "ES": "Kepania",
        "FR": "Palani",
        "GB": "Aupuni Mōʻī Hui Pū ʻIa",
        "GR": "Helene",
        "IE": "ʻIlelani",
        "IL": "ʻIseraʻela",
        "IN": "ʻĪnia",
        "IT": "ʻĪkālia",
        "JP": "Iāpana",
        "MX": "Mekiko",
        "NL": "Hōlani",
        "NZ": "Aotearoa",
        "PH": "ʻĀina Pilipino",
        "RU": "Lūkia",
        "US": "ʻAmelika Hui Pū ʻIa"
    };
  }-*/;
}
