/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import com.google.common.truth.Truth;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@GwtCompatible(emulated=true)
public class MultisetRemoveTester<E>
extends AbstractMultisetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveNegative() {
        try {
            this.getMultiset().remove(this.samples.e0, -1);
            MultisetRemoveTester.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveUnsupported() {
        try {
            this.getMultiset().remove(this.samples.e0, 2);
            MultisetRemoveTester.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveZeroNoOp() {
        int originalCount = this.getMultiset().count(this.samples.e0);
        MultisetRemoveTester.assertEquals((String)"old count", (int)originalCount, (int)this.getMultiset().remove(this.samples.e0, 0));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_present() {
        MultisetRemoveTester.assertEquals((String)"multiset.remove(present, 2) didn't return the old count", (int)1, (int)this.getMultiset().remove(this.samples.e0, 2));
        MultisetRemoveTester.assertFalse((String)"multiset contains present after multiset.remove(present, 2)", (boolean)this.getMultiset().contains(this.samples.e0));
        MultisetRemoveTester.assertEquals((int)0, (int)this.getMultiset().count(this.samples.e0));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_some_occurrences_present() {
        this.initThreeCopies();
        MultisetRemoveTester.assertEquals((String)"multiset.remove(present, 2) didn't return the old count", (int)3, (int)this.getMultiset().remove(this.samples.e0, 2));
        MultisetRemoveTester.assertTrue((String)"multiset contains present after multiset.remove(present, 2)", (boolean)this.getMultiset().contains(this.samples.e0));
        MultisetRemoveTester.assertEquals((int)1, (int)this.getMultiset().count(this.samples.e0));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_absent() {
        MultisetRemoveTester.assertEquals((String)"multiset.remove(absent, 0) didn't return 0", (int)0, (int)this.getMultiset().remove(this.samples.e3, 2));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_unsupported_absent() {
        try {
            MultisetRemoveTester.assertEquals((String)"multiset.remove(absent, 2) didn't return 0 or throw an exception", (int)0, (int)this.getMultiset().remove(this.samples.e3, 2));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_0() {
        int oldCount = this.getMultiset().count(this.samples.e0);
        MultisetRemoveTester.assertEquals((String)"multiset.remove(E, 0) didn't return the old count", (int)oldCount, (int)this.getMultiset().remove(this.samples.e0, 0));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_negative() {
        try {
            this.getMultiset().remove(this.samples.e0, -1);
            MultisetRemoveTester.fail((String)"multiset.remove(E, -1) didn't throw an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_wrongType() {
        MultisetRemoveTester.assertEquals((String)"multiset.remove(wrongType, 1) didn't return 0", (int)0, (int)this.getMultiset().remove((Object)WrongType.VALUE, 1));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    public void testRemove_nullPresent() {
        this.initCollectionWithNullElement();
        MultisetRemoveTester.assertEquals((int)1, (int)this.getMultiset().remove(null, 2));
        MultisetRemoveTester.assertFalse((String)"multiset contains present after multiset.remove(present, 2)", (boolean)this.getMultiset().contains(null));
        MultisetRemoveTester.assertEquals((int)0, (int)this.getMultiset().count(null));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemove_nullAbsent() {
        MultisetRemoveTester.assertEquals((int)0, (int)this.getMultiset().remove(null, 2));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE}, absent={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemove_nullForbidden() {
        try {
            this.getMultiset().remove(null, 2);
            MultisetRemoveTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveAllIgnoresCount() {
        this.initThreeCopies();
        MultisetRemoveTester.assertTrue((boolean)this.getMultiset().removeAll(Collections.singleton(this.samples.e0)));
        Truth.assertThat(this.getMultiset()).isEmpty();
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRetainAllIgnoresCount() {
        this.initThreeCopies();
        List contents = Helpers.copyToList(this.getMultiset());
        MultisetRemoveTester.assertFalse((boolean)this.getMultiset().retainAll(Collections.singleton(this.samples.e0)));
        this.expectContents(contents);
    }

    @GwtIncompatible(value="reflection")
    public static List<Method> getRemoveDuplicateInitializingMethods() {
        return Arrays.asList(Helpers.getMethod(MultisetRemoveTester.class, "testRemove_some_occurrences_present"));
    }
}

