/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractBiMapTester;
import java.util.Iterator;
import java.util.Map;

@GwtCompatible
public class BiMapRemoveTester<K, V>
extends AbstractBiMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveKeyRemovesFromInverse() {
        this.getMap().remove(((Map.Entry)this.samples.e0).getKey());
        this.expectMissing((Map.Entry)this.samples.e0);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveKeyFromKeySetRemovesFromInverse() {
        this.getMap().keySet().remove(((Map.Entry)this.samples.e0).getKey());
        this.expectMissing((Map.Entry)this.samples.e0);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveFromValuesRemovesFromInverse() {
        this.getMap().values().remove(((Map.Entry)this.samples.e0).getValue());
        this.expectMissing((Map.Entry)this.samples.e0);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveFromInverseRemovesFromForward() {
        this.getMap().inverse().remove(((Map.Entry)this.samples.e0).getValue());
        this.expectMissing((Map.Entry)this.samples.e0);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveFromInverseKeySetRemovesFromForward() {
        this.getMap().inverse().keySet().remove(((Map.Entry)this.samples.e0).getValue());
        this.expectMissing((Map.Entry)this.samples.e0);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveFromInverseValuesRemovesFromInverse() {
        this.getMap().inverse().values().remove(((Map.Entry)this.samples.e0).getKey());
        this.expectMissing((Map.Entry)this.samples.e0);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testKeySetIteratorRemove() {
        int initialSize = this.getNumElements();
        Iterator iterator = this.getMap().keySet().iterator();
        iterator.next();
        iterator.remove();
        BiMapRemoveTester.assertEquals((int)(initialSize - 1), (int)this.getMap().size());
        BiMapRemoveTester.assertEquals((int)(initialSize - 1), (int)this.getMap().inverse().size());
    }
}

