/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

@GwtCompatible(emulated=true)
public class Helpers {
    private static final Comparator<Comparable> NATURAL_ORDER = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable left, Comparable right) {
            return left.compareTo(right);
        }
    };

    static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <E> List<E> copyToList(Iterable<? extends E> elements) {
        ArrayList list = new ArrayList();
        Helpers.addAll(list, elements);
        return list;
    }

    public static <E> List<E> copyToList(E[] elements) {
        return Helpers.copyToList(Arrays.asList(elements));
    }

    public static <E> Set<E> copyToSet(Iterable<? extends E> elements) {
        LinkedHashSet set = new LinkedHashSet();
        Helpers.addAll(set, elements);
        return set;
    }

    public static <E> Set<E> copyToSet(E[] elements) {
        return Helpers.copyToSet(Arrays.asList(elements));
    }

    public static <K, V> Map.Entry<K, V> mapEntry(K key, V value) {
        return Collections.singletonMap(key, value).entrySet().iterator().next();
    }

    public static void assertEqualIgnoringOrder(Iterable<?> expected, Iterable<?> actual) {
        List<?> exp = Helpers.copyToList(expected);
        List<?> act = Helpers.copyToList(actual);
        String actString = act.toString();
        for (Object object : exp) {
            if (act.remove(object)) continue;
            String string = String.valueOf(String.valueOf(object));
            String string2 = String.valueOf(String.valueOf(exp));
            String string3 = String.valueOf(String.valueOf(actString));
            Assert.fail((String)new StringBuilder(57 + string.length() + string2.length() + string3.length()).append("did not contain expected element ").append(string).append(", ").append("expected = ").append(string2).append(", actual = ").append(string3).toString());
        }
        String string = String.valueOf(String.valueOf(act));
        Assert.assertTrue((String)new StringBuilder(21 + string.length()).append("unexpected elements: ").append(string).toString(), (boolean)act.isEmpty());
    }

    public static void assertContentsAnyOrder(Iterable<?> actual, Object ... expected) {
        Helpers.assertEqualIgnoringOrder(Arrays.asList(expected), actual);
    }

    public static <E> boolean addAll(Collection<E> addTo, Iterable<? extends E> elementsToAdd) {
        boolean modified = false;
        for (E e : elementsToAdd) {
            modified |= addTo.add(e);
        }
        return modified;
    }

    static <T> Iterable<T> reverse(final List<T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final ListIterator listIter = list.listIterator(list.size());
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return listIter.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return listIter.previous();
                    }

                    @Override
                    public void remove() {
                        listIter.remove();
                    }
                };
            }
        };
    }

    static <T> Iterator<T> cycle(final Iterable<T> iterable) {
        return new Iterator<T>(){
            Iterator<T> iterator = Collections.emptySet().iterator();

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                }
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <T> T get(Iterator<T> iterator, int position) {
        for (int i = 0; i < position; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    static void fail(Throwable cause, Object message) {
        AssertionFailedError assertionFailedError = new AssertionFailedError(String.valueOf(message));
        assertionFailedError.initCause(cause);
        throw assertionFailedError;
    }

    public static <K, V> Comparator<Map.Entry<K, V>> entryComparator(final Comparator<? super K> keyComparator) {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return keyComparator == null ? ((Comparable)a.getKey()).compareTo(b.getKey()) : keyComparator.compare(a.getKey(), b.getKey());
            }
        };
    }

    public static <T> void testComparator(Comparator<? super T> comparator, T ... valuesInExpectedOrder) {
        Helpers.testComparator(comparator, Arrays.asList(valuesInExpectedOrder));
    }

    public static <T> void testComparator(Comparator<? super T> comparator, List<T> valuesInExpectedOrder) {
        for (int i = 0; i < valuesInExpectedOrder.size(); ++i) {
            String string;
            T t = valuesInExpectedOrder.get(i);
            for (int j = 0; j < i; ++j) {
                T lesser = valuesInExpectedOrder.get(j);
                string = String.valueOf(String.valueOf(comparator));
                String string2 = String.valueOf(String.valueOf(lesser));
                String string3 = String.valueOf(String.valueOf(t));
                Assert.assertTrue((String)new StringBuilder(12 + string.length() + string2.length() + string3.length()).append(string).append(".compare(").append(string2).append(", ").append(string3).append(")").toString(), (comparator.compare(lesser, t) < 0 ? 1 : 0) != 0);
            }
            String string4 = String.valueOf(String.valueOf(comparator));
            String string5 = String.valueOf(String.valueOf(t));
            string = String.valueOf(String.valueOf(t));
            Assert.assertEquals((String)new StringBuilder(12 + string4.length() + string5.length() + string.length()).append(string4).append(".compare(").append(string5).append(", ").append(string).append(")").toString(), (int)0, (int)comparator.compare(t, t));
            for (int j = i + 1; j < valuesInExpectedOrder.size(); ++j) {
                T greater = valuesInExpectedOrder.get(j);
                String string6 = String.valueOf(String.valueOf(comparator));
                String string7 = String.valueOf(String.valueOf(greater));
                String string8 = String.valueOf(String.valueOf(t));
                Assert.assertTrue((String)new StringBuilder(12 + string6.length() + string7.length() + string8.length()).append(string6).append(".compare(").append(string7).append(", ").append(string8).append(")").toString(), (comparator.compare(greater, t) > 0 ? 1 : 0) != 0);
            }
        }
    }

    public static <T extends Comparable<? super T>> void testCompareToAndEquals(List<T> valuesInExpectedOrder) {
        for (int i = 0; i < valuesInExpectedOrder.size(); ++i) {
            Comparable t = (Comparable)valuesInExpectedOrder.get(i);
            for (int j = 0; j < i; ++j) {
                Comparable lesser = (Comparable)valuesInExpectedOrder.get(j);
                String string = String.valueOf(String.valueOf(lesser));
                String string2 = String.valueOf(String.valueOf(t));
                Assert.assertTrue((String)new StringBuilder(12 + string.length() + string2.length()).append(string).append(".compareTo(").append(string2).append(")").toString(), (lesser.compareTo(t) < 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)lesser.equals(t));
            }
            String string = String.valueOf(String.valueOf(t));
            String string3 = String.valueOf(String.valueOf(t));
            Assert.assertEquals((String)new StringBuilder(12 + string.length() + string3.length()).append(string).append(".compareTo(").append(string3).append(")").toString(), (int)0, (int)t.compareTo(t));
            Assert.assertTrue((boolean)t.equals(t));
            for (int j = i + 1; j < valuesInExpectedOrder.size(); ++j) {
                Comparable greater = (Comparable)valuesInExpectedOrder.get(j);
                String string4 = String.valueOf(String.valueOf(greater));
                String string5 = String.valueOf(String.valueOf(t));
                Assert.assertTrue((String)new StringBuilder(12 + string4.length() + string5.length()).append(string4).append(".compareTo(").append(string5).append(")").toString(), (greater.compareTo(t) > 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)greater.equals(t));
            }
        }
    }

    public static <T> Collection<T> misleadingSizeCollection(final int delta) {
        return new ArrayList<T>(){

            @Override
            public int size() {
                return Math.max(0, super.size() + delta);
            }
        };
    }

    public static <K, V> Map.Entry<K, V> nefariousMapEntry(final K key, final V value) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    e.setValue(value);
                    return Helpers.equal(this.getKey(), e.getKey()) && Helpers.equal(this.getValue(), e.getValue());
                }
                return false;
            }

            @Override
            public int hashCode() {
                Object k = this.getKey();
                Object v = this.getValue();
                return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
            }

            public String toString() {
                String string = String.valueOf(String.valueOf(this.getKey()));
                String string2 = String.valueOf(String.valueOf(this.getValue()));
                return new StringBuilder(1 + string.length() + string2.length()).append(string).append("=").append(string2).toString();
            }
        };
    }

    static <E> List<E> castOrCopyToList(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E e : iterable) {
            list.add(e);
        }
        return list;
    }

    public static <K extends Comparable, V> Iterable<Map.Entry<K, V>> orderEntriesByKey(List<Map.Entry<K, V>> insertionOrder) {
        Collections.sort(insertionOrder, Helpers.entryComparator(NATURAL_ORDER));
        return insertionOrder;
    }

    @GwtIncompatible(value="reflection")
    public static Method getMethod(Class<?> clazz, String name) {
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final class NullsBeforeTwo
    extends NullsBefore {
        public static final NullsBeforeTwo INSTANCE = new NullsBeforeTwo();

        private NullsBeforeTwo() {
            super("two");
        }
    }

    public static final class NullsBeforeB
    extends NullsBefore {
        public static final NullsBeforeB INSTANCE = new NullsBeforeB();

        private NullsBeforeB() {
            super("b");
        }
    }

    public static abstract class NullsBefore
    implements Comparator<String>,
    Serializable {
        @GwtTransient
        private final String justAfterNull;

        protected NullsBefore(String justAfterNull) {
            if (justAfterNull == null) {
                throw new NullPointerException();
            }
            this.justAfterNull = justAfterNull;
        }

        @Override
        public int compare(String lhs, String rhs) {
            if (lhs == rhs) {
                return 0;
            }
            if (lhs == null) {
                if (rhs.equals(this.justAfterNull)) {
                    return -1;
                }
                return this.justAfterNull.compareTo(rhs);
            }
            if (rhs == null) {
                if (lhs.equals(this.justAfterNull)) {
                    return 1;
                }
                return lhs.compareTo(this.justAfterNull);
            }
            return lhs.compareTo(rhs);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof NullsBefore) {
                NullsBefore other = (NullsBefore)obj;
                return this.justAfterNull.equals(other.justAfterNull);
            }
            return false;
        }

        public int hashCode() {
            return this.justAfterNull.hashCode();
        }
    }

    private static @interface GwtTransient {
    }
}

