/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.javadoc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.googlejavaformat.java.javadoc.NestingCounter;
import com.google.googlejavaformat.java.javadoc.Token;

final class JavadocWriter {
    private final int blockIndent;
    private final StringBuilder output = new StringBuilder();
    private boolean continuingListItemOfInnermostList;
    private boolean continuingFooterTag;
    private final NestingCounter continuingListItemCount = new NestingCounter();
    private final NestingCounter continuingListCount = new NestingCounter();
    private final NestingCounter postWriteModifiedContinuingListCount = new NestingCounter();
    private int remainingOnLine;
    private boolean atStartOfLine;
    private RequestedWhitespace requestedWhitespace = RequestedWhitespace.NONE;
    private Token requestedMoeBeginStripComment;
    private int indentForMoeEndStripComment;
    private boolean wroteAnythingSignificant;
    private static final ImmutableSet<Token.Type> START_OF_LINE_TOKENS = Sets.immutableEnumSet((Enum)Token.Type.LIST_ITEM_OPEN_TAG, (Enum[])new Token.Type[]{Token.Type.PARAGRAPH_OPEN_TAG, Token.Type.HEADER_OPEN_TAG});

    JavadocWriter(int blockIndent) {
        this.blockIndent = blockIndent;
    }

    void requestWhitespace() {
        this.requestWhitespace(RequestedWhitespace.WHITESPACE);
    }

    void requestMoeBeginStripComment(Token token) {
        this.requestedMoeBeginStripComment = (Token)Preconditions.checkNotNull((Object)token);
    }

    void writeBeginJavadoc() {
        this.output.append("/**");
        this.writeNewline();
    }

    void writeEndJavadoc() {
        this.output.append("\n");
        this.appendSpaces(this.blockIndent + 1);
        this.output.append("*/");
    }

    void writeFooterJavadocTagStart(Token token) {
        this.continuingListItemOfInnermostList = false;
        this.continuingListItemCount.reset();
        this.continuingListCount.reset();
        this.postWriteModifiedContinuingListCount.reset();
        if (this.wroteAnythingSignificant) {
            if (!this.continuingFooterTag) {
                this.requestBlankLine();
            } else {
                this.continuingFooterTag = false;
                this.requestNewline();
            }
        }
        this.writeToken(token);
        this.continuingFooterTag = true;
    }

    void writeListOpen(Token token) {
        this.requestBlankLine();
        this.writeToken(token);
        this.continuingListItemOfInnermostList = false;
        this.continuingListCount.increment();
        this.postWriteModifiedContinuingListCount.increment();
        this.requestNewline();
    }

    void writeListClose(Token token) {
        this.requestNewline();
        this.continuingListItemCount.decrementIfPositive();
        this.continuingListCount.decrementIfPositive();
        this.writeToken(token);
        this.postWriteModifiedContinuingListCount.decrementIfPositive();
        this.requestBlankLine();
    }

    void writeListItemOpen(Token token) {
        this.requestNewline();
        if (this.continuingListItemOfInnermostList) {
            this.continuingListItemOfInnermostList = false;
            this.continuingListItemCount.decrementIfPositive();
        }
        this.writeToken(token);
        this.continuingListItemOfInnermostList = true;
        this.continuingListItemCount.increment();
    }

    void writeHeaderOpen(Token token) {
        this.requestBlankLine();
        this.writeToken(token);
    }

    void writeHeaderClose(Token token) {
        this.writeToken(token);
        this.requestBlankLine();
    }

    void writeParagraphOpen(Token token) {
        if (!this.wroteAnythingSignificant) {
            return;
        }
        this.requestBlankLine();
        this.writeToken(token);
    }

    void writeBlockquoteOpenOrClose(Token token) {
        this.requestBlankLine();
        this.writeToken(token);
        this.requestBlankLine();
    }

    void writePreOpen(Token token) {
        this.requestBlankLine();
        this.writeToken(token);
    }

    void writePreClose(Token token) {
        this.writeToken(token);
        this.requestBlankLine();
    }

    void writeCodeOpen(Token token) {
        this.writeToken(token);
    }

    void writeCodeClose(Token token) {
        this.writeToken(token);
    }

    void writeTableOpen(Token token) {
        this.requestBlankLine();
        this.writeToken(token);
    }

    void writeTableClose(Token token) {
        this.writeToken(token);
        this.requestBlankLine();
    }

    void writeMoeEndStripComment(Token token) {
        this.writeLineBreakNoAutoIndent();
        this.appendSpaces(this.indentForMoeEndStripComment);
        this.writeToken(token);
        this.requestNewline();
    }

    void writeHtmlComment(Token token) {
        this.requestNewline();
        this.writeToken(token);
        this.requestNewline();
    }

    void writeBr(Token token) {
        this.writeToken(token);
        this.requestNewline();
    }

    void writeLineBreakNoAutoIndent() {
        this.writeNewline(AutoIndent.NO_AUTO_INDENT);
    }

    void writeLiteral(Token token) {
        this.writeToken(token);
    }

    public String toString() {
        return this.output.toString();
    }

    private void requestBlankLine() {
        this.requestWhitespace(RequestedWhitespace.BLANK_LINE);
    }

    private void requestNewline() {
        this.requestWhitespace(RequestedWhitespace.NEWLINE);
    }

    private void requestWhitespace(RequestedWhitespace requestedWhitespace) {
        this.requestedWhitespace = (RequestedWhitespace)((Object)Ordering.natural().max((Object)requestedWhitespace, (Object)this.requestedWhitespace));
    }

    private void writeToken(Token token) {
        boolean needWhitespace;
        if (this.requestedMoeBeginStripComment != null) {
            this.requestNewline();
        }
        if (this.requestedWhitespace == RequestedWhitespace.BLANK_LINE && (this.postWriteModifiedContinuingListCount.isPositive() || this.continuingFooterTag)) {
            this.requestedWhitespace = RequestedWhitespace.NEWLINE;
        }
        if (this.requestedWhitespace == RequestedWhitespace.BLANK_LINE) {
            this.writeBlankLine();
            this.requestedWhitespace = RequestedWhitespace.NONE;
        } else if (this.requestedWhitespace == RequestedWhitespace.NEWLINE) {
            this.writeNewline();
            this.requestedWhitespace = RequestedWhitespace.NONE;
        }
        boolean bl = needWhitespace = this.requestedWhitespace == RequestedWhitespace.WHITESPACE;
        if (!this.atStartOfLine && token.length() + (needWhitespace ? 1 : 0) > this.remainingOnLine) {
            this.writeNewline();
        }
        if (!this.atStartOfLine && needWhitespace) {
            this.output.append(" ");
            --this.remainingOnLine;
        }
        if (this.requestedMoeBeginStripComment != null) {
            this.output.append(this.requestedMoeBeginStripComment.getValue());
            this.requestedMoeBeginStripComment = null;
            this.indentForMoeEndStripComment = this.innerIndent();
            this.requestNewline();
            this.writeToken(token);
            return;
        }
        this.output.append(token.getValue());
        if (!START_OF_LINE_TOKENS.contains((Object)token.getType())) {
            this.atStartOfLine = false;
        }
        this.remainingOnLine -= token.length();
        this.requestedWhitespace = RequestedWhitespace.NONE;
        this.wroteAnythingSignificant = true;
    }

    private void writeBlankLine() {
        this.output.append("\n");
        this.appendSpaces(this.blockIndent + 1);
        this.output.append("*");
        this.writeNewline();
    }

    private void writeNewline() {
        this.writeNewline(AutoIndent.AUTO_INDENT);
    }

    private void writeNewline(AutoIndent autoIndent) {
        this.output.append("\n");
        this.appendSpaces(this.blockIndent + 1);
        this.output.append("*");
        this.appendSpaces(1);
        this.remainingOnLine = 100 - this.blockIndent - 3;
        if (autoIndent == AutoIndent.AUTO_INDENT) {
            this.appendSpaces(this.innerIndent());
            this.remainingOnLine -= this.innerIndent();
        }
        this.atStartOfLine = true;
    }

    private int innerIndent() {
        int innerIndent = this.continuingListItemCount.value() * 4 + this.continuingListCount.value() * 2;
        if (this.continuingFooterTag) {
            innerIndent += 4;
        }
        return innerIndent;
    }

    private void appendSpaces(int count) {
        this.output.append(Strings.repeat((String)" ", (int)count));
    }

    static enum RequestedWhitespace {
        NONE,
        WHITESPACE,
        NEWLINE,
        BLANK_LINE;

    }

    static enum AutoIndent {
        AUTO_INDENT,
        NO_AUTO_INDENT;

    }
}

