/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.geometry.EncodedInts;
import com.google.common.geometry.PrimitiveArrays;
import com.google.common.geometry.S2Coder;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.OutputStream;

@GwtCompatible
class UintVectorCoder
implements S2Coder<PrimitiveArrays.Longs> {
    static final UintVectorCoder UINT32 = new UintVectorCoder(4);
    static final UintVectorCoder UINT64 = new UintVectorCoder(8);
    private final int typeBytes;

    private UintVectorCoder(int typeBytes) {
        this.typeBytes = typeBytes;
    }

    @Override
    public void encode(PrimitiveArrays.Longs values, OutputStream output) throws IOException {
        long oneBits = 1L;
        for (int i = 0; i < values.length(); ++i) {
            oneBits |= values.get(i);
        }
        int bytesPerWord = (63 - Long.numberOfLeadingZeros(oneBits) >>> 3) + 1;
        long totalBytes = (long)values.length() * (long)this.typeBytes | (long)(bytesPerWord - 1);
        EncodedInts.writeVarint64(output, totalBytes);
        for (int i = 0; i < values.length(); ++i) {
            EncodedInts.encodeUintWithLength(output, values.get(i), bytesPerWord);
        }
    }

    @Override
    public PrimitiveArrays.Longs decode(final PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
        int totalBytes = Ints.checkedCast((long)data.readVarint64(cursor));
        final long offset = cursor.position;
        final int size = totalBytes / this.typeBytes;
        final int bytesPerWord = (totalBytes & this.typeBytes - 1) + 1;
        cursor.position += (long)(size * bytesPerWord);
        return new PrimitiveArrays.Longs(){

            @Override
            public long get(int position) {
                return data.readUintWithLength(offset + (long)(position * bytesPerWord), bytesPerWord);
            }

            @Override
            public int length() {
                return size;
            }
        };
    }
}

