/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.client.Service;
import com.google.gdata.util.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version {
    public static final int ANY = -1;
    private Class<? extends Service> serviceClass;
    private int major;
    private int minor;
    private List<Version> impliedVersions = new ArrayList<Version>();
    private static final Pattern VERSION_PROPERTY_PATTERN = Pattern.compile("([^\\d]+-)?(\\d+)(\\.\\d+)?");

    public static Version findServiceVersion(Collection<? extends Version> versionList, Class<? extends Service> serviceClass) {
        for (Version version : versionList) {
            if (!version.getServiceClass().equals(serviceClass)) continue;
            return version;
        }
        return null;
    }

    public static Version anyMinorVersionOf(Version v) {
        return new Version(v.getServiceClass(), v.getMajor(), -1, new Version[0]);
    }

    public Version(Class<? extends Service> serviceClass, int major, int minor, Version ... impliedVersions) throws NullPointerException, IllegalArgumentException {
        if (serviceClass == null) {
            throw new NullPointerException("Null service class");
        }
        if (major < 0 && major != -1) {
            throw new IllegalArgumentException("Invalid major version:" + major);
        }
        if (minor < 0 && minor != -1) {
            throw new IllegalArgumentException("Invalid minor version:" + minor);
        }
        this.serviceClass = serviceClass;
        this.major = major;
        this.minor = minor;
        this.computeImpliedVersions(impliedVersions);
    }

    public Version(Class<? extends Service> serviceClass, String versionDescription, Version ... impliedVersions) throws IllegalArgumentException {
        this.serviceClass = serviceClass;
        Matcher matcher = VERSION_PROPERTY_PATTERN.matcher(versionDescription);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Version description does not match expected format[{service}]{major}[.{minor}]:" + versionDescription);
        }
        String minorValue = matcher.group(3);
        this.major = Integer.parseInt(matcher.group(2));
        this.minor = minorValue != null ? Integer.parseInt(minorValue.substring(1)) : -1;
        this.computeImpliedVersions(impliedVersions);
    }

    public final Class<? extends Service> getServiceClass() {
        return this.serviceClass;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final String getVersionString() {
        StringBuilder sb = new StringBuilder();
        if (this.major != -1) {
            sb.append(this.major);
        }
        if (this.minor != -1) {
            sb.append('.');
            sb.append(this.minor);
        }
        return sb.toString();
    }

    public final boolean isSameService(Version v) {
        return v != null && this.serviceClass.equals(v.serviceClass);
    }

    public final boolean isCompatible(Version v) {
        if (this.isSameService(v) && (this.major == v.major || this.major == -1 || v.major == -1)) {
            return true;
        }
        for (Version impliedVersion : this.impliedVersions) {
            if (impliedVersion == this || !impliedVersion.isCompatible(v)) continue;
            return true;
        }
        return false;
    }

    private int raiseAny(int versionNumber) {
        return versionNumber != -1 ? versionNumber : Integer.MAX_VALUE;
    }

    public final boolean isAfter(Version v) {
        Version serviceVersion = Version.findServiceVersion(this.impliedVersions, v.getServiceClass());
        Preconditions.checkArgument(serviceVersion != null, "No relationship between versions");
        int serviceMajor = this.raiseAny(serviceVersion.major);
        int vMajor = this.raiseAny(v.major);
        if (serviceMajor != vMajor) {
            return serviceMajor > vMajor;
        }
        return this.raiseAny(serviceVersion.minor) > this.raiseAny(v.minor);
    }

    public final boolean isBefore(Version v) {
        Version serviceVersion = Version.findServiceVersion(this.impliedVersions, v.getServiceClass());
        Preconditions.checkArgument(serviceVersion != null, "No relationship between versions");
        if (serviceVersion.major != v.major) {
            return serviceVersion.major < v.major;
        }
        return serviceVersion.minor < v.minor;
    }

    public List<Version> getImpliedVersions() {
        return this.impliedVersions;
    }

    private void computeImpliedVersions(Version ... versionList) {
        this.impliedVersions.add(this);
        for (Version v : versionList) {
            this.addImpliedVersion(v);
        }
    }

    private void addImpliedVersion(Version v) {
        if (!this.impliedVersions.contains(v)) {
            this.impliedVersions.add(v);
            for (Version impliedVersion : v.getImpliedVersions()) {
                this.addImpliedVersion(impliedVersion);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version v = (Version)o;
        return this.isSameService(v) && this.major == v.major && this.minor == v.minor;
    }

    public int hashCode() {
        int result = this.serviceClass.hashCode();
        result = 37 * result + this.major;
        result = 37 * result + this.minor;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serviceClass.getName());
        sb.append(':');
        sb.append(this.getVersionString());
        return sb.toString();
    }
}

