/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.photos.AtomData;
import com.google.gdata.data.photos.CommentAuthor;
import com.google.gdata.data.photos.CommentData;
import com.google.gdata.data.photos.GphotoAlbumId;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.data.photos.GphotoPhotoId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/photos/2007#comment")
public class CommentEntry
extends GphotoEntry<CommentEntry>
implements AtomData,
CommentData {
    public static final String KIND = "http://schemas.google.com/photos/2007#comment";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/photos/2007#comment");

    public CommentEntry() {
        this.getCategories().add(CATEGORY);
    }

    public CommentEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(CommentEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(CommentEntry.class, GphotoAlbumId.class);
        extProfile.declare(CommentEntry.class, CommentAuthor.getDefaultDescription(false, true));
        new CommentAuthor().declareExtensions(extProfile);
        extProfile.declare(CommentEntry.class, GphotoPhotoId.class);
    }

    public GphotoAlbumId getAlbumIdExt() {
        return this.getExtension(GphotoAlbumId.class);
    }

    public void setAlbumIdExt(GphotoAlbumId albumIdExt) {
        if (albumIdExt == null) {
            this.removeExtension(GphotoAlbumId.class);
        } else {
            this.setExtension(albumIdExt);
        }
    }

    public boolean hasAlbumIdExt() {
        return this.hasExtension(GphotoAlbumId.class);
    }

    public GphotoPhotoId getPhotoIdExt() {
        return this.getExtension(GphotoPhotoId.class);
    }

    public void setPhotoIdExt(GphotoPhotoId photoIdExt) {
        if (photoIdExt == null) {
            this.removeExtension(GphotoPhotoId.class);
        } else {
            this.setExtension(photoIdExt);
        }
    }

    public boolean hasPhotoIdExt() {
        return this.hasExtension(GphotoPhotoId.class);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{CommentEntry " + super.toString() + "}";
    }

    @Override
    public String getAlbumId() {
        GphotoAlbumId ext = this.getAlbumIdExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public String getPhotoId() {
        GphotoPhotoId ext = this.getPhotoIdExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setAlbumId(Long albumId) {
        GphotoAlbumId ext = null;
        if (albumId != null) {
            ext = GphotoAlbumId.from(albumId);
        }
        this.setAlbumIdExt(ext);
    }

    @Override
    public void setAlbumId(String albumId) {
        GphotoAlbumId ext = null;
        if (albumId != null) {
            ext = new GphotoAlbumId(albumId);
        }
        this.setAlbumIdExt(ext);
    }

    @Override
    public void setPhotoId(Long photoId) {
        GphotoPhotoId ext = null;
        if (photoId != null) {
            ext = GphotoPhotoId.from(photoId);
        }
        this.setPhotoIdExt(ext);
    }

    @Override
    public void setPhotoId(String photoId) {
        GphotoPhotoId ext = null;
        if (photoId != null) {
            ext = new GphotoPhotoId(photoId);
        }
        this.setPhotoIdExt(ext);
    }
}

