/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media.mediarss;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.media.mediarss.AbstractElementWithContent;
import com.google.gdata.util.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExtensionDescription.Default(nsAlias="media", nsUri="http://search.yahoo.com/mrss/", localName="restriction", isRepeatable=true)
public class MediaRestriction
extends AbstractElementWithContent {
    private Type type;
    private Relationship relationship;

    public Relationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setContentAsCountryCodeList(List<String> codes) {
        if (codes.isEmpty()) {
            this.setContent(null);
            return;
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String code : codes) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(' ');
            }
            builder.append(code);
        }
        this.setContent(builder.toString());
    }

    public List<String> getContentAsCountryCodeList() {
        if (this.getContent() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> countries = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(this.getContent(), " ");
        while (tok.hasMoreTokens()) {
            countries.add(tok.nextToken().trim());
        }
        return countries;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        super.putAttributes(generator);
        generator.put("type", this.type, new AttributeHelper.LowerCaseEnumToAttributeValue());
        generator.put("relationship", this.relationship, new AttributeHelper.LowerCaseEnumToAttributeValue());
    }

    @Override
    protected void consumeAttributes(AttributeHelper attrsHelper) throws ParseException {
        super.consumeAttributes(attrsHelper);
        this.type = attrsHelper.consumeEnum("type", false, Type.class);
        this.relationship = attrsHelper.consumeEnum("relationship", false, Relationship.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Relationship {
        ALLOW,
        DENY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        COUNTRY,
        URI;

    }
}

