/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.maps;

import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.maps.DataConstants;
import com.google.gdata.data.maps.FeatureEntry;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/maps/2008#feature")
public class FeatureFeed
extends BaseFeed<FeatureFeed, FeatureEntry> {
    private boolean isKmlDefault = true;

    public FeatureFeed() {
        super(FeatureEntry.class);
        this.getCategories().add(FeatureEntry.CATEGORY);
    }

    public FeatureFeed(BaseFeed<?, ?> sourceFeed) {
        super(FeatureEntry.class, sourceFeed);
    }

    public Link getAtomFeedLink() {
        return this.getLink("http://schemas.google.com/g/2005#feed", ILink.Type.ATOM);
    }

    public String toString() {
        return "{FeatureFeed " + super.toString() + "}";
    }

    public void setKmlDefault(boolean isDefault) {
        this.isKmlDefault = isDefault;
    }

    @Override
    public void generateAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        if (this.isKmlDefault) {
            w.setDefaultNamespace(DataConstants.KML_NAMESPACE);
        }
        super.generateAtom(w, extProfile);
    }
}

