/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.codesearch;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.codesearch.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Package
extends ExtensionPoint
implements Extension {
    public static final String EXTENSION_PACKAGE = "package";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_URI = "uri";
    protected String name;
    protected String uri;

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(Package.class);
        desc.setNamespace(Namespaces.gCSNs);
        desc.setLocalName(EXTENSION_PACKAGE);
        desc.setRepeatable(false);
        return desc;
    }

    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attributes = new ArrayList<XmlWriter.Attribute>();
        if (this.name != null) {
            attributes.add(new XmlWriter.Attribute(ATTRIBUTE_NAME, this.name));
        }
        if (this.uri != null) {
            attributes.add(new XmlWriter.Attribute(ATTRIBUTE_URI, this.uri));
        }
        w.simpleElement(Namespaces.gCSNs, EXTENSION_PACKAGE, attributes, "");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    private class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile) {
            super(extProfile, Package.class);
        }

        public void processAttribute(String namespace, String localName, String value) {
            if ("".equals(namespace)) {
                if (Package.ATTRIBUTE_NAME.equals(localName)) {
                    Package.this.name = value;
                }
                if (Package.ATTRIBUTE_URI.equals(localName)) {
                    Package.this.uri = value;
                }
            }
        }

        public void processEndElement() throws ParseException {
            if (Package.this.name == null) {
                throw new ParseException("http://schemas.google.com/codesearch/2006package/@name is required.");
            }
            if (Package.this.uri == null) {
                throw new ParseException("http://schemas.google.com/codesearch/2006package/@uri is required.");
            }
        }
    }
}

