/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.calendar;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gCal", nsUri="http://schemas.google.com/gCal/2005", localName="timesCleaned")
public class TimesCleanedProperty
extends ExtensionPoint {
    static final String XML_NAME = "timesCleaned";
    private static final String VALUE = "value";
    private Integer value = null;

    public TimesCleanedProperty() {
    }

    public TimesCleanedProperty(Integer value) {
        this.setValue(value);
        this.setImmutable(true);
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
        if (this.value == null) {
            TimesCleanedProperty.throwExceptionForMissingAttribute(VALUE);
        } else if (this.value < 0) {
            throw new IllegalStateException("value attribute must be non-negative: " + this.value);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(TimesCleanedProperty.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(VALUE, this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.value = helper.consumeInteger(VALUE, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        TimesCleanedProperty other = (TimesCleanedProperty)obj;
        return TimesCleanedProperty.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{TimesCleanedProperty value=" + this.value + "}";
    }
}

