/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="dxp", nsUri="http://schemas.google.com/analytics/2009", localName="property")
public class Property
extends ExtensionPoint {
    static final String XML_NAME = "property";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private String name = null;
    private String value = null;

    public Property() {
    }

    public Property(String name, String value) {
        this.setName(name);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwExceptionIfImmutable();
        this.name = name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
        if (this.name == null) {
            Property.throwExceptionForMissingAttribute(NAME);
        }
        if (this.value == null) {
            Property.throwExceptionForMissingAttribute(VALUE);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Property.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(NAME, this.name);
        generator.put(VALUE, this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.name = helper.consume(NAME, true);
        this.value = helper.consume(VALUE, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Property other = (Property)obj;
        return Property.eq(this.name, other.name) && Property.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.name != null) {
            result = 37 * result + this.name.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Property name=" + this.name + " value=" + this.value + "}";
    }
}

