/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionManifest;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ExtensionVisitor;
import com.google.gdata.data.ValidatingExtension;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.base.Pair;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionPoint
extends AbstractExtension {
    private Map<Class<? extends Extension>, Extension> nonRepeatingExtensionMap = new LinkedHashMap<Class<? extends Extension>, Extension>();
    private Map<Class<? extends Extension>, List<Extension>> repeatingExtensionMap = new LinkedHashMap<Class<? extends Extension>, List<Extension>>();
    protected XmlBlob xmlBlob = new XmlBlob();
    private ExtensionManifest manifest;

    public ExtensionPoint() {
    }

    protected ExtensionPoint(ExtensionPoint sourcePoint) {
        this.nonRepeatingExtensionMap = sourcePoint.nonRepeatingExtensionMap;
        this.repeatingExtensionMap = sourcePoint.repeatingExtensionMap;
        this.xmlBlob = sourcePoint.xmlBlob;
        this.manifest = sourcePoint.manifest;
    }

    public void declareExtensions(ExtensionProfile extProfile) {
    }

    public final <T extends Extension> boolean hasExtension(Class<T> extensionClass) {
        return this.nonRepeatingExtensionMap.containsKey(extensionClass);
    }

    public final <T extends Extension> boolean hasRepeatingExtension(Class<T> extensionClass) {
        List<Extension> ret = this.repeatingExtensionMap.get(extensionClass);
        return ret != null && !ret.isEmpty();
    }

    public <T extends Extension> T getExtension(Class<T> extensionClass) {
        return (T)this.nonRepeatingExtensionMap.get(extensionClass);
    }

    public Collection<Extension> getExtensions() {
        return Collections.unmodifiableCollection(this.nonRepeatingExtensionMap.values());
    }

    public <T extends Extension> List<T> getRepeatingExtension(Class<T> extensionClass) {
        List<Extension> ret = this.repeatingExtensionMap.get(extensionClass);
        if (ret == null) {
            ret = new ArrayList<Extension>();
            this.repeatingExtensionMap.put(extensionClass, ret);
        }
        return ret;
    }

    public Collection<List<Extension>> getRepeatingExtensions() {
        return Collections.unmodifiableCollection(this.repeatingExtensionMap.values());
    }

    protected boolean addExtension(Extension ext, Class<? extends Extension> extClass) {
        if (this.nonRepeatingExtensionMap.containsKey(extClass)) {
            return false;
        }
        this.nonRepeatingExtensionMap.put(extClass, ext);
        return true;
    }

    public void addExtension(Extension ext) {
        this.addExtension(ext, ext.getClass());
    }

    public void setExtension(Extension ext) {
        this.nonRepeatingExtensionMap.remove(ext.getClass());
        this.addExtension(ext, ext.getClass());
    }

    protected void addRepeatingExtension(Extension ext, Class<? extends Extension> extClass) {
        List<Extension> extList = this.repeatingExtensionMap.get(extClass);
        if (extList == null) {
            extList = new ArrayList<Extension>();
        }
        extList.add(ext);
        this.repeatingExtensionMap.put(extClass, extList);
    }

    public void addRepeatingExtension(Extension ext) {
        this.addRepeatingExtension(ext, ext.getClass());
    }

    public void removeExtension(Extension ext) {
        this.nonRepeatingExtensionMap.remove(ext.getClass());
    }

    public void removeExtension(Class<? extends Extension> extensionClass) {
        this.nonRepeatingExtensionMap.remove(extensionClass);
    }

    public void removeRepeatingExtension(Extension ext) {
        List<Extension> extList = this.repeatingExtensionMap.get(ext.getClass());
        if (extList == null) {
            return;
        }
        extList.remove(ext);
    }

    protected void visitChild(ExtensionVisitor ev, Extension child) throws ExtensionVisitor.StoppedException {
        if (child instanceof ExtensionPoint) {
            ((ExtensionPoint)child).visit(ev, this);
        } else {
            ev.visit(this, child);
        }
    }

    protected void visitChildren(ExtensionVisitor ev) throws ExtensionVisitor.StoppedException {
        for (Extension extension : this.nonRepeatingExtensionMap.values()) {
            this.visitChild(ev, extension);
        }
        for (List list : this.repeatingExtensionMap.values()) {
            for (Extension ext : list) {
                this.visitChild(ev, ext);
            }
        }
    }

    public void visit(ExtensionVisitor ev, ExtensionPoint parent) throws ExtensionVisitor.StoppedException {
        boolean visitChildren = ev.visit(parent, this);
        if (visitChildren) {
            this.visitChildren(ev);
        }
        ev.visitComplete(this);
    }

    public XmlBlob getXmlBlob() {
        return this.xmlBlob;
    }

    public void setXmlBlob(XmlBlob xmlBlob) {
        this.xmlBlob = xmlBlob;
    }

    public XmlBlob generateCumulativeXmlBlob(ExtensionProfile extProfile) throws IOException {
        XmlBlob cumulative = new XmlBlob();
        List<XmlNamespace> namespaces = cumulative.getNamespaces();
        StringWriter w = new StringWriter();
        XmlWriter xw = new XmlWriter(w);
        if (this.xmlBlob != null) {
            cumulative.setLang(this.xmlBlob.getLang());
            cumulative.setBase(this.xmlBlob.getBase());
            namespaces.addAll(this.xmlBlob.getNamespaces());
            w.write(this.xmlBlob.getBlob());
        }
        if (this.manifest != null) {
            for (XmlNamespace xmlNamespace : this.manifest.getNamespaceDecls()) {
                XmlNamespace newNs = new XmlNamespace(xmlNamespace.getAlias(), xmlNamespace.getUri());
                if (namespaces.contains(newNs)) continue;
                namespaces.add(newNs);
            }
        }
        for (Extension extension : this.nonRepeatingExtensionMap.values()) {
            extension.generate(xw, extProfile);
        }
        for (List list : this.repeatingExtensionMap.values()) {
            xw.startRepeatingElement();
            for (Extension ext : list) {
                ext.generate(xw, extProfile);
            }
            xw.endRepeatingElement();
        }
        cumulative.setBlob(w.toString());
        return cumulative;
    }

    public void parseCumulativeXmlBlob(XmlBlob blob, ExtensionProfile extProfile, Class<? extends ExtensionPoint> extendedClass) throws IOException, ParseException {
        this.xmlBlob = new XmlBlob();
        this.nonRepeatingExtensionMap.clear();
        this.repeatingExtensionMap.clear();
        StringWriter sw = new StringWriter();
        XmlWriter w = new XmlWriter(sw);
        XmlBlob.startElement(w, null, "CUMULATIVE_BLOB", blob, null, null);
        XmlBlob.endElement(w, null, "CUMULATIVE_BLOB", blob);
        StringReader sr = new StringReader(sw.toString());
        XmlParser parser = new XmlParser();
        parser.parse(sr, (XmlParser.ElementHandler)new CumulativeBlobHandler(extProfile, extendedClass), "", "CUMULATIVE_BLOB");
    }

    protected ExtensionManifest getManifest(ExtensionProfile extProfile, Class<? extends ExtensionPoint> extendedClass) {
        if (this.manifest == null) {
            this.manifest = extProfile.getManifest(extendedClass);
        }
        return this.manifest;
    }

    @Override
    protected void generate(XmlWriter w, ExtensionProfile p, XmlNamespace namespace, String localName, List<XmlWriter.Attribute> attrs, AttributeGenerator generator) throws IOException {
        if (generator.getContent() != null) {
            throw new IllegalStateException("No content allowed on an extension point");
        }
        try {
            ExtensionManifest profManifest = p.getManifest(this.getClass());
            if (profManifest != null) {
                this.checkRequiredExtensions(profManifest);
            }
        }
        catch (ParseException e) {
            throw new IllegalStateException(e.getMessage());
        }
        this.generateStartElement(w, namespace, localName, attrs, null);
        this.generateExtensions(w, p);
        w.endElement(namespace, localName);
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) throws ParseException {
        return new ExtensionHandler(p, this.getClass(), attrs);
    }

    protected void generateStartElement(XmlWriter w, XmlNamespace namespace, String elementName, Collection<XmlWriter.Attribute> additionalAttrs, Collection<XmlNamespace> additionalNs) throws IOException {
        XmlBlob.startElement(w, namespace, elementName, this.xmlBlob, additionalAttrs, additionalNs);
    }

    protected void generateExtensions(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        for (Extension extension : this.nonRepeatingExtensionMap.values()) {
            extension.generate(w, extProfile);
        }
        for (List list : this.repeatingExtensionMap.values()) {
            w.startRepeatingElement();
            for (Extension ext : list) {
                ext.generate(w, extProfile);
            }
            w.endRepeatingElement();
        }
        if (this.xmlBlob != null) {
            w.innerXml(this.xmlBlob.getBlob());
        }
    }

    protected void initializeArbitraryXml(ExtensionProfile profile, Class<? extends ExtensionPoint> extPoint, XmlParser.ElementHandler handler) {
        boolean arbitraryXml = profile.allowsArbitraryXml();
        boolean mixedContent = false;
        ExtensionManifest profManifest = this.getManifest(profile, extPoint);
        if (profManifest != null && profManifest.arbitraryXml) {
            arbitraryXml = profManifest.arbitraryXml;
            mixedContent = profManifest.mixedContent;
        }
        if (arbitraryXml) {
            handler.initializeXmlBlob(this.xmlBlob, mixedContent, false);
        }
    }

    protected ExtensionDescription getExtensionDescription(ExtensionProfile extProfile, Class<? extends ExtensionPoint> extPoint, String namespaceUri, String localName) {
        ExtensionManifest profManifest = this.getManifest(extProfile, extPoint);
        if (profManifest == null) {
            return null;
        }
        ExtensionDescription extDescription = profManifest.supportedExtensions.get(Pair.of(namespaceUri, localName));
        if (extDescription == null) {
            extDescription = profManifest.supportedExtensions.get(Pair.of(namespaceUri, "*"));
        }
        return extDescription;
    }

    protected static <T extends Extension> T createExtensionInstance(Class<T> extClass) throws ParseException {
        try {
            return (T)((Extension)extClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new ParseException(CoreErrorDomain.ERR.cantCreateExtension, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ParseException(CoreErrorDomain.ERR.cantCreateExtension, (Throwable)e);
        }
    }

    protected XmlParser.ElementHandler getExtensionHandler(ExtensionProfile extProfile, Class<? extends ExtensionPoint> extPoint, String namespaceUri, String localName, Attributes attrs) throws ParseException, IOException {
        ExtensionDescription extDescription = this.getExtensionDescription(extProfile, extPoint, namespaceUri, localName);
        if (extDescription == null) {
            return null;
        }
        Class<? extends Extension> extClass = extDescription.getExtensionClass();
        if (extClass == null) {
            return null;
        }
        Extension extension = null;
        if (extDescription.isAggregate()) {
            extension = this.getExtension(extClass);
        }
        boolean needsAdd = true;
        if (extension == null) {
            extension = ExtensionPoint.createExtensionInstance(extClass);
        } else {
            needsAdd = false;
        }
        XmlParser.ElementHandler handler = extension.getHandler(extProfile, namespaceUri, localName, attrs);
        if (needsAdd) {
            if (extDescription.isRepeatable()) {
                this.addRepeatingExtension(extension, extClass);
            } else {
                boolean added = this.addExtension(extension, extClass);
                if (!added) {
                    ParseException pe = new ParseException(CoreErrorDomain.ERR.duplicateExtension);
                    pe.setInternalReason("Duplicate extension element " + namespaceUri + ":" + localName);
                    throw pe;
                }
            }
        }
        return handler;
    }

    protected void checkRequiredExtensions(ExtensionManifest profManifest) throws ParseException {
        for (ExtensionDescription extDescription : profManifest.supportedExtensions.values()) {
            if (!extDescription.isRequired()) continue;
            Class<? extends Extension> extClass = extDescription.getExtensionClass();
            boolean found = extDescription.isRepeatable() ? this.repeatingExtensionMap.containsKey(extClass) : this.nonRepeatingExtensionMap.containsKey(extClass);
            if (found) continue;
            ParseException pe = new ParseException(CoreErrorDomain.ERR.missingExtensionElement);
            pe.setInternalReason("Required extension element " + extDescription.getNamespace().getUri() + ":" + extDescription.getLocalName() + " not found.");
            throw pe;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExtensionHandler
    extends AbstractExtension.AttributesHandler {
        protected ExtensionProfile extProfile;
        protected Class<? extends ExtensionPoint> extendedClass;
        protected boolean hasExtensions;
        protected ExtensionManifest extManifest;

        public ExtensionHandler(ExtensionProfile profile, Class<? extends ExtensionPoint> extendedClass) {
            this(profile, extendedClass, null);
        }

        public ExtensionHandler(ExtensionProfile profile, Class<? extends ExtensionPoint> extendedClass, Attributes attrs) {
            super(attrs);
            this.extProfile = profile;
            this.extendedClass = extendedClass;
            this.extManifest = profile.getManifest(extendedClass);
            if (this.extManifest != null) {
                this.hasExtensions = true;
            }
            ExtensionPoint.this.initializeArbitraryXml(this.extProfile, extendedClass, this);
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            XmlParser.ElementHandler extensionHandler;
            if (this.hasExtensions && (extensionHandler = ExtensionPoint.this.getExtensionHandler(this.extProfile, this.extendedClass, namespace, localName, attrs)) != null) {
                return extensionHandler;
            }
            return super.getChildHandler(namespace, localName, attrs);
        }

        @Override
        public void processEndElement() throws ParseException {
            super.processEndElement();
            if (this.extManifest != null) {
                ExtensionPoint.this.checkRequiredExtensions(this.extManifest);
            }
            for (Extension extension : ExtensionPoint.this.nonRepeatingExtensionMap.values()) {
                if (!(extension instanceof ValidatingExtension)) continue;
                ((ValidatingExtension)extension).validate(ExtensionPoint.this);
            }
            for (List extList : ExtensionPoint.this.repeatingExtensionMap.values()) {
                for (Extension extension : extList) {
                    if (!(extension instanceof ValidatingExtension)) continue;
                    ((ValidatingExtension)extension).validate(ExtensionPoint.this);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CumulativeBlobHandler
    extends XmlParser.ElementHandler {
        private final ExtensionProfile extProfile;
        private final Class<? extends ExtensionPoint> extendedClass;

        public CumulativeBlobHandler(ExtensionProfile extProfile, Class<? extends ExtensionPoint> extendedClass) {
            this.extProfile = extProfile;
            this.extendedClass = extendedClass;
            ExtensionPoint.this.initializeArbitraryXml(extProfile, extendedClass, this);
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            XmlParser.ElementHandler extensionHandler = ExtensionPoint.this.getExtensionHandler(this.extProfile, this.extendedClass, namespace, localName, attrs);
            if (extensionHandler != null) {
                return extensionHandler;
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

