/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.spreadsheet;

import com.google.gdata.client.Query;
import java.net.URL;

public class CellQuery
extends Query {
    public static final String MINIMUM_ROW = "min-row";
    public static final String MAXIMUM_ROW = "max-row";
    public static final String MINIMUM_COL = "min-col";
    public static final String MAXIMUM_COL = "max-col";
    public static final String RANGE = "range";
    public static final String RETURN_EMPTY = "return-empty";

    public CellQuery(URL feedUrl) {
        super(feedUrl);
    }

    public void setMinimumRow(Integer value) {
        if (value != null && value > 0) {
            this.setIntegerCustomParameter(MINIMUM_ROW, value);
        } else {
            this.setIntegerCustomParameter(MINIMUM_ROW, null);
        }
    }

    public void setMaximumRow(Integer value) {
        if (value != null && value > 0) {
            this.setIntegerCustomParameter(MAXIMUM_ROW, value);
        } else {
            this.setIntegerCustomParameter(MAXIMUM_ROW, null);
        }
    }

    public void setMinimumCol(Integer value) {
        if (value != null && value > 0) {
            this.setIntegerCustomParameter(MINIMUM_COL, value);
        } else {
            this.setIntegerCustomParameter(MINIMUM_COL, null);
        }
    }

    public void setMaximumCol(Integer value) {
        if (value != null && value > 0) {
            this.setIntegerCustomParameter(MAXIMUM_COL, value);
        } else {
            this.setIntegerCustomParameter(MAXIMUM_COL, null);
        }
    }

    public void setRange(String value) {
        this.setStringCustomParameter(RANGE, value);
    }

    public void setReturnEmpty(boolean value) {
        this.setStringCustomParameter(RETURN_EMPTY, "" + value);
    }

    public Integer getMinimumRow() {
        return this.getIntegerCustomParameter(MINIMUM_ROW);
    }

    public Integer getMaximumRow() {
        return this.getIntegerCustomParameter(MAXIMUM_ROW);
    }

    public Integer getMinimumCol() {
        return this.getIntegerCustomParameter(MINIMUM_COL);
    }

    public Integer getMaximumCol() {
        return this.getIntegerCustomParameter(MAXIMUM_COL);
    }

    public String getRange() {
        return this.getStringCustomParameter(RANGE);
    }

    public boolean getReturnEmpty() {
        return Boolean.parseBoolean(this.getStringCustomParameter(RETURN_EMPTY));
    }
}

