/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.analytics;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.data.analytics.AccountFeed;
import com.google.gdata.data.analytics.DataFeed;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;

public class AnalyticsService
extends GoogleService {
    public static final String ANALYTICS_SERVICE = "analytics";
    public static final String ANALYTICS_SERVICE_VERSION = "GAnalytics-Java/" + AnalyticsService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(AnalyticsService.class, Versions.V2);

    public AnalyticsService(String applicationName) {
        super(ANALYTICS_SERVICE, applicationName);
        this.declareExtensions();
    }

    public AnalyticsService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.declareExtensions();
    }

    public AnalyticsService(String applicationName, String protocol, String domainName) {
        super(ANALYTICS_SERVICE, applicationName, protocol, domainName);
        this.declareExtensions();
    }

    public String getServiceVersion() {
        return ANALYTICS_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(AnalyticsService.class);
    }

    private void declareExtensions() {
        new AccountFeed().declareExtensions(this.extProfile);
        new DataFeed().declareExtensions(this.extProfile);
    }

    public static final class Versions {
        public static final Version V1 = new Version(AnalyticsService.class, "1.0", Service.Versions.V1);
        public static final Version V2 = new Version(AnalyticsService.class, "2.0", Service.Versions.V2);

        private Versions() {
        }
    }
}

