/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import java.util.HashMap;
import java.util.Map;

public class GoogleBaseAttributeType {
    private static final Map<String, GoogleBaseAttributeType> KNOWN_TYPES = new HashMap<String, GoogleBaseAttributeType>();
    public static final GoogleBaseAttributeType TEXT = GoogleBaseAttributeType.createAndRegister("text");
    public static final GoogleBaseAttributeType NUMBER = GoogleBaseAttributeType.createAndRegister("number");
    public static final GoogleBaseAttributeType INT = GoogleBaseAttributeType.createAndRegister(NUMBER, "int");
    public static final GoogleBaseAttributeType FLOAT = GoogleBaseAttributeType.createAndRegister(NUMBER, "float");
    public static final GoogleBaseAttributeType NUMBER_UNIT = GoogleBaseAttributeType.createAndRegister("numberUnit");
    public static final GoogleBaseAttributeType INT_UNIT = GoogleBaseAttributeType.createAndRegister(NUMBER_UNIT, "intUnit");
    public static final GoogleBaseAttributeType FLOAT_UNIT = GoogleBaseAttributeType.createAndRegister(NUMBER_UNIT, "floatUnit");
    public static final GoogleBaseAttributeType DATE_TIME_RANGE = GoogleBaseAttributeType.createAndRegister("dateTimeRange");
    public static final GoogleBaseAttributeType DATE = GoogleBaseAttributeType.createAndRegister(DATE_TIME_RANGE, "date");
    public static final GoogleBaseAttributeType DATE_TIME = GoogleBaseAttributeType.createAndRegister(DATE, "dateTime");
    public static final GoogleBaseAttributeType URL = GoogleBaseAttributeType.createAndRegister("url");
    public static final GoogleBaseAttributeType BOOLEAN = GoogleBaseAttributeType.createAndRegister("boolean");
    public static final GoogleBaseAttributeType GROUP = GoogleBaseAttributeType.createAndRegister("group");
    public static final GoogleBaseAttributeType SHIPPING = GoogleBaseAttributeType.createAndRegister(GROUP, "shipping");
    public static final GoogleBaseAttributeType TAX = GoogleBaseAttributeType.createAndRegister(GROUP, "tax");
    public static final GoogleBaseAttributeType LOCATION = GoogleBaseAttributeType.createAndRegister("location");
    public static final GoogleBaseAttributeType REFERENCE = GoogleBaseAttributeType.createAndRegister("reference");
    private final String name;
    private final GoogleBaseAttributeType supertype;

    private static GoogleBaseAttributeType createAndRegister(String name) {
        return GoogleBaseAttributeType.createAndRegister(null, name);
    }

    private static GoogleBaseAttributeType createAndRegister(GoogleBaseAttributeType supertype, String name) {
        GoogleBaseAttributeType type = new GoogleBaseAttributeType(supertype, name);
        KNOWN_TYPES.put(type.getName(), type);
        return type;
    }

    private GoogleBaseAttributeType(GoogleBaseAttributeType supertype, String name) {
        this.supertype = supertype;
        this.name = name.intern();
    }

    public GoogleBaseAttributeType getSupertype() {
        return this.supertype;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GoogleBaseAttributeType)) {
            return false;
        }
        GoogleBaseAttributeType other = (GoogleBaseAttributeType)o;
        return this.name == other.name;
    }

    public int hashCode() {
        return 11 + this.name.hashCode();
    }

    public static GoogleBaseAttributeType getInstance(String typeName) {
        if (typeName == null) {
            return null;
        }
        GoogleBaseAttributeType commonType = KNOWN_TYPES.get(typeName);
        if (commonType != null) {
            return commonType;
        }
        return new GoogleBaseAttributeType(null, typeName);
    }

    public boolean isSupertypeOf(GoogleBaseAttributeType subtype) {
        if (this.equals(subtype)) {
            return true;
        }
        GoogleBaseAttributeType otherSupertype = subtype.getSupertype();
        if (otherSupertype == null) {
            return false;
        }
        return this.isSupertypeOf(otherSupertype);
    }
}

