/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.errorprone.annotations.FormatMethod;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DaggerElement;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.validation.AutoValue_ModelBindingGraphConverter_BindingGraphImpl;
import dagger.internal.codegen.validation.AutoValue_ModelBindingGraphConverter_BindingNodeImpl;
import dagger.internal.codegen.validation.AutoValue_ModelBindingGraphConverter_ChildFactoryMethodEdgeImpl;
import dagger.internal.codegen.validation.AutoValue_ModelBindingGraphConverter_ComponentNodeImpl;
import dagger.internal.codegen.validation.AutoValue_ModelBindingGraphConverter_DependencyEdgeImpl;
import dagger.internal.codegen.validation.AutoValue_ModelBindingGraphConverter_MissingBindingImpl;
import dagger.internal.codegen.validation.AutoValue_ModelBindingGraphConverter_SubcomponentCreatorBindingEdgeImpl;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.model.BindingGraph;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.model.Scope;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public final class ModelBindingGraphConverter {
    private ModelBindingGraphConverter() {
    }

    public static dagger.spi.DiagnosticReporter toModel(DiagnosticReporter reporter) {
        return DiagnosticReporterImpl.create(reporter);
    }

    public static dagger.model.BindingGraph toModel(BindingGraph graph) {
        return BindingGraphImpl.create(graph);
    }

    private static ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge> toModel(Network<BindingGraph.Node, BindingGraph.Edge> internalNetwork) {
        MutableNetwork network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        ImmutableMap fromInternalNodes = (ImmutableMap)internalNetwork.nodes().stream().collect(DaggerStreams.toImmutableMap(node -> node, ModelBindingGraphConverter::toModel));
        for (BindingGraph.Node node2 : fromInternalNodes.values()) {
            network.addNode((Object)node2);
        }
        for (BindingGraph.Edge edge : internalNetwork.edges()) {
            EndpointPair edgePair = internalNetwork.incidentNodes((Object)edge);
            network.addEdge((Object)((BindingGraph.Node)fromInternalNodes.get(edgePair.source())), (Object)((BindingGraph.Node)fromInternalNodes.get(edgePair.target())), (Object)ModelBindingGraphConverter.toModel(edge));
        }
        return ImmutableNetwork.copyOf((Network)network);
    }

    private static BindingGraph.Node toModel(BindingGraph.Node node) {
        if (node instanceof Binding) {
            return BindingNodeImpl.create((Binding)node);
        }
        if (node instanceof BindingGraph.ComponentNode) {
            return ComponentNodeImpl.create((BindingGraph.ComponentNode)node);
        }
        if (node instanceof BindingGraph.MissingBinding) {
            return MissingBindingImpl.create((BindingGraph.MissingBinding)node);
        }
        throw new IllegalStateException("Unhandled node type: " + node.getClass());
    }

    private static BindingGraph.Edge toModel(BindingGraph.Edge edge) {
        if (edge instanceof BindingGraph.DependencyEdge) {
            return DependencyEdgeImpl.create((BindingGraph.DependencyEdge)edge);
        }
        if (edge instanceof BindingGraph.ChildFactoryMethodEdge) {
            return ChildFactoryMethodEdgeImpl.create((BindingGraph.ChildFactoryMethodEdge)edge);
        }
        if (edge instanceof BindingGraph.SubcomponentCreatorBindingEdge) {
            return SubcomponentCreatorBindingEdgeImpl.create((BindingGraph.SubcomponentCreatorBindingEdge)edge);
        }
        throw new IllegalStateException("Unhandled edge type: " + edge.getClass());
    }

    private static Key.MultibindingContributionIdentifier toModel(Key.MultibindingContributionIdentifier identifier) {
        return new Key.MultibindingContributionIdentifier(XElements.getSimpleName((XElement)identifier.bindingMethod().xprocessing()), identifier.contributingModule().xprocessing().getQualifiedName());
    }

    private static dagger.model.Key toModel(Key key) {
        return dagger.model.Key.builder((TypeMirror)key.type().java()).qualifier(key.qualifier().map(DaggerAnnotation::java)).multibindingContributionIdentifier(key.multibindingContributionIdentifier().isPresent() ? Optional.of(ModelBindingGraphConverter.toModel(key.multibindingContributionIdentifier().get())) : Optional.empty()).build();
    }

    private static BindingKind toModel(dagger.internal.codegen.model.BindingKind bindingKind) {
        return BindingKind.valueOf((String)bindingKind.name());
    }

    private static RequestKind toModel(dagger.internal.codegen.model.RequestKind requestKind) {
        return RequestKind.valueOf((String)requestKind.name());
    }

    private static DependencyRequest toModel(dagger.internal.codegen.model.DependencyRequest request) {
        DependencyRequest.Builder builder = DependencyRequest.builder().kind(ModelBindingGraphConverter.toModel(request.kind())).key(ModelBindingGraphConverter.toModel(request.key())).isNullable(request.isNullable());
        request.requestElement().ifPresent(e -> builder.requestElement(e.java()));
        return builder.build();
    }

    private static Scope toModel(dagger.internal.codegen.model.Scope scope) {
        return Scope.scope((AnnotationMirror)scope.scopeAnnotation().java());
    }

    private static dagger.model.ComponentPath toModel(ComponentPath path) {
        return dagger.model.ComponentPath.create((Iterable)((Iterable)path.components().stream().map(DaggerTypeElement::java).collect(DaggerStreams.toImmutableList())));
    }

    private static BindingGraph.ComponentNode toInternal(BindingGraph.ComponentNode componentNode) {
        return ((ComponentNodeImpl)componentNode).delegate();
    }

    private static BindingGraph.MaybeBinding toInternal(BindingGraph.MaybeBinding maybeBinding) {
        if (maybeBinding instanceof MissingBindingImpl) {
            return ((MissingBindingImpl)maybeBinding).delegate();
        }
        if (maybeBinding instanceof BindingNodeImpl) {
            return ((BindingNodeImpl)maybeBinding).delegate();
        }
        throw new IllegalStateException("Unhandled binding type: " + maybeBinding.getClass());
    }

    private static BindingGraph.DependencyEdge toInternal(BindingGraph.DependencyEdge dependencyEdge) {
        return ((DependencyEdgeImpl)dependencyEdge).delegate();
    }

    private static BindingGraph.ChildFactoryMethodEdge toInternal(BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge) {
        return ((ChildFactoryMethodEdgeImpl)childFactoryMethodEdge).delegate();
    }

    private static final class DiagnosticReporterImpl
    implements dagger.spi.DiagnosticReporter {
        private final DiagnosticReporter delegate;

        static DiagnosticReporterImpl create(DiagnosticReporter reporter) {
            return new DiagnosticReporterImpl(reporter);
        }

        DiagnosticReporterImpl(DiagnosticReporter delegate) {
            this.delegate = delegate;
        }

        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String message) {
            this.delegate.reportComponent(diagnosticKind, ModelBindingGraphConverter.toInternal(componentNode), message);
        }

        @FormatMethod
        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.delegate.reportComponent(diagnosticKind, ModelBindingGraphConverter.toInternal(componentNode), messageFormat, firstArg, moreArgs);
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String message) {
            this.delegate.reportBinding(diagnosticKind, ModelBindingGraphConverter.toInternal(binding), message);
        }

        @FormatMethod
        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.delegate.reportBinding(diagnosticKind, ModelBindingGraphConverter.toInternal(binding), messageFormat, firstArg, moreArgs);
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            this.delegate.reportDependency(diagnosticKind, ModelBindingGraphConverter.toInternal(dependencyEdge), message);
        }

        @FormatMethod
        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.delegate.reportDependency(diagnosticKind, ModelBindingGraphConverter.toInternal(dependencyEdge), messageFormat, firstArg, moreArgs);
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String message) {
            this.delegate.reportSubcomponentFactoryMethod(diagnosticKind, ModelBindingGraphConverter.toInternal(childFactoryMethodEdge), message);
        }

        @FormatMethod
        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.delegate.reportSubcomponentFactoryMethod(diagnosticKind, ModelBindingGraphConverter.toInternal(childFactoryMethodEdge), messageFormat, firstArg, moreArgs);
        }
    }

    @AutoValue
    static abstract class BindingGraphImpl
    extends dagger.model.BindingGraph {
        private ImmutableMap<dagger.model.ComponentPath, BindingGraph.ComponentNode> componentNodesByPath;

        BindingGraphImpl() {
        }

        static dagger.model.BindingGraph create(BindingGraph bindingGraph) {
            AutoValue_ModelBindingGraphConverter_BindingGraphImpl bindingGraphImpl = new AutoValue_ModelBindingGraphConverter_BindingGraphImpl((ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge>)ModelBindingGraphConverter.toModel((Network<BindingGraph.Node, BindingGraph.Edge>)bindingGraph.network()), bindingGraph.isFullBindingGraph());
            bindingGraphImpl.componentNodesByPath = (ImmutableMap)bindingGraphImpl.componentNodes().stream().collect(DaggerStreams.toImmutableMap(BindingGraph.ComponentNode::componentPath, node -> node));
            return bindingGraphImpl;
        }

        public Optional<BindingGraph.ComponentNode> componentNode(dagger.model.ComponentPath componentPath) {
            return this.componentNodesByPath.containsKey((Object)componentPath) ? Optional.of((BindingGraph.ComponentNode)this.componentNodesByPath.get((Object)componentPath)) : Optional.empty();
        }

        @Memoized
        public ImmutableSetMultimap<Class<? extends BindingGraph.Node>, ? extends BindingGraph.Node> nodesByClass() {
            return super.nodesByClass();
        }
    }

    @AutoValue
    static abstract class SubcomponentCreatorBindingEdgeImpl
    implements BindingGraph.SubcomponentCreatorBindingEdge {
        SubcomponentCreatorBindingEdgeImpl() {
        }

        static BindingGraph.SubcomponentCreatorBindingEdge create(BindingGraph.SubcomponentCreatorBindingEdge subcomponentCreatorBindingEdge) {
            return new AutoValue_ModelBindingGraphConverter_SubcomponentCreatorBindingEdgeImpl((ImmutableSet<TypeElement>)((ImmutableSet)subcomponentCreatorBindingEdge.declaringModules().stream().map(DaggerTypeElement::java).collect(DaggerStreams.toImmutableSet())), subcomponentCreatorBindingEdge);
        }

        abstract BindingGraph.SubcomponentCreatorBindingEdge delegate();

        public final String toString() {
            return this.delegate().toString();
        }
    }

    @AutoValue
    static abstract class ChildFactoryMethodEdgeImpl
    implements BindingGraph.ChildFactoryMethodEdge {
        ChildFactoryMethodEdgeImpl() {
        }

        static BindingGraph.ChildFactoryMethodEdge create(BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge) {
            return new AutoValue_ModelBindingGraphConverter_ChildFactoryMethodEdgeImpl(childFactoryMethodEdge.factoryMethod().java(), childFactoryMethodEdge);
        }

        abstract BindingGraph.ChildFactoryMethodEdge delegate();

        public final String toString() {
            return this.delegate().toString();
        }
    }

    @AutoValue
    static abstract class DependencyEdgeImpl
    implements BindingGraph.DependencyEdge {
        DependencyEdgeImpl() {
        }

        static BindingGraph.DependencyEdge create(BindingGraph.DependencyEdge dependencyEdge) {
            return new AutoValue_ModelBindingGraphConverter_DependencyEdgeImpl(ModelBindingGraphConverter.toModel(dependencyEdge.dependencyRequest()), dependencyEdge.isEntryPoint(), dependencyEdge);
        }

        abstract BindingGraph.DependencyEdge delegate();

        public final String toString() {
            return this.delegate().toString();
        }
    }

    @AutoValue
    static abstract class MissingBindingImpl
    extends BindingGraph.MissingBinding {
        MissingBindingImpl() {
        }

        static BindingGraph.MissingBinding create(BindingGraph.MissingBinding missingBinding) {
            return new AutoValue_ModelBindingGraphConverter_MissingBindingImpl(ModelBindingGraphConverter.toModel(missingBinding.componentPath()), ModelBindingGraphConverter.toModel(missingBinding.key()), missingBinding);
        }

        abstract BindingGraph.MissingBinding delegate();

        @Memoized
        public abstract int hashCode();

        public abstract boolean equals(Object var1);
    }

    @AutoValue
    static abstract class BindingNodeImpl
    implements dagger.model.Binding {
        BindingNodeImpl() {
        }

        static dagger.model.Binding create(Binding binding) {
            return new AutoValue_ModelBindingGraphConverter_BindingNodeImpl(ModelBindingGraphConverter.toModel(binding.key()), ModelBindingGraphConverter.toModel(binding.componentPath()), (ImmutableSet<DependencyRequest>)((ImmutableSet)binding.dependencies().stream().map(x$0 -> ModelBindingGraphConverter.toModel(x$0)).collect(DaggerStreams.toImmutableSet())), binding.bindingElement().map(DaggerElement::java), binding.contributingModule().map(DaggerTypeElement::java), binding.requiresModuleInstance(), binding.scope().map(x$0 -> ModelBindingGraphConverter.toModel(x$0)), binding.isNullable(), binding.isProduction(), ModelBindingGraphConverter.toModel(binding.kind()), binding);
        }

        abstract Binding delegate();

        public final String toString() {
            return this.delegate().toString();
        }
    }

    @AutoValue
    static abstract class ComponentNodeImpl
    implements BindingGraph.ComponentNode {
        ComponentNodeImpl() {
        }

        static BindingGraph.ComponentNode create(BindingGraph.ComponentNode componentNode) {
            return new AutoValue_ModelBindingGraphConverter_ComponentNodeImpl(ModelBindingGraphConverter.toModel(componentNode.componentPath()), componentNode.isSubcomponent(), componentNode.isRealComponent(), (ImmutableSet<DependencyRequest>)((ImmutableSet)componentNode.entryPoints().stream().map(x$0 -> ModelBindingGraphConverter.toModel(x$0)).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<Scope>)((ImmutableSet)componentNode.scopes().stream().map(x$0 -> ModelBindingGraphConverter.toModel(x$0)).collect(DaggerStreams.toImmutableSet())), componentNode);
        }

        abstract BindingGraph.ComponentNode delegate();

        public final String toString() {
            return this.delegate().toString();
        }
    }
}

