/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ComponentCreatorKind;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ComponentCreatorAnnotation {
    COMPONENT_BUILDER(TypeNames.COMPONENT_BUILDER),
    COMPONENT_FACTORY(TypeNames.COMPONENT_FACTORY),
    SUBCOMPONENT_BUILDER(TypeNames.SUBCOMPONENT_BUILDER),
    SUBCOMPONENT_FACTORY(TypeNames.SUBCOMPONENT_FACTORY),
    PRODUCTION_COMPONENT_BUILDER(TypeNames.PRODUCTION_COMPONENT_BUILDER),
    PRODUCTION_COMPONENT_FACTORY(TypeNames.PRODUCTION_COMPONENT_FACTORY),
    PRODUCTION_SUBCOMPONENT_BUILDER(TypeNames.PRODUCTION_SUBCOMPONENT_BUILDER),
    PRODUCTION_SUBCOMPONENT_FACTORY(TypeNames.PRODUCTION_SUBCOMPONENT_FACTORY);

    private final ClassName annotation;
    private final ComponentCreatorKind creatorKind;
    private final ClassName componentAnnotation;

    private ComponentCreatorAnnotation(ClassName annotation) {
        this.annotation = annotation;
        this.creatorKind = ComponentCreatorKind.valueOf(Ascii.toUpperCase((String)annotation.simpleName()));
        this.componentAnnotation = annotation.enclosingClassName();
    }

    public ClassName annotation() {
        return this.annotation;
    }

    public final ClassName componentAnnotation() {
        return this.componentAnnotation;
    }

    public final boolean isSubcomponentCreatorAnnotation() {
        return this.componentAnnotation().simpleName().endsWith("Subcomponent");
    }

    public final boolean isProductionCreatorAnnotation() {
        return this.componentAnnotation().simpleName().startsWith("Production");
    }

    public ComponentCreatorKind creatorKind() {
        return this.creatorKind;
    }

    public final String toString() {
        return this.annotation().canonicalName();
    }

    public static ImmutableSet<ClassName> allCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<ClassName> rootComponentCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().filter(componentCreatorAnnotation -> !componentCreatorAnnotation.isSubcomponentCreatorAnnotation()).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<ClassName> subcomponentCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().filter(componentCreatorAnnotation -> componentCreatorAnnotation.isSubcomponentCreatorAnnotation()).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<ClassName> productionCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().filter(componentCreatorAnnotation -> componentCreatorAnnotation.isProductionCreatorAnnotation()).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<ClassName> creatorAnnotationsFor(ComponentAnnotation componentAnnotation) {
        return ComponentCreatorAnnotation.stream().filter(creatorAnnotation -> creatorAnnotation.componentAnnotation().simpleName().equals(componentAnnotation.simpleName())).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<ComponentCreatorAnnotation> getCreatorAnnotations(XTypeElement type) {
        return (ImmutableSet)ComponentCreatorAnnotation.stream().filter(cca -> type.hasAnnotation(cca.annotation())).collect(DaggerStreams.toImmutableSet());
    }

    private static Stream<ComponentCreatorAnnotation> stream() {
        return DaggerStreams.valuesOf(ComponentCreatorAnnotation.class);
    }

    private static Collector<ComponentCreatorAnnotation, ?, ImmutableSet<ClassName>> toAnnotationClasses() {
        return Collectors.mapping(ComponentCreatorAnnotation::annotation, DaggerStreams.toImmutableSet());
    }
}

