/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindsInstanceElementValidator;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public final class BindsInstanceMethodValidator
extends BindsInstanceElementValidator<XMethodElement> {
    private final DaggerSuperficialValidation superficialValidation;

    @Inject
    BindsInstanceMethodValidator(InjectionAnnotations injectionAnnotations, DaggerSuperficialValidation superficialValidation) {
        super(injectionAnnotations);
        this.superficialValidation = superficialValidation;
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(XMethodElement method) {
        return new Validator(method);
    }

    private static String didYouMeanBinds(ModuleAnnotation moduleAnnotation) {
        return String.format("@BindsInstance methods should not be included in @%ss. Did you mean @Binds?", moduleAnnotation.simpleName());
    }

    private class Validator
    extends BindingElementValidator.ElementValidator {
        private final XMethodElement method;

        Validator(XMethodElement method) {
            super((BindingElementValidator)BindsInstanceMethodValidator.this, (XElement)method);
            this.method = method;
        }

        @Override
        protected void checkAdditionalProperties() {
            if (!this.method.isAbstract()) {
                this.report.addError("@BindsInstance methods must be abstract");
            }
            if (this.method.getParameters().size() != 1) {
                this.report.addError("@BindsInstance methods should have exactly one parameter for the bound type");
            }
            XTypeElement enclosingTypeElement = XMethodElements.getEnclosingTypeElement((XMethodElement)this.method);
            ModuleAnnotation.moduleAnnotation((XElement)enclosingTypeElement, BindsInstanceMethodValidator.this.superficialValidation).ifPresent(moduleAnnotation -> this.report.addError(BindsInstanceMethodValidator.didYouMeanBinds(moduleAnnotation)));
            ComponentAnnotation.anyComponentAnnotation((XElement)enclosingTypeElement, BindsInstanceMethodValidator.this.superficialValidation).ifPresent(componentAnnotation -> this.report.addError(String.format("@BindsInstance methods should not be included in @%1$ss. Did you mean to put it in a @%1$s.Builder?", componentAnnotation.simpleName())));
        }

        @Override
        protected Optional<XType> bindingElementType() {
            List parameters = this.method.getParameters();
            return parameters.size() == 1 ? Optional.of(((XVariableElement)Iterables.getOnlyElement((Iterable)parameters)).getType()) : Optional.empty();
        }
    }
}

