/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.internal.codegen.binding.;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Scope;
import java.util.Optional;

@CheckReturnValue
@AutoValue
public abstract class ProvisionBinding
extends ContributionBinding {
    private static final ImmutableSet<BindingKind> KINDS_TO_CHECK_FOR_NULL = ImmutableSet.of((Object)BindingKind.PROVISION, (Object)BindingKind.COMPONENT_PROVISION);

    @Override
    @Memoized
    public ImmutableSet<DependencyRequest> explicitDependencies() {
        return ImmutableSet.builder().addAll(this.provisionDependencies()).addAll(this.membersInjectionDependencies()).build();
    }

    public abstract ImmutableSet<DependencyRequest> provisionDependencies();

    @Memoized
    ImmutableSet<DependencyRequest> membersInjectionDependencies() {
        return (ImmutableSet)this.injectionSites().stream().flatMap(i -> i.dependencies().stream()).collect(DaggerStreams.toImmutableSet());
    }

    public abstract ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites();

    @Override
    public BindingType bindingType() {
        return BindingType.PROVISION;
    }

    public abstract Optional<ProvisionBinding> unresolved();

    @Override
    public abstract Optional<Scope> scope();

    public static Builder builder() {
        return new .AutoValue_ProvisionBinding.Builder().provisionDependencies((Iterable<DependencyRequest>)ImmutableSet.of()).injectionSites((ImmutableSortedSet<MembersInjectionBinding.InjectionSite>)ImmutableSortedSet.of());
    }

    public abstract Builder toBuilder();

    public boolean shouldCheckForNull(CompilerOptions compilerOptions) {
        return KINDS_TO_CHECK_FOR_NULL.contains((Object)this.kind()) && !this.contributedPrimitiveType().isPresent() && !this.nullableType().isPresent() && compilerOptions.doCheckForNulls();
    }

    @Override
    @Memoized
    public boolean requiresModuleInstance() {
        return super.requiresModuleInstance();
    }

    @Memoized
    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @AutoValue.Builder
    public static abstract class Builder
    extends ContributionBinding.Builder<ProvisionBinding, Builder> {
        @Override
        @CanIgnoreReturnValue
        public Builder dependencies(Iterable<DependencyRequest> dependencies) {
            return this.provisionDependencies(dependencies);
        }

        abstract Builder provisionDependencies(Iterable<DependencyRequest> var1);

        public abstract Builder injectionSites(ImmutableSortedSet<MembersInjectionBinding.InjectionSite> var1);

        @Override
        @CanIgnoreReturnValue
        public abstract Builder unresolved(ProvisionBinding var1);

        public abstract Builder scope(Optional<Scope> var1);
    }
}

