/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkInstanceSupplier;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.ResolvedBindings;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

abstract class FrameworkInstanceBindingExpression
extends BindingExpression {
    private final ResolvedBindings resolvedBindings;
    private final FrameworkInstanceSupplier frameworkInstanceSupplier;
    private final DaggerTypes types;
    private final DaggerElements elements;

    FrameworkInstanceBindingExpression(ResolvedBindings resolvedBindings, FrameworkInstanceSupplier frameworkInstanceSupplier, DaggerTypes types, DaggerElements elements) {
        this.resolvedBindings = (ResolvedBindings)Preconditions.checkNotNull((Object)resolvedBindings);
        this.frameworkInstanceSupplier = (FrameworkInstanceSupplier)Preconditions.checkNotNull((Object)frameworkInstanceSupplier);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.elements = (DaggerElements)Preconditions.checkNotNull((Object)elements);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        MemberSelect memberSelect = this.frameworkInstanceSupplier.memberSelect();
        TypeMirror contributedType = this.resolvedBindings.contributionBinding().contributedType();
        DeclaredType expressionType = this.frameworkInstanceSupplier.specificType().isPresent() || Accessibility.isTypeAccessibleFrom(contributedType, requestingClass.packageName()) || FrameworkInstanceBindingExpression.isInlinedFactoryCreation(memberSelect) ? this.types.wrapType(contributedType, this.frameworkType().frameworkClass()) : this.rawFrameworkType();
        return Expression.create(expressionType, memberSelect.getExpressionFor(requestingClass));
    }

    protected abstract FrameworkType frameworkType();

    private static boolean isInlinedFactoryCreation(MemberSelect memberSelect) {
        return memberSelect.staticMember();
    }

    private DeclaredType rawFrameworkType() {
        return this.types.getDeclaredType(this.elements.getTypeElement(this.frameworkType().frameworkClass()), new TypeMirror[0]);
    }
}

