/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;

abstract class Formatter<T>
implements Function<T, String> {
    static final String INDENT = "    ";
    static final String DOUBLE_INDENT = "        ";
    private static final int LIST_LIMIT = 10;

    Formatter() {
    }

    public abstract String format(T var1);

    @Deprecated
    public final String apply(T object) {
        return this.format(object);
    }

    public void formatIndentedList(StringBuilder builder, Iterable<? extends T> items, int indentLevel) {
        for (Object item : Iterables.limit(items, (int)10)) {
            String formatted = this.format(item);
            if (formatted.isEmpty()) continue;
            builder.append('\n');
            this.appendIndent(builder, indentLevel);
            builder.append(formatted);
        }
        int numberOfOtherItems = Iterables.size(items) - 10;
        if (numberOfOtherItems > 0) {
            builder.append('\n');
            this.appendIndent(builder, indentLevel);
            builder.append("and ").append(numberOfOtherItems).append(" other");
        }
        if (numberOfOtherItems > 1) {
            builder.append('s');
        }
    }

    private void appendIndent(StringBuilder builder, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            builder.append(INDENT);
        }
    }

    static String formatArgumentInList(int index, int size, CharSequence name) {
        Preconditions.checkElementIndex((int)index, (int)size);
        StringBuilder builder = new StringBuilder();
        if (index > 0) {
            builder.append("\u2026, ");
        }
        builder.append(name);
        if (index < size - 1) {
            builder.append(", \u2026");
        }
        return builder.toString();
    }
}

