/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import dagger.BindsInstance;
import dagger.internal.codegen.AutoValue_ComponentCreatorDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequestFactory;
import dagger.model.DependencyRequest;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

@AutoValue
abstract class ComponentCreatorDescriptor {
    ComponentCreatorDescriptor() {
    }

    abstract TypeElement typeElement();

    abstract ExecutableElement factoryMethod();

    abstract ImmutableSetMultimap<ComponentRequirement, ExecutableElement> requirementElements();

    final ImmutableSet<ComponentRequirement> requirements() {
        return this.requirementElements().keySet();
    }

    final ImmutableSet<ComponentRequirement> moduleAndDependencyRequirements() {
        return this.requirements().stream().filter(requirement -> !requirement.isBoundInstance()).collect(DaggerStreams.toImmutableSet());
    }

    final ImmutableSet<ComponentRequirement> boundInstanceRequirements() {
        return this.requirements().stream().filter(requirement -> requirement.isBoundInstance()).collect(DaggerStreams.toImmutableSet());
    }

    final ExecutableElement elementForRequirement(ComponentRequirement requirement) {
        return (ExecutableElement)Iterables.getOnlyElement((Iterable)this.requirementElements().get((Object)requirement));
    }

    static ComponentCreatorDescriptor create(DeclaredType type, DaggerElements elements, DaggerTypes types, DependencyRequestFactory dependencyRequestFactory) {
        TypeElement typeElement = MoreTypes.asTypeElement(type);
        TypeMirror componentType = typeElement.getEnclosingElement().asType();
        ImmutableSetMultimap.Builder requirementElements = ImmutableSetMultimap.builder();
        ExecutableElement factoryMethod = null;
        for (ExecutableElement method : elements.getUnimplementedMethods(typeElement)) {
            ExecutableType resolvedMethodType = MoreTypes.asExecutable(types.asMemberOf(type, method));
            if (types.isSubtype(componentType, resolvedMethodType.getReturnType())) {
                factoryMethod = method;
                continue;
            }
            VariableElement parameter = (VariableElement)Iterables.getOnlyElement(method.getParameters());
            TypeMirror parameterType = (TypeMirror)Iterables.getOnlyElement(resolvedMethodType.getParameterTypes());
            requirementElements.put((Object)ComponentCreatorDescriptor.requirement(method, parameter, parameterType, dependencyRequestFactory), (Object)method);
        }
        Verify.verify((factoryMethod != null ? 1 : 0) != 0);
        return new AutoValue_ComponentCreatorDescriptor(typeElement, factoryMethod, (ImmutableSetMultimap<ComponentRequirement, ExecutableElement>)requirementElements.build());
    }

    private static ComponentRequirement requirement(ExecutableElement method, VariableElement parameter, TypeMirror type, DependencyRequestFactory dependencyRequestFactory) {
        if (MoreElements.isAnnotationPresent(method, BindsInstance.class)) {
            DependencyRequest request = dependencyRequestFactory.forRequiredResolvedVariable(parameter, type);
            return ComponentRequirement.forBoundInstance(request.key(), request.isNullable(), method.getSimpleName().toString());
        }
        return ConfigurationAnnotations.getModuleAnnotation(MoreTypes.asTypeElement(type)).isPresent() ? ComponentRequirement.forModule(type) : ComponentRequirement.forDependency(type);
    }
}

