/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.model.RequestKind;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

class BindingMethodImplementation {
    private final ComponentImplementation component;
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final BindingExpression bindingExpression;
    private final DaggerTypes types;

    BindingMethodImplementation(ComponentImplementation component, ContributionBinding binding, BindingRequest request, BindingExpression bindingExpression, DaggerTypes types) {
        this.component = component;
        this.binding = binding;
        this.request = request;
        this.bindingExpression = (BindingExpression)Preconditions.checkNotNull((Object)bindingExpression);
        this.types = types;
    }

    final CodeBlock body() {
        return this.implementation((Supplier<CodeBlock>)((Supplier)this.bindingExpression.getDependencyExpression(this.component.name())::codeBlock));
    }

    final CodeBlock bodyForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        return this.implementation((Supplier<CodeBlock>)((Supplier)this.bindingExpression.getDependencyExpressionForComponentMethod(componentMethod, this.component)::codeBlock));
    }

    CodeBlock implementation(Supplier<CodeBlock> simpleBindingExpression) {
        return CodeBlock.of((String)"return $L;", (Object[])new Object[]{simpleBindingExpression.get()});
    }

    final TypeMirror returnType() {
        if (this.request.isRequestKind(RequestKind.INSTANCE) && this.binding.contributedPrimitiveType().isPresent()) {
            return this.binding.contributedPrimitiveType().get();
        }
        if (this.matchingComponentMethod().isPresent()) {
            return this.matchingComponentMethod().get().resolvedReturnType(this.types);
        }
        TypeMirror requestedType = this.request.requestedType(this.binding.contributedType(), this.types);
        return this.component.isAbstract() ? this.types.publiclyAccessibleType(requestedType) : this.types.accessibleType(requestedType, this.component.name());
    }

    private Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod() {
        return this.component.componentDescriptor().firstMatchingComponentMethod(this.request);
    }
}

