/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingDeclarationFormatter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingNode;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ChildFactoryMethodEdgeImpl;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentKind;
import dagger.internal.codegen.ComponentNodeImpl;
import dagger.internal.codegen.ComponentTreeTraverser;
import dagger.internal.codegen.DaggerGraphs;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DependencyEdgeImpl;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SubcomponentBuilderBindingEdgeImpl;
import dagger.model.BindingGraph;
import dagger.model.BindingGraphProxies;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.shaded.auto.common.MoreTypes;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class BindingGraphConverter {
    private final BindingDeclarationFormatter bindingDeclarationFormatter;
    private final CompilerOptions compilerOptions;

    @Inject
    BindingGraphConverter(BindingDeclarationFormatter bindingDeclarationFormatter, CompilerOptions compilerOptions) {
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
        this.compilerOptions = compilerOptions;
    }

    dagger.model.BindingGraph convert(BindingGraph rootGraph) {
        Traverser traverser = new Traverser(rootGraph);
        traverser.traverseComponents();
        DaggerGraphs.unreachableNodes(traverser.network.asGraph(), this.rootComponentNode((Network<BindingGraph.Node, BindingGraph.Edge>)traverser.network)).forEach(arg_0 -> ((MutableNetwork)traverser.network).removeNode(arg_0));
        ComponentKind rootComponentKind = rootGraph.componentDescriptor().kind();
        return BindingGraphProxies.bindingGraph((Network<BindingGraph.Node, BindingGraph.Edge>)traverser.network, rootComponentKind.isForModuleValidation(), !rootComponentKind.isTopLevel());
    }

    private BindingGraph.ComponentNode rootComponentNode(Network<BindingGraph.Node, BindingGraph.Edge> network) {
        return (BindingGraph.ComponentNode)Iterables.find((Iterable)network.nodes(), node -> node instanceof BindingGraph.ComponentNode && node.componentPath().atRoot());
    }

    private final class Traverser
    extends ComponentTreeTraverser {
        private final MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network;
        private BindingGraph.ComponentNode parentComponent;
        private BindingGraph.ComponentNode currentComponent;

        Traverser(BindingGraph graph) {
            super(graph, BindingGraphConverter.this.compilerOptions);
            this.network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        }

        @Override
        protected void visitComponent(BindingGraph graph) {
            BindingGraph.ComponentNode grandparentComponent = this.parentComponent;
            this.parentComponent = this.currentComponent;
            this.currentComponent = ComponentNodeImpl.create(this.componentTreePath().toComponentPath(), graph.componentDescriptor());
            this.network.addNode((Object)this.currentComponent);
            for (ResolvedBindings resolvedBindings : graph.resolvedBindings()) {
                ImmutableSet<TypeElement> declaringModules = this.subcomponentDeclaringModules(resolvedBindings);
                for (BindingNode binding : this.bindingNodes(resolvedBindings)) {
                    this.addBinding(binding);
                    if (!binding.kind().equals((Object)BindingKind.SUBCOMPONENT_BUILDER) || !binding.componentPath().equals(this.currentComponent.componentPath())) continue;
                    this.network.addEdge((Object)binding, (Object)this.subcomponentNode(binding.key().type(), graph), (Object)new SubcomponentBuilderBindingEdgeImpl((Iterable<TypeElement>)declaringModules));
                }
            }
            super.visitComponent(graph);
            this.currentComponent = this.parentComponent;
            this.parentComponent = grandparentComponent;
        }

        @Override
        protected void visitEntryPoint(DependencyRequest entryPoint, BindingGraph graph) {
            this.addDependencyEdges((BindingGraph.Node)this.currentComponent, entryPoint);
            super.visitEntryPoint(entryPoint, graph);
        }

        @Override
        protected void visitSubcomponentFactoryMethod(BindingGraph graph, BindingGraph parent, ExecutableElement factoryMethod) {
            this.network.addEdge((Object)this.parentComponent, (Object)this.currentComponent, (Object)new ChildFactoryMethodEdgeImpl(factoryMethod));
            super.visitSubcomponentFactoryMethod(graph, parent, factoryMethod);
        }

        private void addDependencyEdges(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            ResolvedBindings dependencies = this.resolvedDependencies(source, dependencyRequest);
            if (dependencies.isEmpty()) {
                this.addDependencyEdge(source, dependencyRequest, (BindingGraph.Node)this.missingBindingNode(dependencies));
            } else {
                for (BindingNode dependency : this.bindingNodes(dependencies)) {
                    this.addDependencyEdge(source, dependencyRequest, (BindingGraph.Node)dependency);
                }
            }
        }

        private void addDependencyEdge(BindingGraph.Node source, DependencyRequest dependencyRequest, BindingGraph.Node dependency) {
            this.network.addNode((Object)dependency);
            if (!this.hasDependencyEdge(source, dependency, dependencyRequest)) {
                this.network.addEdge((Object)source, (Object)dependency, (Object)new DependencyEdgeImpl(dependencyRequest, source instanceof BindingGraph.ComponentNode));
            }
        }

        private boolean hasDependencyEdge(BindingGraph.Node source, BindingGraph.Node dependency, DependencyRequest dependencyRequest) {
            return this.network.edgesConnecting((Object)source, (Object)dependency).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).anyMatch(edge -> edge.dependencyRequest().equals(dependencyRequest));
        }

        private ResolvedBindings resolvedDependencies(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            return this.componentTreePath().pathFromRootToAncestor(source.componentPath().currentComponent()).currentGraph().resolvedBindings(BindingRequest.bindingRequest(dependencyRequest));
        }

        private void addBinding(BindingNode binding) {
            this.network.addNode((Object)binding);
            for (DependencyRequest dependencyRequest : binding.dependencies()) {
                this.addDependencyEdges((BindingGraph.Node)binding, dependencyRequest);
            }
        }

        private ImmutableSet<BindingNode> bindingNodes(ResolvedBindings resolvedBindings) {
            ImmutableSet.Builder bindingNodes = ImmutableSet.builder();
            resolvedBindings.allBindings().asMap().forEach((component, bindings) -> {
                for (Binding binding : bindings) {
                    bindingNodes.add((Object)this.bindingNode(resolvedBindings, binding, (ComponentDescriptor)component));
                }
            });
            return bindingNodes.build();
        }

        private BindingNode bindingNode(ResolvedBindings resolvedBindings, Binding binding, ComponentDescriptor owningComponent) {
            return BindingNode.create(this.componentTreePath().pathFromRootToAncestor(owningComponent.typeElement()).toComponentPath(), binding, this.associatedDeclaringElements(resolvedBindings), () -> BindingGraphConverter.this.bindingDeclarationFormatter.format(binding));
        }

        private Iterable<BindingDeclaration> associatedDeclaringElements(ResolvedBindings resolvedBindings) {
            return Iterables.concat(resolvedBindings.multibindingDeclarations(), resolvedBindings.optionalBindingDeclarations(), resolvedBindings.subcomponentDeclarations());
        }

        private BindingGraph.MissingBinding missingBindingNode(ResolvedBindings dependencies) {
            return BindingGraphProxies.missingBindingNode(this.componentTreePath().pathFromRootToAncestor(dependencies.owningComponent().typeElement()).toComponentPath(), dependencies.key());
        }

        private BindingGraph.ComponentNode subcomponentNode(TypeMirror subcomponentBuilderType, BindingGraph graph) {
            TypeElement subcomponentBuilderElement = MoreTypes.asTypeElement(subcomponentBuilderType);
            ComponentDescriptor subcomponent = graph.componentDescriptor().getChildComponentWithBuilderType(subcomponentBuilderElement);
            return ComponentNodeImpl.create(this.componentTreePath().childPath(subcomponent.typeElement()).toComponentPath(), subcomponent);
        }

        private ImmutableSet<TypeElement> subcomponentDeclaringModules(ResolvedBindings resolvedBindings) {
            return resolvedBindings.subcomponentDeclarations().stream().map(BindingDeclaration::contributingModule).flatMap(DaggerStreams.presentValues()).collect(DaggerStreams.toImmutableSet());
        }
    }
}

