/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import org.apache.commons.lang.StringUtils;

public class DelimiterBuilder {
    private static final String FORMAT = "%s%s%s";
    private final String start;
    private final String end;

    public DelimiterBuilder(String delimiter) {
        StringBuilder startBuilder = new StringBuilder();
        StringBuilder endBuilder = new StringBuilder();
        boolean buildingStart = true;
        boolean hasMiddle = false;
        for (char c : StringUtils.defaultString((String)delimiter).toCharArray()) {
            if (c == '*') {
                buildingStart = false;
                hasMiddle = true;
                continue;
            }
            if (buildingStart) {
                startBuilder.append(c);
                continue;
            }
            endBuilder.append(c);
        }
        this.start = startBuilder.toString();
        this.end = hasMiddle ? endBuilder.toString() : this.start;
    }

    public String apply(String token) {
        if (token == null || token.length() == 0) {
            return token;
        }
        return String.format(FORMAT, this.start, token, this.end);
    }
}

