/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.MainClassFinder;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;

public class MainClassResolver {
    public static String resolveMainClass(@Nullable String configuredMainClass, ProjectProperties projectProperties) throws MainClassInferenceException, IOException {
        if (configuredMainClass != null) {
            if (MainClassResolver.isValidJavaClass(configuredMainClass)) {
                return configuredMainClass;
            }
            throw new MainClassInferenceException(HelpfulSuggestions.forMainClassNotFound("'mainClass' configured in " + projectProperties.getPluginName() + " is not a valid Java class: " + configuredMainClass, projectProperties.getPluginName()));
        }
        projectProperties.log(LogEvent.info("Searching for main class... Add a 'mainClass' configuration to '" + projectProperties.getPluginName() + "' to improve build speed."));
        String mainClassFromJarPlugin = projectProperties.getMainClassFromJarPlugin();
        if (mainClassFromJarPlugin != null && MainClassResolver.isValidJavaClass(mainClassFromJarPlugin)) {
            return mainClassFromJarPlugin;
        }
        if (mainClassFromJarPlugin != null) {
            projectProperties.log(LogEvent.warn("'mainClass' configured in " + projectProperties.getJarPluginName() + " is not a valid Java class: " + mainClassFromJarPlugin));
        }
        projectProperties.log(LogEvent.info("Could not find a valid main class from " + projectProperties.getJarPluginName() + "; looking into all class files to infer main class."));
        MainClassFinder.Result mainClassFinderResult = MainClassFinder.find(projectProperties.getClassFiles(), projectProperties::log);
        switch (mainClassFinderResult.getType()) {
            case MAIN_CLASS_FOUND: {
                return mainClassFinderResult.getFoundMainClass();
            }
            case MAIN_CLASS_NOT_FOUND: {
                throw new MainClassInferenceException(HelpfulSuggestions.forMainClassNotFound("Main class was not found", projectProperties.getPluginName()));
            }
            case MULTIPLE_MAIN_CLASSES: {
                throw new MainClassInferenceException(HelpfulSuggestions.forMainClassNotFound("Multiple valid main classes were found: " + String.join((CharSequence)", ", mainClassFinderResult.getFoundMainClasses()), projectProperties.getPluginName()));
            }
        }
        throw new IllegalStateException("Cannot reach here");
    }

    @VisibleForTesting
    static boolean isValidJavaClass(String className) {
        for (String part : Splitter.on((char)'.').split((CharSequence)className)) {
            if (SourceVersion.isIdentifier(part)) continue;
            return false;
        }
        return true;
    }

    private MainClassResolver() {
    }
}

