/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.configuration.credentials.CredentialRetriever;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class DefaultCredentialRetrievers {
    private final CredentialRetrieverFactory credentialRetrieverFactory;
    @Nullable
    private CredentialRetriever knownCredentialRetriever;
    @Nullable
    private CredentialRetriever inferredCredentialRetriever;
    @Nullable
    private String credentialHelperSuffix;

    public static DefaultCredentialRetrievers init(CredentialRetrieverFactory credentialRetrieverFactory) {
        return new DefaultCredentialRetrievers(credentialRetrieverFactory);
    }

    private DefaultCredentialRetrievers(CredentialRetrieverFactory credentialRetrieverFactory) {
        this.credentialRetrieverFactory = credentialRetrieverFactory;
    }

    public DefaultCredentialRetrievers setKnownCredential(Credential knownCredential, String credentialSource) {
        this.knownCredentialRetriever = this.credentialRetrieverFactory.known(knownCredential, credentialSource);
        return this;
    }

    public DefaultCredentialRetrievers setInferredCredential(Credential inferredCredential, String credentialSource) {
        this.inferredCredentialRetriever = this.credentialRetrieverFactory.known(inferredCredential, credentialSource);
        return this;
    }

    public DefaultCredentialRetrievers setCredentialHelperSuffix(@Nullable String credentialHelperSuffix) {
        this.credentialHelperSuffix = credentialHelperSuffix;
        return this;
    }

    public List<CredentialRetriever> asList() {
        ArrayList<CredentialRetriever> credentialRetrievers = new ArrayList<CredentialRetriever>();
        if (this.knownCredentialRetriever != null) {
            credentialRetrievers.add(this.knownCredentialRetriever);
        }
        if (this.credentialHelperSuffix != null) {
            credentialRetrievers.add(this.credentialRetrieverFactory.dockerCredentialHelper("docker-credential-" + this.credentialHelperSuffix));
        }
        if (this.inferredCredentialRetriever != null) {
            credentialRetrievers.add(this.inferredCredentialRetriever);
        }
        credentialRetrievers.add(this.credentialRetrieverFactory.inferCredentialHelper());
        credentialRetrievers.add(this.credentialRetrieverFactory.dockerConfig());
        return credentialRetrievers;
    }
}

