/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.ncache;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.ncache.CacheCorruptedException;
import java.nio.file.Path;
import java.security.DigestException;

class DefaultCacheStorageFiles {
    private static final String LAYERS_DIRECTORY = "layers";
    private static final String METADATA_FILENAME = "metadata";
    private static final String SELECTORS_DIRECTORY = "selectors";
    private final Path cacheDirectory;

    static boolean isLayerFile(Path file) {
        return file.getFileName().toString().length() == 64;
    }

    static boolean isMetadataFile(Path file) {
        return METADATA_FILENAME.equals(file.getFileName().toString());
    }

    static DescriptorDigest getDiffId(Path layerFile) throws CacheCorruptedException {
        try {
            String diffId = layerFile.getFileName().toString();
            return DescriptorDigest.fromHash(diffId);
        }
        catch (IndexOutOfBoundsException | DigestException ex) {
            throw new CacheCorruptedException("Layer file did not include valid diff ID: " + layerFile, ex);
        }
    }

    DefaultCacheStorageFiles(Path cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    Path getLayerFile(DescriptorDigest layerDigest, DescriptorDigest layerDiffId) {
        return this.getLayerDirectory(layerDigest).resolve(this.getLayerFilename(layerDiffId));
    }

    String getLayerFilename(DescriptorDigest layerDiffId) {
        return layerDiffId.getHash();
    }

    Path getMetadataFile(DescriptorDigest layerDigest) {
        return this.getLayerDirectory(layerDigest).resolve(METADATA_FILENAME);
    }

    String getMetadataFilename() {
        return METADATA_FILENAME;
    }

    Path getSelectorFile(DescriptorDigest selector) {
        return this.cacheDirectory.resolve(SELECTORS_DIRECTORY).resolve(selector.getHash());
    }

    Path getLayersDirectory() {
        return this.cacheDirectory.resolve(LAYERS_DIRECTORY);
    }

    Path getLayerDirectory(DescriptorDigest layerDigest) {
        return this.getLayersDirectory().resolve(layerDigest.getHash());
    }
}

