/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.JavaDockerContextGenerator;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenJibLogger;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.PluginConfigurationProcessor;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.InsecureRecursiveDeleteException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="exportDockerContext", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class DockerContextMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "exportDockerContext";
    @Nullable
    @Parameter(property="jibTargetDir", defaultValue="${project.build.directory}/jib-docker-context", required=true)
    @VisibleForTesting
    String targetDir;

    public void execute() throws MojoExecutionException {
        if (this.isSkipped()) {
            this.getLog().info((CharSequence)"Skipping containerization because jib-maven-plugin: skip = true");
            return;
        }
        if ("pom".equals(this.getProject().getPackaging())) {
            this.getLog().info((CharSequence)"Skipping containerization because packaging is 'pom'...");
            return;
        }
        MavenJibLogger mavenJibLogger = new MavenJibLogger(this.getLog());
        this.handleDeprecatedParameters(mavenJibLogger);
        try {
            JibSystemProperties.checkHttpTimeoutProperty();
        }
        catch (NumberFormatException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        Preconditions.checkNotNull((Object)this.targetDir);
        AbsoluteUnixPath appRoot = PluginConfigurationProcessor.getAppRootChecked(this);
        MavenProjectProperties mavenProjectProperties = MavenProjectProperties.getForProject(this.getProject(), this.getLog(), this.getExtraDirectory(), appRoot);
        List<String> entrypoint = this.getEntrypoint();
        if (entrypoint.isEmpty()) {
            String mainClass = mavenProjectProperties.getMainClass(this);
            entrypoint = JavaEntrypointConstructor.makeDefaultEntrypoint(appRoot, this.getJvmFlags(), mainClass);
        } else if (this.getMainClass() != null || !this.getJvmFlags().isEmpty()) {
            mavenJibLogger.warn("<mainClass> and <jvmFlags> are ignored when <entrypoint> is specified");
        }
        try {
            ExposedPortsParser.parse(this.getExposedPorts());
            new JavaDockerContextGenerator(mavenProjectProperties.getJavaLayerConfigurations()).setBaseImage(this.getBaseImage()).setEntrypoint(entrypoint).setJavaArguments(this.getArgs()).setExposedPorts(this.getExposedPorts()).setEnvironment(this.getEnvironment()).setLabels(this.getLabels()).generate(Paths.get(this.targetDir, new String[0]));
            mavenJibLogger.lifecycle("Created Docker context at " + this.targetDir);
        }
        catch (InsecureRecursiveDeleteException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forDockerContextInsecureRecursiveDelete("Export Docker context failed because cannot clear directory '" + this.targetDir + "' safely", this.targetDir), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.suggest("Export Docker context failed", "check if `targetDir` is set correctly"), (Exception)ex);
        }
    }
}

