/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.global;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;

public class JibSystemProperties {
    @VisibleForTesting
    public static final String HTTP_TIMEOUT = "jib.httpTimeout";
    @VisibleForTesting
    public static final String SEND_CREDENTIALS_OVER_HTTP = "sendCredentialsOverHttp";
    private static final String SERIALIZE = "jibSerialize";
    private static final String DISABLE_USER_AGENT = "_JIB_DISABLE_USER_AGENT";

    public static int getHttpTimeout() {
        if (Integer.getInteger(HTTP_TIMEOUT) == null) {
            return 20000;
        }
        return Integer.getInteger(HTTP_TIMEOUT);
    }

    public static boolean isSerializedExecutionEnabled() {
        return Boolean.getBoolean(SERIALIZE);
    }

    public static boolean isSendCredentialsOverHttpEnabled() {
        return Boolean.getBoolean(SEND_CREDENTIALS_OVER_HTTP);
    }

    public static boolean isUserAgentEnabled() {
        return Strings.isNullOrEmpty((String)System.getProperty(DISABLE_USER_AGENT));
    }

    public static void checkHttpTimeoutProperty() throws NumberFormatException {
        int parsed;
        String value = System.getProperty(HTTP_TIMEOUT);
        if (value == null) {
            return;
        }
        try {
            parsed = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("jib.httpTimeout must be an integer: " + value);
        }
        if (parsed < 0) {
            throw new NumberFormatException("jib.httpTimeout cannot be negative: " + value);
        }
    }

    private JibSystemProperties() {
    }
}

