/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.bigquery.integration.outbound;

import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.spring.bigquery.core.BigQueryTemplate;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.io.Resource;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;

public class BigQueryFileMessageHandler
extends AbstractReplyProducingMessageHandler {
    private final BigQueryTemplate bigQueryTemplate;
    private EvaluationContext evaluationContext;
    private Expression tableNameExpression;
    private Expression formatOptionsExpression;
    private Expression tableSchemaExpression;
    private Duration timeout = Duration.ofMinutes(5L);
    private boolean sync = false;

    public BigQueryFileMessageHandler(BigQueryTemplate bigQueryTemplate) {
        Assert.notNull((Object)bigQueryTemplate, (String)"BigQueryTemplate must not be null.");
        this.bigQueryTemplate = bigQueryTemplate;
        this.tableNameExpression = new FunctionExpression(message -> message.getHeaders().get((Object)"gcp_bigquery_table_name"));
        this.formatOptionsExpression = new FunctionExpression(message -> message.getHeaders().get((Object)"gcp_bigquery_format_options"));
        this.tableSchemaExpression = new FunctionExpression(message -> message.getHeaders().get((Object)"gcp_bigquery_table_schema"));
    }

    protected void doInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    public void setTableNameExpression(Expression tableNameExpression) {
        Assert.notNull((Object)tableNameExpression, (String)"Table name expression must not be null.");
        this.tableNameExpression = tableNameExpression;
    }

    public void setTableName(String tableName) {
        this.tableNameExpression = new LiteralExpression(tableName);
    }

    public void setFormatOptionsExpression(Expression formatOptionsExpression) {
        Assert.notNull((Object)formatOptionsExpression, (String)"Format options expression cannot be null.");
        this.formatOptionsExpression = formatOptionsExpression;
    }

    public void setFormatOptions(FormatOptions formatOptions) {
        Assert.notNull((Object)formatOptions, (String)"Format options must not be null.");
        this.formatOptionsExpression = new ValueExpression((Object)formatOptions);
    }

    public void setTableSchemaExpression(Expression tableSchemaExpression) {
        Assert.notNull((Object)tableSchemaExpression, (String)"The table schema expression cannot be null.");
        this.tableSchemaExpression = tableSchemaExpression;
    }

    public void setTableSchema(Schema schema) {
        this.tableSchemaExpression = new ValueExpression((Object)schema);
    }

    public void setTimeout(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout duration must not be null.");
        this.timeout = timeout;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object handleRequestMessage(Message<?> message) {
        String tableName = (String)this.tableNameExpression.getValue(this.evaluationContext, message, String.class);
        FormatOptions formatOptions = (FormatOptions)this.formatOptionsExpression.getValue(this.evaluationContext, message, FormatOptions.class);
        Schema schema = (Schema)this.tableSchemaExpression.getValue(this.evaluationContext, message, Schema.class);
        Assert.notNull((Object)tableName, (String)"BigQuery table name must not be null.");
        Assert.notNull((Object)formatOptions, (String)"Data file formatOptions must not be null.");
        try (InputStream inputStream = BigQueryFileMessageHandler.convertToInputStream(message.getPayload());){
            ListenableFuture<Job> jobFuture = this.bigQueryTemplate.writeDataToTable(tableName, inputStream, formatOptions, schema);
            if (this.sync) {
                Object object = jobFuture.get(this.timeout.getSeconds(), TimeUnit.SECONDS);
                return object;
            }
            ListenableFuture<Job> listenableFuture = jobFuture;
            return listenableFuture;
        }
        catch (FileNotFoundException e) {
            throw new MessageHandlingException(message, "Failed to find file to write to BigQuery in message handler: " + (Object)((Object)this), (Throwable)e);
        }
        catch (IOException e) {
            throw new MessageHandlingException(message, "Failed to write data to BigQuery tables in message handler: " + (Object)((Object)this), (Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new MessageHandlingException(message, "Failed to wait for BigQuery Job to complete in message handler: " + (Object)((Object)this), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessageHandlingException(message, "Failed to wait for BigQuery Job (interrupted) in message handler: " + (Object)((Object)this), (Throwable)e);
        }
    }

    private static InputStream convertToInputStream(Object payload) throws IOException {
        InputStream result;
        if (payload instanceof File) {
            result = new BufferedInputStream(new FileInputStream((File)payload));
        } else if (payload instanceof byte[]) {
            result = new ByteArrayInputStream((byte[])payload);
        } else if (payload instanceof InputStream) {
            result = (InputStream)payload;
        } else if (payload instanceof Resource) {
            result = ((Resource)payload).getInputStream();
        } else {
            throw new IllegalArgumentException(String.format("Unsupported message payload type: %s. The supported payload types are: java.io.File, byte[], org.springframework.core.io.Resource, and java.io.InputStream.", payload.getClass().getName()));
        }
        return result;
    }
}

