/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.pubsub;

import com.google.cloud.spring.autoconfigure.pubsub.GcpPubSubAutoConfiguration;
import com.google.cloud.spring.pubsub.core.subscriber.PubSubSubscriberOperations;
import com.google.cloud.spring.pubsub.core.subscriber.PubSubSubscriberTemplate;
import com.google.cloud.spring.pubsub.reactive.PubSubReactiveFactory;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={GcpPubSubAutoConfiguration.class})
@ConditionalOnClass(value={Flux.class, PubSubSubscriberTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.pubsub.reactive.enabled", "spring.cloud.gcp.pubsub.enabled"}, matchIfMissing=true)
public class GcpPubSubReactiveAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PubSubReactiveFactory pubSubReactiveFactory(PubSubSubscriberTemplate subscriberTemplate, @Qualifier(value="pubSubReactiveScheduler") Optional<Scheduler> userProvidedScheduler) {
        Scheduler scheduler = userProvidedScheduler.orElseGet(Schedulers::parallel);
        return new PubSubReactiveFactory((PubSubSubscriberOperations)subscriberTemplate, scheduler);
    }
}

