/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.gax.paging.Page;
import com.google.cloud.BaseService;
import com.google.cloud.PageImpl;
import com.google.cloud.ServiceOptions;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchClientImpl;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseAdminClientImpl;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceAdminClientImpl;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.spanner.v1.Session;
import io.grpc.Context;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class SpannerImpl
extends BaseService<SpannerOptions>
implements Spanner {
    private static final int MIN_BACKOFF_MS = 1000;
    private static final int MAX_BACKOFF_MS = 32000;
    private static final Logger logger = Logger.getLogger(SpannerImpl.class.getName());
    private static final Tracer tracer = Tracing.getTracer();
    private static final String CREATE_SESSION = "CloudSpannerOperation.CreateSession";
    static final String DELETE_SESSION = "CloudSpannerOperation.DeleteSession";
    static final String BEGIN_TRANSACTION = "CloudSpannerOperation.BeginTransaction";
    static final String COMMIT = "CloudSpannerOperation.Commit";
    static final String QUERY = "CloudSpannerOperation.ExecuteStreamingQuery";
    static final String READ = "CloudSpannerOperation.ExecuteStreamingRead";
    private final Random random = new Random();
    private final SpannerRpc gapicRpc;
    @GuardedBy(value="this")
    private final Map<DatabaseId, DatabaseClientImpl> dbClients = new HashMap<DatabaseId, DatabaseClientImpl>();
    private final DatabaseAdminClient dbAdminClient;
    private final InstanceAdminClient instanceClient;
    @GuardedBy(value="this")
    private boolean spannerIsClosed = false;

    @VisibleForTesting
    SpannerImpl(SpannerRpc gapicRpc, SpannerOptions options) {
        super((ServiceOptions)options);
        this.gapicRpc = gapicRpc;
        this.dbAdminClient = new DatabaseAdminClientImpl(options.getProjectId(), gapicRpc);
        this.instanceClient = new InstanceAdminClientImpl(options.getProjectId(), gapicRpc, this.dbAdminClient);
    }

    SpannerImpl(SpannerOptions options) {
        this(options.getSpannerRpcV1(), options);
    }

    static ExponentialBackOff newBackOff() {
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setMaxIntervalMillis(32000).setMaxElapsedTimeMillis(Integer.MAX_VALUE).build();
    }

    static void backoffSleep(Context context, BackOff backoff) throws SpannerException {
        SpannerImpl.backoffSleep(context, SpannerImpl.nextBackOffMillis(backoff));
    }

    static long nextBackOffMillis(BackOff backoff) throws SpannerException {
        try {
            return backoff.nextBackOffMillis();
        }
        catch (IOException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, e.getMessage(), e);
        }
    }

    static void backoffSleep(Context context, long backoffMillis) throws SpannerException {
        tracer.getCurrentSpan().addAnnotation("Backing off", (Map)ImmutableMap.of((Object)"Delay", (Object)AttributeValue.longAttributeValue((long)backoffMillis)));
        final CountDownLatch latch = new CountDownLatch(1);
        Context.CancellationListener listener = new Context.CancellationListener(){

            public void cancelled(Context context) {
                latch.countDown();
            }
        };
        context.addListener(listener, (Executor)DirectExecutor.INSTANCE);
        try {
            if (backoffMillis == -1L) {
                backoffMillis = 32000L;
            }
            if (latch.await(backoffMillis, TimeUnit.MILLISECONDS)) {
                throw SpannerExceptionFactory.newSpannerExceptionForCancellation(context, null);
            }
        }
        catch (InterruptedException interruptExcept) {
            throw SpannerExceptionFactory.newSpannerExceptionForCancellation(context, interruptExcept);
        }
        finally {
            context.removeListener(listener);
        }
    }

    SpannerRpc getRpc() {
        return this.gapicRpc;
    }

    int getDefaultPrefetchChunks() {
        return ((SpannerOptions)this.getOptions()).getPrefetchChunks();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    SessionImpl createSession(DatabaseId db) throws SpannerException {
        Map<SpannerRpc.Option, ?> options = SpannerImpl.optionMap(SessionOption.channelHint(this.random.nextLong()));
        Span span = tracer.spanBuilder(CREATE_SESSION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            Session session = this.gapicRpc.createSession(db.getName(), ((SpannerOptions)this.getOptions()).getSessionLabels(), options);
            span.end();
            SessionImpl sessionImpl = new SessionImpl(this, session.getName(), options);
            return sessionImpl;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    SessionImpl sessionWithId(String name) {
        Map<SpannerRpc.Option, ?> options = SpannerImpl.optionMap(SessionOption.channelHint(this.random.nextLong()));
        return new SessionImpl(this, name, options);
    }

    @Override
    public DatabaseAdminClient getDatabaseAdminClient() {
        return this.dbAdminClient;
    }

    @Override
    public InstanceAdminClient getInstanceAdminClient() {
        return this.instanceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseClient getDatabaseClient(DatabaseId db) {
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            Preconditions.checkState((!this.spannerIsClosed ? 1 : 0) != 0, (Object)"Cloud Spanner client has been closed");
            if (this.dbClients.containsKey(db)) {
                return this.dbClients.get(db);
            }
            SessionPool pool = SessionPool.createPool((SpannerOptions)this.getOptions(), db, this);
            DatabaseClientImpl dbClient = this.createDatabaseClient(pool);
            this.dbClients.put(db, dbClient);
            return dbClient;
        }
    }

    @VisibleForTesting
    DatabaseClientImpl createDatabaseClient(SessionPool pool) {
        return new DatabaseClientImpl(pool);
    }

    @Override
    public BatchClient getBatchClient(DatabaseId db) {
        return new BatchClientImpl(db, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<ListenableFuture<Void>> closureFutures = null;
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            Preconditions.checkState((!this.spannerIsClosed ? 1 : 0) != 0, (Object)"Cloud Spanner client has been closed");
            this.spannerIsClosed = true;
            closureFutures = new ArrayList<ListenableFuture<Void>>();
            for (DatabaseClientImpl dbClient : this.dbClients.values()) {
                closureFutures.add(dbClient.closeAsync());
            }
            this.dbClients.clear();
        }
        try {
            Futures.successfulAsList(closureFutures).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
        try {
            this.gapicRpc.shutdown();
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Failed to close channels", e);
        }
    }

    static void checkContext(Context context) {
        if (context.isCancelled()) {
            throw SpannerExceptionFactory.newSpannerExceptionForCancellation(context, null);
        }
    }

    static Map<SpannerRpc.Option, ?> optionMap(SessionOption ... options) {
        if (options.length == 0) {
            return Collections.emptyMap();
        }
        EnumMap tmp = Maps.newEnumMap(SpannerRpc.Option.class);
        for (SessionOption option : options) {
            Object prev = tmp.put(option.rpcOption(), option.value());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object)((Object)option.rpcOption()));
        }
        return ImmutableMap.copyOf((Map)tmp);
    }

    static {
        TraceUtil.exportSpans(CREATE_SESSION, DELETE_SESSION, BEGIN_TRANSACTION, COMMIT, QUERY, READ);
    }

    private static enum DirectExecutor implements Executor
    {
        INSTANCE;


        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    static abstract class PageFetcher<S, T>
    implements PageImpl.NextPageFetcher<S> {
        private String nextPageToken;

        PageFetcher() {
        }

        public Page<S> getNextPage() {
            SpannerRpc.Paginated<T> nextPage = this.getNextPage(this.nextPageToken);
            this.nextPageToken = nextPage.getNextPageToken();
            ArrayList<S> results = new ArrayList<S>();
            for (T proto : nextPage.getResults()) {
                results.add(this.fromProto(proto));
            }
            return new PageImpl((PageImpl.NextPageFetcher)this, this.nextPageToken, results);
        }

        void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        abstract SpannerRpc.Paginated<T> getNextPage(@Nullable String var1);

        abstract S fromProto(T var1);
    }

    static class SessionOption {
        private final SpannerRpc.Option rpcOption;
        private final Object value;

        SessionOption(SpannerRpc.Option option, Object value) {
            this.rpcOption = (SpannerRpc.Option)((Object)Preconditions.checkNotNull((Object)((Object)option)));
            this.value = value;
        }

        static SessionOption channelHint(long hint) {
            return new SessionOption(SpannerRpc.Option.CHANNEL_HINT, hint);
        }

        SpannerRpc.Option rpcOption() {
            return this.rpcOption;
        }

        Object value() {
            return this.value;
        }
    }
}

