/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.serviceusage.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.serviceusage.v1beta1.BatchEnableServicesRequest;
import com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit;
import com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric;
import com.google.api.serviceusage.v1beta1.CreateAdminOverrideRequest;
import com.google.api.serviceusage.v1beta1.CreateConsumerOverrideRequest;
import com.google.api.serviceusage.v1beta1.DeleteAdminOverrideRequest;
import com.google.api.serviceusage.v1beta1.DeleteConsumerOverrideRequest;
import com.google.api.serviceusage.v1beta1.DisableServiceRequest;
import com.google.api.serviceusage.v1beta1.EnableServiceRequest;
import com.google.api.serviceusage.v1beta1.GenerateServiceIdentityRequest;
import com.google.api.serviceusage.v1beta1.GetConsumerQuotaLimitRequest;
import com.google.api.serviceusage.v1beta1.GetConsumerQuotaMetricRequest;
import com.google.api.serviceusage.v1beta1.GetServiceRequest;
import com.google.api.serviceusage.v1beta1.ImportAdminOverridesMetadata;
import com.google.api.serviceusage.v1beta1.ImportAdminOverridesRequest;
import com.google.api.serviceusage.v1beta1.ImportAdminOverridesResponse;
import com.google.api.serviceusage.v1beta1.ImportConsumerOverridesMetadata;
import com.google.api.serviceusage.v1beta1.ImportConsumerOverridesRequest;
import com.google.api.serviceusage.v1beta1.ImportConsumerOverridesResponse;
import com.google.api.serviceusage.v1beta1.ListAdminOverridesRequest;
import com.google.api.serviceusage.v1beta1.ListAdminOverridesResponse;
import com.google.api.serviceusage.v1beta1.ListConsumerOverridesRequest;
import com.google.api.serviceusage.v1beta1.ListConsumerOverridesResponse;
import com.google.api.serviceusage.v1beta1.ListConsumerQuotaMetricsRequest;
import com.google.api.serviceusage.v1beta1.ListConsumerQuotaMetricsResponse;
import com.google.api.serviceusage.v1beta1.ListServicesRequest;
import com.google.api.serviceusage.v1beta1.ListServicesResponse;
import com.google.api.serviceusage.v1beta1.OperationMetadata;
import com.google.api.serviceusage.v1beta1.QuotaOverride;
import com.google.api.serviceusage.v1beta1.Service;
import com.google.api.serviceusage.v1beta1.ServiceIdentity;
import com.google.api.serviceusage.v1beta1.ServiceUsageClient;
import com.google.api.serviceusage.v1beta1.UpdateAdminOverrideRequest;
import com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest;
import com.google.api.serviceusage.v1beta1.stub.GrpcServiceUsageStub;
import com.google.api.serviceusage.v1beta1.stub.HttpJsonServiceUsageStub;
import com.google.api.serviceusage.v1beta1.stub.ServiceUsageStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ServiceUsageStubSettings
extends StubSettings<ServiceUsageStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/service.management").build();
    private final UnaryCallSettings<EnableServiceRequest, Operation> enableServiceSettings;
    private final OperationCallSettings<EnableServiceRequest, Empty, OperationMetadata> enableServiceOperationSettings;
    private final UnaryCallSettings<DisableServiceRequest, Operation> disableServiceSettings;
    private final OperationCallSettings<DisableServiceRequest, Empty, OperationMetadata> disableServiceOperationSettings;
    private final UnaryCallSettings<GetServiceRequest, Service> getServiceSettings;
    private final PagedCallSettings<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse> listServicesSettings;
    private final UnaryCallSettings<BatchEnableServicesRequest, Operation> batchEnableServicesSettings;
    private final OperationCallSettings<BatchEnableServicesRequest, Empty, OperationMetadata> batchEnableServicesOperationSettings;
    private final PagedCallSettings<ListConsumerQuotaMetricsRequest, ListConsumerQuotaMetricsResponse, ServiceUsageClient.ListConsumerQuotaMetricsPagedResponse> listConsumerQuotaMetricsSettings;
    private final UnaryCallSettings<GetConsumerQuotaMetricRequest, ConsumerQuotaMetric> getConsumerQuotaMetricSettings;
    private final UnaryCallSettings<GetConsumerQuotaLimitRequest, ConsumerQuotaLimit> getConsumerQuotaLimitSettings;
    private final UnaryCallSettings<CreateAdminOverrideRequest, Operation> createAdminOverrideSettings;
    private final OperationCallSettings<CreateAdminOverrideRequest, QuotaOverride, OperationMetadata> createAdminOverrideOperationSettings;
    private final UnaryCallSettings<UpdateAdminOverrideRequest, Operation> updateAdminOverrideSettings;
    private final OperationCallSettings<UpdateAdminOverrideRequest, QuotaOverride, OperationMetadata> updateAdminOverrideOperationSettings;
    private final UnaryCallSettings<DeleteAdminOverrideRequest, Operation> deleteAdminOverrideSettings;
    private final OperationCallSettings<DeleteAdminOverrideRequest, Empty, OperationMetadata> deleteAdminOverrideOperationSettings;
    private final PagedCallSettings<ListAdminOverridesRequest, ListAdminOverridesResponse, ServiceUsageClient.ListAdminOverridesPagedResponse> listAdminOverridesSettings;
    private final UnaryCallSettings<ImportAdminOverridesRequest, Operation> importAdminOverridesSettings;
    private final OperationCallSettings<ImportAdminOverridesRequest, ImportAdminOverridesResponse, ImportAdminOverridesMetadata> importAdminOverridesOperationSettings;
    private final UnaryCallSettings<CreateConsumerOverrideRequest, Operation> createConsumerOverrideSettings;
    private final OperationCallSettings<CreateConsumerOverrideRequest, QuotaOverride, OperationMetadata> createConsumerOverrideOperationSettings;
    private final UnaryCallSettings<UpdateConsumerOverrideRequest, Operation> updateConsumerOverrideSettings;
    private final OperationCallSettings<UpdateConsumerOverrideRequest, QuotaOverride, OperationMetadata> updateConsumerOverrideOperationSettings;
    private final UnaryCallSettings<DeleteConsumerOverrideRequest, Operation> deleteConsumerOverrideSettings;
    private final OperationCallSettings<DeleteConsumerOverrideRequest, Empty, OperationMetadata> deleteConsumerOverrideOperationSettings;
    private final PagedCallSettings<ListConsumerOverridesRequest, ListConsumerOverridesResponse, ServiceUsageClient.ListConsumerOverridesPagedResponse> listConsumerOverridesSettings;
    private final UnaryCallSettings<ImportConsumerOverridesRequest, Operation> importConsumerOverridesSettings;
    private final OperationCallSettings<ImportConsumerOverridesRequest, ImportConsumerOverridesResponse, ImportConsumerOverridesMetadata> importConsumerOverridesOperationSettings;
    private final UnaryCallSettings<GenerateServiceIdentityRequest, Operation> generateServiceIdentitySettings;
    private final OperationCallSettings<GenerateServiceIdentityRequest, ServiceIdentity, Empty> generateServiceIdentityOperationSettings;
    private static final PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service> LIST_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service>(){

        public String emptyToken() {
            return "";
        }

        public ListServicesRequest injectToken(ListServicesRequest payload, String token) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageToken(token).build();
        }

        public ListServicesRequest injectPageSize(ListServicesRequest payload, int pageSize) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Service> extractResources(ListServicesResponse payload) {
            return payload.getServicesList();
        }
    };
    private static final PagedListDescriptor<ListConsumerQuotaMetricsRequest, ListConsumerQuotaMetricsResponse, ConsumerQuotaMetric> LIST_CONSUMER_QUOTA_METRICS_PAGE_STR_DESC = new PagedListDescriptor<ListConsumerQuotaMetricsRequest, ListConsumerQuotaMetricsResponse, ConsumerQuotaMetric>(){

        public String emptyToken() {
            return "";
        }

        public ListConsumerQuotaMetricsRequest injectToken(ListConsumerQuotaMetricsRequest payload, String token) {
            return ListConsumerQuotaMetricsRequest.newBuilder((ListConsumerQuotaMetricsRequest)payload).setPageToken(token).build();
        }

        public ListConsumerQuotaMetricsRequest injectPageSize(ListConsumerQuotaMetricsRequest payload, int pageSize) {
            return ListConsumerQuotaMetricsRequest.newBuilder((ListConsumerQuotaMetricsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConsumerQuotaMetricsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConsumerQuotaMetricsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ConsumerQuotaMetric> extractResources(ListConsumerQuotaMetricsResponse payload) {
            return payload.getMetricsList();
        }
    };
    private static final PagedListDescriptor<ListAdminOverridesRequest, ListAdminOverridesResponse, QuotaOverride> LIST_ADMIN_OVERRIDES_PAGE_STR_DESC = new PagedListDescriptor<ListAdminOverridesRequest, ListAdminOverridesResponse, QuotaOverride>(){

        public String emptyToken() {
            return "";
        }

        public ListAdminOverridesRequest injectToken(ListAdminOverridesRequest payload, String token) {
            return ListAdminOverridesRequest.newBuilder((ListAdminOverridesRequest)payload).setPageToken(token).build();
        }

        public ListAdminOverridesRequest injectPageSize(ListAdminOverridesRequest payload, int pageSize) {
            return ListAdminOverridesRequest.newBuilder((ListAdminOverridesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAdminOverridesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAdminOverridesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<QuotaOverride> extractResources(ListAdminOverridesResponse payload) {
            return payload.getOverridesList();
        }
    };
    private static final PagedListDescriptor<ListConsumerOverridesRequest, ListConsumerOverridesResponse, QuotaOverride> LIST_CONSUMER_OVERRIDES_PAGE_STR_DESC = new PagedListDescriptor<ListConsumerOverridesRequest, ListConsumerOverridesResponse, QuotaOverride>(){

        public String emptyToken() {
            return "";
        }

        public ListConsumerOverridesRequest injectToken(ListConsumerOverridesRequest payload, String token) {
            return ListConsumerOverridesRequest.newBuilder((ListConsumerOverridesRequest)payload).setPageToken(token).build();
        }

        public ListConsumerOverridesRequest injectPageSize(ListConsumerOverridesRequest payload, int pageSize) {
            return ListConsumerOverridesRequest.newBuilder((ListConsumerOverridesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConsumerOverridesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConsumerOverridesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<QuotaOverride> extractResources(ListConsumerOverridesResponse payload) {
            return payload.getOverridesList();
        }
    };
    private static final PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse> LIST_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse>(){

        public ApiFuture<ServiceUsageClient.ListServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicesRequest, ListServicesResponse> callable, ListServicesRequest request, ApiCallContext context, ApiFuture<ListServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceUsageClient.ListServicesPagedResponse.createAsync((PageContext<ListServicesRequest, ListServicesResponse, Service>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListConsumerQuotaMetricsRequest, ListConsumerQuotaMetricsResponse, ServiceUsageClient.ListConsumerQuotaMetricsPagedResponse> LIST_CONSUMER_QUOTA_METRICS_PAGE_STR_FACT = new PagedListResponseFactory<ListConsumerQuotaMetricsRequest, ListConsumerQuotaMetricsResponse, ServiceUsageClient.ListConsumerQuotaMetricsPagedResponse>(){

        public ApiFuture<ServiceUsageClient.ListConsumerQuotaMetricsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConsumerQuotaMetricsRequest, ListConsumerQuotaMetricsResponse> callable, ListConsumerQuotaMetricsRequest request, ApiCallContext context, ApiFuture<ListConsumerQuotaMetricsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONSUMER_QUOTA_METRICS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceUsageClient.ListConsumerQuotaMetricsPagedResponse.createAsync((PageContext<ListConsumerQuotaMetricsRequest, ListConsumerQuotaMetricsResponse, ConsumerQuotaMetric>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAdminOverridesRequest, ListAdminOverridesResponse, ServiceUsageClient.ListAdminOverridesPagedResponse> LIST_ADMIN_OVERRIDES_PAGE_STR_FACT = new PagedListResponseFactory<ListAdminOverridesRequest, ListAdminOverridesResponse, ServiceUsageClient.ListAdminOverridesPagedResponse>(){

        public ApiFuture<ServiceUsageClient.ListAdminOverridesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAdminOverridesRequest, ListAdminOverridesResponse> callable, ListAdminOverridesRequest request, ApiCallContext context, ApiFuture<ListAdminOverridesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ADMIN_OVERRIDES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceUsageClient.ListAdminOverridesPagedResponse.createAsync((PageContext<ListAdminOverridesRequest, ListAdminOverridesResponse, QuotaOverride>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListConsumerOverridesRequest, ListConsumerOverridesResponse, ServiceUsageClient.ListConsumerOverridesPagedResponse> LIST_CONSUMER_OVERRIDES_PAGE_STR_FACT = new PagedListResponseFactory<ListConsumerOverridesRequest, ListConsumerOverridesResponse, ServiceUsageClient.ListConsumerOverridesPagedResponse>(){

        public ApiFuture<ServiceUsageClient.ListConsumerOverridesPagedResponse> getFuturePagedResponse(UnaryCallable<ListConsumerOverridesRequest, ListConsumerOverridesResponse> callable, ListConsumerOverridesRequest request, ApiCallContext context, ApiFuture<ListConsumerOverridesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONSUMER_OVERRIDES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceUsageClient.ListConsumerOverridesPagedResponse.createAsync((PageContext<ListConsumerOverridesRequest, ListConsumerOverridesResponse, QuotaOverride>)pageContext, futureResponse);
        }
    };

    @Deprecated
    public UnaryCallSettings<EnableServiceRequest, Operation> enableServiceSettings() {
        return this.enableServiceSettings;
    }

    public OperationCallSettings<EnableServiceRequest, Empty, OperationMetadata> enableServiceOperationSettings() {
        return this.enableServiceOperationSettings;
    }

    @Deprecated
    public UnaryCallSettings<DisableServiceRequest, Operation> disableServiceSettings() {
        return this.disableServiceSettings;
    }

    public OperationCallSettings<DisableServiceRequest, Empty, OperationMetadata> disableServiceOperationSettings() {
        return this.disableServiceOperationSettings;
    }

    @Deprecated
    public UnaryCallSettings<GetServiceRequest, Service> getServiceSettings() {
        return this.getServiceSettings;
    }

    @Deprecated
    public PagedCallSettings<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse> listServicesSettings() {
        return this.listServicesSettings;
    }

    @Deprecated
    public UnaryCallSettings<BatchEnableServicesRequest, Operation> batchEnableServicesSettings() {
        return this.batchEnableServicesSettings;
    }

    public OperationCallSettings<BatchEnableServicesRequest, Empty, OperationMetadata> batchEnableServicesOperationSettings() {
        return this.batchEnableServicesOperationSettings;
    }

    public PagedCallSettings<ListConsumerQuotaMetricsRequest, ListConsumerQuotaMetricsResponse, ServiceUsageClient.ListConsumerQuotaMetricsPagedResponse> listConsumerQuotaMetricsSettings() {
        return this.listConsumerQuotaMetricsSettings;
    }

    public UnaryCallSettings<GetConsumerQuotaMetricRequest, ConsumerQuotaMetric> getConsumerQuotaMetricSettings() {
        return this.getConsumerQuotaMetricSettings;
    }

    public UnaryCallSettings<GetConsumerQuotaLimitRequest, ConsumerQuotaLimit> getConsumerQuotaLimitSettings() {
        return this.getConsumerQuotaLimitSettings;
    }

    public UnaryCallSettings<CreateAdminOverrideRequest, Operation> createAdminOverrideSettings() {
        return this.createAdminOverrideSettings;
    }

    public OperationCallSettings<CreateAdminOverrideRequest, QuotaOverride, OperationMetadata> createAdminOverrideOperationSettings() {
        return this.createAdminOverrideOperationSettings;
    }

    public UnaryCallSettings<UpdateAdminOverrideRequest, Operation> updateAdminOverrideSettings() {
        return this.updateAdminOverrideSettings;
    }

    public OperationCallSettings<UpdateAdminOverrideRequest, QuotaOverride, OperationMetadata> updateAdminOverrideOperationSettings() {
        return this.updateAdminOverrideOperationSettings;
    }

    public UnaryCallSettings<DeleteAdminOverrideRequest, Operation> deleteAdminOverrideSettings() {
        return this.deleteAdminOverrideSettings;
    }

    public OperationCallSettings<DeleteAdminOverrideRequest, Empty, OperationMetadata> deleteAdminOverrideOperationSettings() {
        return this.deleteAdminOverrideOperationSettings;
    }

    public PagedCallSettings<ListAdminOverridesRequest, ListAdminOverridesResponse, ServiceUsageClient.ListAdminOverridesPagedResponse> listAdminOverridesSettings() {
        return this.listAdminOverridesSettings;
    }

    public UnaryCallSettings<ImportAdminOverridesRequest, Operation> importAdminOverridesSettings() {
        return this.importAdminOverridesSettings;
    }

    public OperationCallSettings<ImportAdminOverridesRequest, ImportAdminOverridesResponse, ImportAdminOverridesMetadata> importAdminOverridesOperationSettings() {
        return this.importAdminOverridesOperationSettings;
    }

    public UnaryCallSettings<CreateConsumerOverrideRequest, Operation> createConsumerOverrideSettings() {
        return this.createConsumerOverrideSettings;
    }

    public OperationCallSettings<CreateConsumerOverrideRequest, QuotaOverride, OperationMetadata> createConsumerOverrideOperationSettings() {
        return this.createConsumerOverrideOperationSettings;
    }

    public UnaryCallSettings<UpdateConsumerOverrideRequest, Operation> updateConsumerOverrideSettings() {
        return this.updateConsumerOverrideSettings;
    }

    public OperationCallSettings<UpdateConsumerOverrideRequest, QuotaOverride, OperationMetadata> updateConsumerOverrideOperationSettings() {
        return this.updateConsumerOverrideOperationSettings;
    }

    public UnaryCallSettings<DeleteConsumerOverrideRequest, Operation> deleteConsumerOverrideSettings() {
        return this.deleteConsumerOverrideSettings;
    }

    public OperationCallSettings<DeleteConsumerOverrideRequest, Empty, OperationMetadata> deleteConsumerOverrideOperationSettings() {
        return this.deleteConsumerOverrideOperationSettings;
    }

    public PagedCallSettings<ListConsumerOverridesRequest, ListConsumerOverridesResponse, ServiceUsageClient.ListConsumerOverridesPagedResponse> listConsumerOverridesSettings() {
        return this.listConsumerOverridesSettings;
    }

    public UnaryCallSettings<ImportConsumerOverridesRequest, Operation> importConsumerOverridesSettings() {
        return this.importConsumerOverridesSettings;
    }

    public OperationCallSettings<ImportConsumerOverridesRequest, ImportConsumerOverridesResponse, ImportConsumerOverridesMetadata> importConsumerOverridesOperationSettings() {
        return this.importConsumerOverridesOperationSettings;
    }

    public UnaryCallSettings<GenerateServiceIdentityRequest, Operation> generateServiceIdentitySettings() {
        return this.generateServiceIdentitySettings;
    }

    public OperationCallSettings<GenerateServiceIdentityRequest, ServiceIdentity, Empty> generateServiceIdentityOperationSettings() {
        return this.generateServiceIdentityOperationSettings;
    }

    public ServiceUsageStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcServiceUsageStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonServiceUsageStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "serviceusage";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "serviceusage.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "serviceusage.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ServiceUsageStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServiceUsageStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServiceUsageStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ServiceUsageStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ServiceUsageStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.enableServiceSettings = settingsBuilder.enableServiceSettings().build();
        this.enableServiceOperationSettings = settingsBuilder.enableServiceOperationSettings().build();
        this.disableServiceSettings = settingsBuilder.disableServiceSettings().build();
        this.disableServiceOperationSettings = settingsBuilder.disableServiceOperationSettings().build();
        this.getServiceSettings = settingsBuilder.getServiceSettings().build();
        this.listServicesSettings = settingsBuilder.listServicesSettings().build();
        this.batchEnableServicesSettings = settingsBuilder.batchEnableServicesSettings().build();
        this.batchEnableServicesOperationSettings = settingsBuilder.batchEnableServicesOperationSettings().build();
        this.listConsumerQuotaMetricsSettings = settingsBuilder.listConsumerQuotaMetricsSettings().build();
        this.getConsumerQuotaMetricSettings = settingsBuilder.getConsumerQuotaMetricSettings().build();
        this.getConsumerQuotaLimitSettings = settingsBuilder.getConsumerQuotaLimitSettings().build();
        this.createAdminOverrideSettings = settingsBuilder.createAdminOverrideSettings().build();
        this.createAdminOverrideOperationSettings = settingsBuilder.createAdminOverrideOperationSettings().build();
        this.updateAdminOverrideSettings = settingsBuilder.updateAdminOverrideSettings().build();
        this.updateAdminOverrideOperationSettings = settingsBuilder.updateAdminOverrideOperationSettings().build();
        this.deleteAdminOverrideSettings = settingsBuilder.deleteAdminOverrideSettings().build();
        this.deleteAdminOverrideOperationSettings = settingsBuilder.deleteAdminOverrideOperationSettings().build();
        this.listAdminOverridesSettings = settingsBuilder.listAdminOverridesSettings().build();
        this.importAdminOverridesSettings = settingsBuilder.importAdminOverridesSettings().build();
        this.importAdminOverridesOperationSettings = settingsBuilder.importAdminOverridesOperationSettings().build();
        this.createConsumerOverrideSettings = settingsBuilder.createConsumerOverrideSettings().build();
        this.createConsumerOverrideOperationSettings = settingsBuilder.createConsumerOverrideOperationSettings().build();
        this.updateConsumerOverrideSettings = settingsBuilder.updateConsumerOverrideSettings().build();
        this.updateConsumerOverrideOperationSettings = settingsBuilder.updateConsumerOverrideOperationSettings().build();
        this.deleteConsumerOverrideSettings = settingsBuilder.deleteConsumerOverrideSettings().build();
        this.deleteConsumerOverrideOperationSettings = settingsBuilder.deleteConsumerOverrideOperationSettings().build();
        this.listConsumerOverridesSettings = settingsBuilder.listConsumerOverridesSettings().build();
        this.importConsumerOverridesSettings = settingsBuilder.importConsumerOverridesSettings().build();
        this.importConsumerOverridesOperationSettings = settingsBuilder.importConsumerOverridesOperationSettings().build();
        this.generateServiceIdentitySettings = settingsBuilder.generateServiceIdentitySettings().build();
        this.generateServiceIdentityOperationSettings = settingsBuilder.generateServiceIdentityOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ServiceUsageStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<EnableServiceRequest, Operation> enableServiceSettings;
        private final OperationCallSettings.Builder<EnableServiceRequest, Empty, OperationMetadata> enableServiceOperationSettings;
        private final UnaryCallSettings.Builder<DisableServiceRequest, Operation> disableServiceSettings;
        private final OperationCallSettings.Builder<DisableServiceRequest, Empty, OperationMetadata> disableServiceOperationSettings;
        private final UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings;
        private final PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse> listServicesSettings;
        private final UnaryCallSettings.Builder<BatchEnableServicesRequest, Operation> batchEnableServicesSettings;
        private final OperationCallSettings.Builder<BatchEnableServicesRequest, Empty, OperationMetadata> batchEnableServicesOperationSettings;
        private final PagedCallSettings.Builder<ListConsumerQuotaMetricsRequest, ListConsumerQuotaMetricsResponse, ServiceUsageClient.ListConsumerQuotaMetricsPagedResponse> listConsumerQuotaMetricsSettings;
        private final UnaryCallSettings.Builder<GetConsumerQuotaMetricRequest, ConsumerQuotaMetric> getConsumerQuotaMetricSettings;
        private final UnaryCallSettings.Builder<GetConsumerQuotaLimitRequest, ConsumerQuotaLimit> getConsumerQuotaLimitSettings;
        private final UnaryCallSettings.Builder<CreateAdminOverrideRequest, Operation> createAdminOverrideSettings;
        private final OperationCallSettings.Builder<CreateAdminOverrideRequest, QuotaOverride, OperationMetadata> createAdminOverrideOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAdminOverrideRequest, Operation> updateAdminOverrideSettings;
        private final OperationCallSettings.Builder<UpdateAdminOverrideRequest, QuotaOverride, OperationMetadata> updateAdminOverrideOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAdminOverrideRequest, Operation> deleteAdminOverrideSettings;
        private final OperationCallSettings.Builder<DeleteAdminOverrideRequest, Empty, OperationMetadata> deleteAdminOverrideOperationSettings;
        private final PagedCallSettings.Builder<ListAdminOverridesRequest, ListAdminOverridesResponse, ServiceUsageClient.ListAdminOverridesPagedResponse> listAdminOverridesSettings;
        private final UnaryCallSettings.Builder<ImportAdminOverridesRequest, Operation> importAdminOverridesSettings;
        private final OperationCallSettings.Builder<ImportAdminOverridesRequest, ImportAdminOverridesResponse, ImportAdminOverridesMetadata> importAdminOverridesOperationSettings;
        private final UnaryCallSettings.Builder<CreateConsumerOverrideRequest, Operation> createConsumerOverrideSettings;
        private final OperationCallSettings.Builder<CreateConsumerOverrideRequest, QuotaOverride, OperationMetadata> createConsumerOverrideOperationSettings;
        private final UnaryCallSettings.Builder<UpdateConsumerOverrideRequest, Operation> updateConsumerOverrideSettings;
        private final OperationCallSettings.Builder<UpdateConsumerOverrideRequest, QuotaOverride, OperationMetadata> updateConsumerOverrideOperationSettings;
        private final UnaryCallSettings.Builder<DeleteConsumerOverrideRequest, Operation> deleteConsumerOverrideSettings;
        private final OperationCallSettings.Builder<DeleteConsumerOverrideRequest, Empty, OperationMetadata> deleteConsumerOverrideOperationSettings;
        private final PagedCallSettings.Builder<ListConsumerOverridesRequest, ListConsumerOverridesResponse, ServiceUsageClient.ListConsumerOverridesPagedResponse> listConsumerOverridesSettings;
        private final UnaryCallSettings.Builder<ImportConsumerOverridesRequest, Operation> importConsumerOverridesSettings;
        private final OperationCallSettings.Builder<ImportConsumerOverridesRequest, ImportConsumerOverridesResponse, ImportConsumerOverridesMetadata> importConsumerOverridesOperationSettings;
        private final UnaryCallSettings.Builder<GenerateServiceIdentityRequest, Operation> generateServiceIdentitySettings;
        private final OperationCallSettings.Builder<GenerateServiceIdentityRequest, ServiceIdentity, Empty> generateServiceIdentityOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.enableServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableServiceOperationSettings = OperationCallSettings.newBuilder();
            this.disableServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.disableServiceOperationSettings = OperationCallSettings.newBuilder();
            this.getServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICES_PAGE_STR_FACT);
            this.batchEnableServicesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchEnableServicesOperationSettings = OperationCallSettings.newBuilder();
            this.listConsumerQuotaMetricsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONSUMER_QUOTA_METRICS_PAGE_STR_FACT);
            this.getConsumerQuotaMetricSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getConsumerQuotaLimitSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAdminOverrideSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAdminOverrideOperationSettings = OperationCallSettings.newBuilder();
            this.updateAdminOverrideSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAdminOverrideOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAdminOverrideSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAdminOverrideOperationSettings = OperationCallSettings.newBuilder();
            this.listAdminOverridesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ADMIN_OVERRIDES_PAGE_STR_FACT);
            this.importAdminOverridesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importAdminOverridesOperationSettings = OperationCallSettings.newBuilder();
            this.createConsumerOverrideSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConsumerOverrideOperationSettings = OperationCallSettings.newBuilder();
            this.updateConsumerOverrideSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConsumerOverrideOperationSettings = OperationCallSettings.newBuilder();
            this.deleteConsumerOverrideSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConsumerOverrideOperationSettings = OperationCallSettings.newBuilder();
            this.listConsumerOverridesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONSUMER_OVERRIDES_PAGE_STR_FACT);
            this.importConsumerOverridesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importConsumerOverridesOperationSettings = OperationCallSettings.newBuilder();
            this.generateServiceIdentitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateServiceIdentityOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.enableServiceSettings, this.disableServiceSettings, this.getServiceSettings, this.listServicesSettings, this.batchEnableServicesSettings, this.listConsumerQuotaMetricsSettings, this.getConsumerQuotaMetricSettings, this.getConsumerQuotaLimitSettings, this.createAdminOverrideSettings, this.updateAdminOverrideSettings, this.deleteAdminOverrideSettings, this.listAdminOverridesSettings, (Object[])new UnaryCallSettings.Builder[]{this.importAdminOverridesSettings, this.createConsumerOverrideSettings, this.updateConsumerOverrideSettings, this.deleteConsumerOverrideSettings, this.listConsumerOverridesSettings, this.importConsumerOverridesSettings, this.generateServiceIdentitySettings});
            Builder.initDefaults(this);
        }

        protected Builder(ServiceUsageStubSettings settings) {
            super((StubSettings)settings);
            this.enableServiceSettings = settings.enableServiceSettings.toBuilder();
            this.enableServiceOperationSettings = settings.enableServiceOperationSettings.toBuilder();
            this.disableServiceSettings = settings.disableServiceSettings.toBuilder();
            this.disableServiceOperationSettings = settings.disableServiceOperationSettings.toBuilder();
            this.getServiceSettings = settings.getServiceSettings.toBuilder();
            this.listServicesSettings = settings.listServicesSettings.toBuilder();
            this.batchEnableServicesSettings = settings.batchEnableServicesSettings.toBuilder();
            this.batchEnableServicesOperationSettings = settings.batchEnableServicesOperationSettings.toBuilder();
            this.listConsumerQuotaMetricsSettings = settings.listConsumerQuotaMetricsSettings.toBuilder();
            this.getConsumerQuotaMetricSettings = settings.getConsumerQuotaMetricSettings.toBuilder();
            this.getConsumerQuotaLimitSettings = settings.getConsumerQuotaLimitSettings.toBuilder();
            this.createAdminOverrideSettings = settings.createAdminOverrideSettings.toBuilder();
            this.createAdminOverrideOperationSettings = settings.createAdminOverrideOperationSettings.toBuilder();
            this.updateAdminOverrideSettings = settings.updateAdminOverrideSettings.toBuilder();
            this.updateAdminOverrideOperationSettings = settings.updateAdminOverrideOperationSettings.toBuilder();
            this.deleteAdminOverrideSettings = settings.deleteAdminOverrideSettings.toBuilder();
            this.deleteAdminOverrideOperationSettings = settings.deleteAdminOverrideOperationSettings.toBuilder();
            this.listAdminOverridesSettings = settings.listAdminOverridesSettings.toBuilder();
            this.importAdminOverridesSettings = settings.importAdminOverridesSettings.toBuilder();
            this.importAdminOverridesOperationSettings = settings.importAdminOverridesOperationSettings.toBuilder();
            this.createConsumerOverrideSettings = settings.createConsumerOverrideSettings.toBuilder();
            this.createConsumerOverrideOperationSettings = settings.createConsumerOverrideOperationSettings.toBuilder();
            this.updateConsumerOverrideSettings = settings.updateConsumerOverrideSettings.toBuilder();
            this.updateConsumerOverrideOperationSettings = settings.updateConsumerOverrideOperationSettings.toBuilder();
            this.deleteConsumerOverrideSettings = settings.deleteConsumerOverrideSettings.toBuilder();
            this.deleteConsumerOverrideOperationSettings = settings.deleteConsumerOverrideOperationSettings.toBuilder();
            this.listConsumerOverridesSettings = settings.listConsumerOverridesSettings.toBuilder();
            this.importConsumerOverridesSettings = settings.importConsumerOverridesSettings.toBuilder();
            this.importConsumerOverridesOperationSettings = settings.importConsumerOverridesOperationSettings.toBuilder();
            this.generateServiceIdentitySettings = settings.generateServiceIdentitySettings.toBuilder();
            this.generateServiceIdentityOperationSettings = settings.generateServiceIdentityOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.enableServiceSettings, this.disableServiceSettings, this.getServiceSettings, this.listServicesSettings, this.batchEnableServicesSettings, this.listConsumerQuotaMetricsSettings, this.getConsumerQuotaMetricSettings, this.getConsumerQuotaLimitSettings, this.createAdminOverrideSettings, this.updateAdminOverrideSettings, this.deleteAdminOverrideSettings, this.listAdminOverridesSettings, (Object[])new UnaryCallSettings.Builder[]{this.importAdminOverridesSettings, this.createConsumerOverrideSettings, this.updateConsumerOverrideSettings, this.deleteConsumerOverrideSettings, this.listConsumerOverridesSettings, this.importConsumerOverridesSettings, this.generateServiceIdentitySettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ServiceUsageStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ServiceUsageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServiceUsageStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServiceUsageStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ServiceUsageStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ServiceUsageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServiceUsageStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServiceUsageStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.enableServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.disableServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.batchEnableServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listConsumerQuotaMetricsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getConsumerQuotaMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getConsumerQuotaLimitSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createAdminOverrideSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateAdminOverrideSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteAdminOverrideSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listAdminOverridesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.importAdminOverridesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createConsumerOverrideSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateConsumerOverrideSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteConsumerOverrideSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listConsumerOverridesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.importConsumerOverridesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.generateServiceIdentitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.enableServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.disableServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchEnableServicesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createAdminOverrideOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(QuotaOverride.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAdminOverrideOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(QuotaOverride.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAdminOverrideOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importAdminOverridesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportAdminOverridesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportAdminOverridesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createConsumerOverrideOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(QuotaOverride.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateConsumerOverrideOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(QuotaOverride.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteConsumerOverrideOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importConsumerOverridesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportConsumerOverridesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportConsumerOverridesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.generateServiceIdentityOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServiceIdentity.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        @Deprecated
        public UnaryCallSettings.Builder<EnableServiceRequest, Operation> enableServiceSettings() {
            return this.enableServiceSettings;
        }

        public OperationCallSettings.Builder<EnableServiceRequest, Empty, OperationMetadata> enableServiceOperationSettings() {
            return this.enableServiceOperationSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<DisableServiceRequest, Operation> disableServiceSettings() {
            return this.disableServiceSettings;
        }

        public OperationCallSettings.Builder<DisableServiceRequest, Empty, OperationMetadata> disableServiceOperationSettings() {
            return this.disableServiceOperationSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings() {
            return this.getServiceSettings;
        }

        @Deprecated
        public PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse> listServicesSettings() {
            return this.listServicesSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<BatchEnableServicesRequest, Operation> batchEnableServicesSettings() {
            return this.batchEnableServicesSettings;
        }

        public OperationCallSettings.Builder<BatchEnableServicesRequest, Empty, OperationMetadata> batchEnableServicesOperationSettings() {
            return this.batchEnableServicesOperationSettings;
        }

        public PagedCallSettings.Builder<ListConsumerQuotaMetricsRequest, ListConsumerQuotaMetricsResponse, ServiceUsageClient.ListConsumerQuotaMetricsPagedResponse> listConsumerQuotaMetricsSettings() {
            return this.listConsumerQuotaMetricsSettings;
        }

        public UnaryCallSettings.Builder<GetConsumerQuotaMetricRequest, ConsumerQuotaMetric> getConsumerQuotaMetricSettings() {
            return this.getConsumerQuotaMetricSettings;
        }

        public UnaryCallSettings.Builder<GetConsumerQuotaLimitRequest, ConsumerQuotaLimit> getConsumerQuotaLimitSettings() {
            return this.getConsumerQuotaLimitSettings;
        }

        public UnaryCallSettings.Builder<CreateAdminOverrideRequest, Operation> createAdminOverrideSettings() {
            return this.createAdminOverrideSettings;
        }

        public OperationCallSettings.Builder<CreateAdminOverrideRequest, QuotaOverride, OperationMetadata> createAdminOverrideOperationSettings() {
            return this.createAdminOverrideOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAdminOverrideRequest, Operation> updateAdminOverrideSettings() {
            return this.updateAdminOverrideSettings;
        }

        public OperationCallSettings.Builder<UpdateAdminOverrideRequest, QuotaOverride, OperationMetadata> updateAdminOverrideOperationSettings() {
            return this.updateAdminOverrideOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAdminOverrideRequest, Operation> deleteAdminOverrideSettings() {
            return this.deleteAdminOverrideSettings;
        }

        public OperationCallSettings.Builder<DeleteAdminOverrideRequest, Empty, OperationMetadata> deleteAdminOverrideOperationSettings() {
            return this.deleteAdminOverrideOperationSettings;
        }

        public PagedCallSettings.Builder<ListAdminOverridesRequest, ListAdminOverridesResponse, ServiceUsageClient.ListAdminOverridesPagedResponse> listAdminOverridesSettings() {
            return this.listAdminOverridesSettings;
        }

        public UnaryCallSettings.Builder<ImportAdminOverridesRequest, Operation> importAdminOverridesSettings() {
            return this.importAdminOverridesSettings;
        }

        public OperationCallSettings.Builder<ImportAdminOverridesRequest, ImportAdminOverridesResponse, ImportAdminOverridesMetadata> importAdminOverridesOperationSettings() {
            return this.importAdminOverridesOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateConsumerOverrideRequest, Operation> createConsumerOverrideSettings() {
            return this.createConsumerOverrideSettings;
        }

        public OperationCallSettings.Builder<CreateConsumerOverrideRequest, QuotaOverride, OperationMetadata> createConsumerOverrideOperationSettings() {
            return this.createConsumerOverrideOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateConsumerOverrideRequest, Operation> updateConsumerOverrideSettings() {
            return this.updateConsumerOverrideSettings;
        }

        public OperationCallSettings.Builder<UpdateConsumerOverrideRequest, QuotaOverride, OperationMetadata> updateConsumerOverrideOperationSettings() {
            return this.updateConsumerOverrideOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteConsumerOverrideRequest, Operation> deleteConsumerOverrideSettings() {
            return this.deleteConsumerOverrideSettings;
        }

        public OperationCallSettings.Builder<DeleteConsumerOverrideRequest, Empty, OperationMetadata> deleteConsumerOverrideOperationSettings() {
            return this.deleteConsumerOverrideOperationSettings;
        }

        public PagedCallSettings.Builder<ListConsumerOverridesRequest, ListConsumerOverridesResponse, ServiceUsageClient.ListConsumerOverridesPagedResponse> listConsumerOverridesSettings() {
            return this.listConsumerOverridesSettings;
        }

        public UnaryCallSettings.Builder<ImportConsumerOverridesRequest, Operation> importConsumerOverridesSettings() {
            return this.importConsumerOverridesSettings;
        }

        public OperationCallSettings.Builder<ImportConsumerOverridesRequest, ImportConsumerOverridesResponse, ImportConsumerOverridesMetadata> importConsumerOverridesOperationSettings() {
            return this.importConsumerOverridesOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateServiceIdentityRequest, Operation> generateServiceIdentitySettings() {
            return this.generateServiceIdentitySettings;
        }

        public OperationCallSettings.Builder<GenerateServiceIdentityRequest, ServiceIdentity, Empty> generateServiceIdentityOperationSettings() {
            return this.generateServiceIdentityOperationSettings;
        }

        public ServiceUsageStubSettings build() throws IOException {
            return new ServiceUsageStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setTotalTimeout(Duration.ofMillis((long)5000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

