/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.CreateWorkerPoolRequest;
import com.google.cloud.run.v2.DeleteWorkerPoolRequest;
import com.google.cloud.run.v2.GetWorkerPoolRequest;
import com.google.cloud.run.v2.ListWorkerPoolsRequest;
import com.google.cloud.run.v2.ListWorkerPoolsResponse;
import com.google.cloud.run.v2.UpdateWorkerPoolRequest;
import com.google.cloud.run.v2.WorkerPool;
import com.google.cloud.run.v2.WorkerPoolsClient;
import com.google.cloud.run.v2.stub.GrpcWorkerPoolsStub;
import com.google.cloud.run.v2.stub.HttpJsonWorkerPoolsStub;
import com.google.cloud.run.v2.stub.WorkerPoolsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class WorkerPoolsStubSettings
extends StubSettings<WorkerPoolsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateWorkerPoolRequest, Operation> createWorkerPoolSettings;
    private final OperationCallSettings<CreateWorkerPoolRequest, WorkerPool, WorkerPool> createWorkerPoolOperationSettings;
    private final UnaryCallSettings<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings;
    private final PagedCallSettings<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPoolsClient.ListWorkerPoolsPagedResponse> listWorkerPoolsSettings;
    private final UnaryCallSettings<UpdateWorkerPoolRequest, Operation> updateWorkerPoolSettings;
    private final OperationCallSettings<UpdateWorkerPoolRequest, WorkerPool, WorkerPool> updateWorkerPoolOperationSettings;
    private final UnaryCallSettings<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolSettings;
    private final OperationCallSettings<DeleteWorkerPoolRequest, WorkerPool, WorkerPool> deleteWorkerPoolOperationSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool> LIST_WORKER_POOLS_PAGE_STR_DESC = new PagedListDescriptor<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkerPoolsRequest injectToken(ListWorkerPoolsRequest payload, String token) {
            return ListWorkerPoolsRequest.newBuilder((ListWorkerPoolsRequest)payload).setPageToken(token).build();
        }

        public ListWorkerPoolsRequest injectPageSize(ListWorkerPoolsRequest payload, int pageSize) {
            return ListWorkerPoolsRequest.newBuilder((ListWorkerPoolsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkerPoolsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkerPoolsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<WorkerPool> extractResources(ListWorkerPoolsResponse payload) {
            return payload.getWorkerPoolsList();
        }
    };
    private static final PagedListResponseFactory<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPoolsClient.ListWorkerPoolsPagedResponse> LIST_WORKER_POOLS_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPoolsClient.ListWorkerPoolsPagedResponse>(){

        public ApiFuture<WorkerPoolsClient.ListWorkerPoolsPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> callable, ListWorkerPoolsRequest request, ApiCallContext context, ApiFuture<ListWorkerPoolsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKER_POOLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WorkerPoolsClient.ListWorkerPoolsPagedResponse.createAsync((PageContext<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateWorkerPoolRequest, Operation> createWorkerPoolSettings() {
        return this.createWorkerPoolSettings;
    }

    public OperationCallSettings<CreateWorkerPoolRequest, WorkerPool, WorkerPool> createWorkerPoolOperationSettings() {
        return this.createWorkerPoolOperationSettings;
    }

    public UnaryCallSettings<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings() {
        return this.getWorkerPoolSettings;
    }

    public PagedCallSettings<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPoolsClient.ListWorkerPoolsPagedResponse> listWorkerPoolsSettings() {
        return this.listWorkerPoolsSettings;
    }

    public UnaryCallSettings<UpdateWorkerPoolRequest, Operation> updateWorkerPoolSettings() {
        return this.updateWorkerPoolSettings;
    }

    public OperationCallSettings<UpdateWorkerPoolRequest, WorkerPool, WorkerPool> updateWorkerPoolOperationSettings() {
        return this.updateWorkerPoolOperationSettings;
    }

    public UnaryCallSettings<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolSettings() {
        return this.deleteWorkerPoolSettings;
    }

    public OperationCallSettings<DeleteWorkerPoolRequest, WorkerPool, WorkerPool> deleteWorkerPoolOperationSettings() {
        return this.deleteWorkerPoolOperationSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public WorkerPoolsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcWorkerPoolsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonWorkerPoolsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "run";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "run.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "run.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return WorkerPoolsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WorkerPoolsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WorkerPoolsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return WorkerPoolsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected WorkerPoolsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createWorkerPoolSettings = settingsBuilder.createWorkerPoolSettings().build();
        this.createWorkerPoolOperationSettings = settingsBuilder.createWorkerPoolOperationSettings().build();
        this.getWorkerPoolSettings = settingsBuilder.getWorkerPoolSettings().build();
        this.listWorkerPoolsSettings = settingsBuilder.listWorkerPoolsSettings().build();
        this.updateWorkerPoolSettings = settingsBuilder.updateWorkerPoolSettings().build();
        this.updateWorkerPoolOperationSettings = settingsBuilder.updateWorkerPoolOperationSettings().build();
        this.deleteWorkerPoolSettings = settingsBuilder.deleteWorkerPoolSettings().build();
        this.deleteWorkerPoolOperationSettings = settingsBuilder.deleteWorkerPoolOperationSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<WorkerPoolsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateWorkerPoolRequest, Operation> createWorkerPoolSettings;
        private final OperationCallSettings.Builder<CreateWorkerPoolRequest, WorkerPool, WorkerPool> createWorkerPoolOperationSettings;
        private final UnaryCallSettings.Builder<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings;
        private final PagedCallSettings.Builder<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPoolsClient.ListWorkerPoolsPagedResponse> listWorkerPoolsSettings;
        private final UnaryCallSettings.Builder<UpdateWorkerPoolRequest, Operation> updateWorkerPoolSettings;
        private final OperationCallSettings.Builder<UpdateWorkerPoolRequest, WorkerPool, WorkerPool> updateWorkerPoolOperationSettings;
        private final UnaryCallSettings.Builder<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolSettings;
        private final OperationCallSettings.Builder<DeleteWorkerPoolRequest, WorkerPool, WorkerPool> deleteWorkerPoolOperationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkerPoolOperationSettings = OperationCallSettings.newBuilder();
            this.getWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkerPoolsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKER_POOLS_PAGE_STR_FACT);
            this.updateWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWorkerPoolOperationSettings = OperationCallSettings.newBuilder();
            this.deleteWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWorkerPoolOperationSettings = OperationCallSettings.newBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createWorkerPoolSettings, this.getWorkerPoolSettings, this.listWorkerPoolsSettings, this.updateWorkerPoolSettings, this.deleteWorkerPoolSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(WorkerPoolsStubSettings settings) {
            super((StubSettings)settings);
            this.createWorkerPoolSettings = settings.createWorkerPoolSettings.toBuilder();
            this.createWorkerPoolOperationSettings = settings.createWorkerPoolOperationSettings.toBuilder();
            this.getWorkerPoolSettings = settings.getWorkerPoolSettings.toBuilder();
            this.listWorkerPoolsSettings = settings.listWorkerPoolsSettings.toBuilder();
            this.updateWorkerPoolSettings = settings.updateWorkerPoolSettings.toBuilder();
            this.updateWorkerPoolOperationSettings = settings.updateWorkerPoolOperationSettings.toBuilder();
            this.deleteWorkerPoolSettings = settings.deleteWorkerPoolSettings.toBuilder();
            this.deleteWorkerPoolOperationSettings = settings.deleteWorkerPoolOperationSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createWorkerPoolSettings, this.getWorkerPoolSettings, this.listWorkerPoolsSettings, this.updateWorkerPoolSettings, this.deleteWorkerPoolSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(WorkerPoolsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)WorkerPoolsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WorkerPoolsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(WorkerPoolsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)WorkerPoolsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)WorkerPoolsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WorkerPoolsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(WorkerPoolsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listWorkerPoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createWorkerPoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkerPool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(WorkerPool.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateWorkerPoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkerPool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(WorkerPool.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteWorkerPoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkerPool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(WorkerPool.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateWorkerPoolRequest, Operation> createWorkerPoolSettings() {
            return this.createWorkerPoolSettings;
        }

        public OperationCallSettings.Builder<CreateWorkerPoolRequest, WorkerPool, WorkerPool> createWorkerPoolOperationSettings() {
            return this.createWorkerPoolOperationSettings;
        }

        public UnaryCallSettings.Builder<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings() {
            return this.getWorkerPoolSettings;
        }

        public PagedCallSettings.Builder<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPoolsClient.ListWorkerPoolsPagedResponse> listWorkerPoolsSettings() {
            return this.listWorkerPoolsSettings;
        }

        public UnaryCallSettings.Builder<UpdateWorkerPoolRequest, Operation> updateWorkerPoolSettings() {
            return this.updateWorkerPoolSettings;
        }

        public OperationCallSettings.Builder<UpdateWorkerPoolRequest, WorkerPool, WorkerPool> updateWorkerPoolOperationSettings() {
            return this.updateWorkerPoolOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolSettings() {
            return this.deleteWorkerPoolSettings;
        }

        public OperationCallSettings.Builder<DeleteWorkerPoolRequest, WorkerPool, WorkerPool> deleteWorkerPoolOperationSettings() {
            return this.deleteWorkerPoolOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public WorkerPoolsStubSettings build() throws IOException {
            return new WorkerPoolsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

