/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.common.base.Preconditions;
import java.time.Duration;

public final class SubscriberShutdownSettings {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(-1L);
    private static final ShutdownMode DEFAULT_MODE = ShutdownMode.WAIT_FOR_PROCESSING;
    private final ShutdownMode mode;
    private final Duration timeout;

    private SubscriberShutdownSettings(Builder builder) {
        this.mode = builder.mode;
        this.timeout = builder.timeout;
    }

    public ShutdownMode getMode() {
        return this.mode;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ ShutdownMode access$300() {
        return DEFAULT_MODE;
    }

    static /* synthetic */ Duration access$400() {
        return DEFAULT_TIMEOUT;
    }

    public static final class Builder {
        private ShutdownMode mode = SubscriberShutdownSettings.access$300();
        private Duration timeout = SubscriberShutdownSettings.access$400();

        private Builder() {
        }

        public Builder setMode(ShutdownMode mode) {
            this.mode = (ShutdownMode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
            return this;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = (Duration)Preconditions.checkNotNull((Object)timeout);
            return this;
        }

        public SubscriberShutdownSettings build() {
            return new SubscriberShutdownSettings(this);
        }
    }

    public static enum ShutdownMode {
        WAIT_FOR_PROCESSING,
        NACK_IMMEDIATELY;

    }
}

