/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.Context;
import com.google.cloud.dialogflow.v2.ContextName;
import com.google.cloud.dialogflow.v2.ContextsSettings;
import com.google.cloud.dialogflow.v2.CreateContextRequest;
import com.google.cloud.dialogflow.v2.DeleteAllContextsRequest;
import com.google.cloud.dialogflow.v2.DeleteContextRequest;
import com.google.cloud.dialogflow.v2.GetContextRequest;
import com.google.cloud.dialogflow.v2.ListContextsRequest;
import com.google.cloud.dialogflow.v2.ListContextsResponse;
import com.google.cloud.dialogflow.v2.SessionName;
import com.google.cloud.dialogflow.v2.UpdateContextRequest;
import com.google.cloud.dialogflow.v2.stub.ContextsStub;
import com.google.cloud.dialogflow.v2.stub.ContextsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ContextsClient
implements BackgroundResource {
    private final ContextsSettings settings;
    private final ContextsStub stub;

    public static final ContextsClient create() throws IOException {
        return ContextsClient.create(ContextsSettings.newBuilder().build());
    }

    public static final ContextsClient create(ContextsSettings settings) throws IOException {
        return new ContextsClient(settings);
    }

    public static final ContextsClient create(ContextsStub stub) {
        return new ContextsClient(stub);
    }

    protected ContextsClient(ContextsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContextsStubSettings)settings.getStubSettings()).createStub();
    }

    protected ContextsClient(ContextsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ContextsSettings getSettings() {
        return this.settings;
    }

    public ContextsStub getStub() {
        return this.stub;
    }

    public final ListContextsPagedResponse listContexts(SessionName parent) {
        ListContextsRequest request = ListContextsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listContexts(request);
    }

    public final ListContextsPagedResponse listContexts(String parent) {
        ListContextsRequest request = ListContextsRequest.newBuilder().setParent(parent).build();
        return this.listContexts(request);
    }

    public final ListContextsPagedResponse listContexts(ListContextsRequest request) {
        return (ListContextsPagedResponse)((Object)this.listContextsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListContextsRequest, ListContextsPagedResponse> listContextsPagedCallable() {
        return this.stub.listContextsPagedCallable();
    }

    public final UnaryCallable<ListContextsRequest, ListContextsResponse> listContextsCallable() {
        return this.stub.listContextsCallable();
    }

    public final Context getContext(ContextName name) {
        GetContextRequest request = GetContextRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getContext(request);
    }

    public final Context getContext(String name) {
        GetContextRequest request = GetContextRequest.newBuilder().setName(name).build();
        return this.getContext(request);
    }

    public final Context getContext(GetContextRequest request) {
        return (Context)this.getContextCallable().call((Object)request);
    }

    public final UnaryCallable<GetContextRequest, Context> getContextCallable() {
        return this.stub.getContextCallable();
    }

    public final Context createContext(SessionName parent, Context context) {
        CreateContextRequest request = CreateContextRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setContext(context).build();
        return this.createContext(request);
    }

    public final Context createContext(String parent, Context context) {
        CreateContextRequest request = CreateContextRequest.newBuilder().setParent(parent).setContext(context).build();
        return this.createContext(request);
    }

    public final Context createContext(CreateContextRequest request) {
        return (Context)this.createContextCallable().call((Object)request);
    }

    public final UnaryCallable<CreateContextRequest, Context> createContextCallable() {
        return this.stub.createContextCallable();
    }

    public final Context updateContext(Context context, FieldMask updateMask) {
        UpdateContextRequest request = UpdateContextRequest.newBuilder().setContext(context).setUpdateMask(updateMask).build();
        return this.updateContext(request);
    }

    public final Context updateContext(UpdateContextRequest request) {
        return (Context)this.updateContextCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateContextRequest, Context> updateContextCallable() {
        return this.stub.updateContextCallable();
    }

    public final void deleteContext(ContextName name) {
        DeleteContextRequest request = DeleteContextRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteContext(request);
    }

    public final void deleteContext(String name) {
        DeleteContextRequest request = DeleteContextRequest.newBuilder().setName(name).build();
        this.deleteContext(request);
    }

    public final void deleteContext(DeleteContextRequest request) {
        this.deleteContextCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteContextRequest, Empty> deleteContextCallable() {
        return this.stub.deleteContextCallable();
    }

    public final void deleteAllContexts(SessionName parent) {
        DeleteAllContextsRequest request = DeleteAllContextsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        this.deleteAllContexts(request);
    }

    public final void deleteAllContexts(String parent) {
        DeleteAllContextsRequest request = DeleteAllContextsRequest.newBuilder().setParent(parent).build();
        this.deleteAllContexts(request);
    }

    public final void deleteAllContexts(DeleteAllContextsRequest request) {
        this.deleteAllContextsCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAllContextsRequest, Empty> deleteAllContextsCallable() {
        return this.stub.deleteAllContextsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListContextsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListContextsRequest, ListContextsResponse, Context, ListContextsPage, ListContextsFixedSizeCollection> {
        private ListContextsFixedSizeCollection(List<ListContextsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListContextsFixedSizeCollection createEmptyCollection() {
            return new ListContextsFixedSizeCollection(null, 0);
        }

        protected ListContextsFixedSizeCollection createCollection(List<ListContextsPage> pages, int collectionSize) {
            return new ListContextsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListContextsPage
    extends AbstractPage<ListContextsRequest, ListContextsResponse, Context, ListContextsPage> {
        private ListContextsPage(PageContext<ListContextsRequest, ListContextsResponse, Context> context, ListContextsResponse response) {
            super(context, (Object)response);
        }

        private static ListContextsPage createEmptyPage() {
            return new ListContextsPage(null, null);
        }

        protected ListContextsPage createPage(PageContext<ListContextsRequest, ListContextsResponse, Context> context, ListContextsResponse response) {
            return new ListContextsPage(context, response);
        }

        public ApiFuture<ListContextsPage> createPageAsync(PageContext<ListContextsRequest, ListContextsResponse, Context> context, ApiFuture<ListContextsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListContextsPagedResponse
    extends AbstractPagedListResponse<ListContextsRequest, ListContextsResponse, Context, ListContextsPage, ListContextsFixedSizeCollection> {
        public static ApiFuture<ListContextsPagedResponse> createAsync(PageContext<ListContextsRequest, ListContextsResponse, Context> context, ApiFuture<ListContextsResponse> futureResponse) {
            ApiFuture<ListContextsPage> futurePage = ListContextsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListContextsPagedResponse((ListContextsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListContextsPagedResponse(ListContextsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListContextsFixedSizeCollection.createEmptyCollection());
        }
    }
}

