/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.BetaApi;
import com.google.cloud.datastore.BaseKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.PathElement;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.PartitionId;
import java.util.List;

public class IncompleteKey
extends BaseKey {
    private static final long serialVersionUID = 4947014765344279019L;

    IncompleteKey(String projectId, String namespace, ImmutableList<PathElement> path) {
        super(projectId, namespace, path);
    }

    IncompleteKey(String projectId, String namespace, String databaseId, ImmutableList<PathElement> path) {
        super(projectId, namespace, databaseId, path);
    }

    static IncompleteKey fromPb(com.google.datastore.v1.Key keyPb) {
        List pathElementsPb;
        String projectId = "";
        String namespace = "";
        String databaseId = "";
        if (keyPb.hasPartitionId()) {
            PartitionId partitionIdPb = keyPb.getPartitionId();
            projectId = partitionIdPb.getProjectId();
            namespace = partitionIdPb.getNamespaceId();
            databaseId = partitionIdPb.getDatabaseId();
        }
        Preconditions.checkArgument((!(pathElementsPb = keyPb.getPathList()).isEmpty() ? 1 : 0) != 0, (Object)"Path must not be empty");
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        for (Key.PathElement pathElementPb : pathElementsPb) {
            pathBuilder.add((Object)PathElement.fromPb(pathElementPb));
        }
        ImmutableList path = pathBuilder.build();
        PathElement leaf = (PathElement)path.get(path.size() - 1);
        if (leaf.getNameOrId() != null) {
            return new Key(projectId, namespace, databaseId, (ImmutableList<PathElement>)path);
        }
        return new IncompleteKey(projectId, namespace, databaseId, (ImmutableList<PathElement>)path);
    }

    @Override
    public Key getParent() {
        List<PathElement> ancestors = this.getAncestors();
        if (ancestors.isEmpty()) {
            return null;
        }
        PathElement parent = ancestors.get(ancestors.size() - 1);
        Key.Builder keyBuilder = parent.hasName() ? Key.newBuilder(this.getProjectId(), parent.getKind(), parent.getName()) : Key.newBuilder(this.getProjectId(), parent.getKind(), (long)parent.getId());
        String namespace = this.getNamespace();
        if (namespace != null) {
            keyBuilder.setNamespace(namespace);
        }
        return ((Key.Builder)keyBuilder.addAncestors(ancestors.subList(0, ancestors.size() - 1))).build();
    }

    public static Builder newBuilder(String projectId, String kind) {
        return new Builder(projectId, kind);
    }

    @BetaApi
    public static Builder newBuilderWithDatabaseId(String projectId, String kind, String databaseId) {
        return new Builder(projectId, kind, databaseId);
    }

    public static Builder newBuilder(IncompleteKey copyFrom) {
        return new Builder(copyFrom);
    }

    public static Builder newBuilder(Key parent, String kind) {
        return (Builder)((Builder)IncompleteKey.newBuilderWithDatabaseId(parent.getProjectId(), kind, parent.getDatabaseId()).setNamespace(parent.getNamespace())).addAncestors(parent.getPath());
    }

    public static class Builder
    extends BaseKey.Builder<Builder> {
        private Builder(String projectId, String kind) {
            super(projectId, kind);
        }

        private Builder(String projectId, String kind, String databaseId) {
            super(projectId, kind);
            this.databaseId = databaseId;
        }

        private Builder(IncompleteKey copyFrom) {
            super(copyFrom);
        }

        @Override
        public IncompleteKey build() {
            ImmutableList path = ImmutableList.builder().addAll((Iterable)this.ancestors).add((Object)PathElement.of(this.kind)).build();
            return new IncompleteKey(this.projectId, this.namespace, this.databaseId, (ImmutableList<PathElement>)path);
        }
    }
}

