/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataflow.v1beta3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.dataflow.v1beta3.CheckActiveJobsRequest;
import com.google.dataflow.v1beta3.CheckActiveJobsResponse;
import com.google.dataflow.v1beta3.CreateJobRequest;
import com.google.dataflow.v1beta3.GetJobRequest;
import com.google.dataflow.v1beta3.Job;
import com.google.dataflow.v1beta3.JobsV1Beta3Client;
import com.google.dataflow.v1beta3.ListJobsRequest;
import com.google.dataflow.v1beta3.ListJobsResponse;
import com.google.dataflow.v1beta3.Snapshot;
import com.google.dataflow.v1beta3.SnapshotJobRequest;
import com.google.dataflow.v1beta3.UpdateJobRequest;
import com.google.dataflow.v1beta3.stub.GrpcJobsV1Beta3Stub;
import com.google.dataflow.v1beta3.stub.HttpJsonJobsV1Beta3Stub;
import com.google.dataflow.v1beta3.stub.JobsV1Beta3Stub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class JobsV1Beta3StubSettings
extends StubSettings<JobsV1Beta3StubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/userinfo.email").build();
    private final UnaryCallSettings<CreateJobRequest, Job> createJobSettings;
    private final UnaryCallSettings<GetJobRequest, Job> getJobSettings;
    private final UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings;
    private final PagedCallSettings<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.ListJobsPagedResponse> listJobsSettings;
    private final PagedCallSettings<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.AggregatedListJobsPagedResponse> aggregatedListJobsSettings;
    private final UnaryCallSettings<CheckActiveJobsRequest, CheckActiveJobsResponse> checkActiveJobsSettings;
    private final UnaryCallSettings<SnapshotJobRequest, Snapshot> snapshotJobSettings;
    private static final PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job> LIST_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job>(){

        public String emptyToken() {
            return "";
        }

        public ListJobsRequest injectToken(ListJobsRequest payload, String token) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageToken(token).build();
        }

        public ListJobsRequest injectPageSize(ListJobsRequest payload, int pageSize) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Job> extractResources(ListJobsResponse payload) {
            return payload.getJobsList();
        }
    };
    private static final PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job> AGGREGATED_LIST_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job>(){

        public String emptyToken() {
            return "";
        }

        public ListJobsRequest injectToken(ListJobsRequest payload, String token) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageToken(token).build();
        }

        public ListJobsRequest injectPageSize(ListJobsRequest payload, int pageSize) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Job> extractResources(ListJobsResponse payload) {
            return payload.getJobsList();
        }
    };
    private static final PagedListResponseFactory<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.ListJobsPagedResponse> LIST_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.ListJobsPagedResponse>(){

        public ApiFuture<JobsV1Beta3Client.ListJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobsRequest, ListJobsResponse> callable, ListJobsRequest request, ApiCallContext context, ApiFuture<ListJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return JobsV1Beta3Client.ListJobsPagedResponse.createAsync((PageContext<ListJobsRequest, ListJobsResponse, Job>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.AggregatedListJobsPagedResponse> AGGREGATED_LIST_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.AggregatedListJobsPagedResponse>(){

        public ApiFuture<JobsV1Beta3Client.AggregatedListJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobsRequest, ListJobsResponse> callable, ListJobsRequest request, ApiCallContext context, ApiFuture<ListJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return JobsV1Beta3Client.AggregatedListJobsPagedResponse.createAsync((PageContext<ListJobsRequest, ListJobsResponse, Job>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateJobRequest, Job> createJobSettings() {
        return this.createJobSettings;
    }

    public UnaryCallSettings<GetJobRequest, Job> getJobSettings() {
        return this.getJobSettings;
    }

    public UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings() {
        return this.updateJobSettings;
    }

    public PagedCallSettings<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.ListJobsPagedResponse> listJobsSettings() {
        return this.listJobsSettings;
    }

    public PagedCallSettings<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.AggregatedListJobsPagedResponse> aggregatedListJobsSettings() {
        return this.aggregatedListJobsSettings;
    }

    public UnaryCallSettings<CheckActiveJobsRequest, CheckActiveJobsResponse> checkActiveJobsSettings() {
        return this.checkActiveJobsSettings;
    }

    public UnaryCallSettings<SnapshotJobRequest, Snapshot> snapshotJobSettings() {
        return this.snapshotJobSettings;
    }

    public JobsV1Beta3Stub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcJobsV1Beta3Stub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonJobsV1Beta3Stub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dataflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dataflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return JobsV1Beta3StubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(JobsV1Beta3StubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(JobsV1Beta3StubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return JobsV1Beta3StubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected JobsV1Beta3StubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createJobSettings = settingsBuilder.createJobSettings().build();
        this.getJobSettings = settingsBuilder.getJobSettings().build();
        this.updateJobSettings = settingsBuilder.updateJobSettings().build();
        this.listJobsSettings = settingsBuilder.listJobsSettings().build();
        this.aggregatedListJobsSettings = settingsBuilder.aggregatedListJobsSettings().build();
        this.checkActiveJobsSettings = settingsBuilder.checkActiveJobsSettings().build();
        this.snapshotJobSettings = settingsBuilder.snapshotJobSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<JobsV1Beta3StubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings;
        private final UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings;
        private final UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings;
        private final PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.ListJobsPagedResponse> listJobsSettings;
        private final PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.AggregatedListJobsPagedResponse> aggregatedListJobsSettings;
        private final UnaryCallSettings.Builder<CheckActiveJobsRequest, CheckActiveJobsResponse> checkActiveJobsSettings;
        private final UnaryCallSettings.Builder<SnapshotJobRequest, Snapshot> snapshotJobSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOBS_PAGE_STR_FACT);
            this.aggregatedListJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_JOBS_PAGE_STR_FACT);
            this.checkActiveJobsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.snapshotJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createJobSettings, this.getJobSettings, this.updateJobSettings, this.listJobsSettings, this.aggregatedListJobsSettings, this.checkActiveJobsSettings, this.snapshotJobSettings);
            Builder.initDefaults(this);
        }

        protected Builder(JobsV1Beta3StubSettings settings) {
            super((StubSettings)settings);
            this.createJobSettings = settings.createJobSettings.toBuilder();
            this.getJobSettings = settings.getJobSettings.toBuilder();
            this.updateJobSettings = settings.updateJobSettings.toBuilder();
            this.listJobsSettings = settings.listJobsSettings.toBuilder();
            this.aggregatedListJobsSettings = settings.aggregatedListJobsSettings.toBuilder();
            this.checkActiveJobsSettings = settings.checkActiveJobsSettings.toBuilder();
            this.snapshotJobSettings = settings.snapshotJobSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createJobSettings, this.getJobSettings, this.updateJobSettings, this.listJobsSettings, this.aggregatedListJobsSettings, this.checkActiveJobsSettings, this.snapshotJobSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(JobsV1Beta3StubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)JobsV1Beta3StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)JobsV1Beta3StubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(JobsV1Beta3StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)JobsV1Beta3StubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)JobsV1Beta3StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)JobsV1Beta3StubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(JobsV1Beta3StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.aggregatedListJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.checkActiveJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.snapshotJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings() {
            return this.createJobSettings;
        }

        public UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings() {
            return this.getJobSettings;
        }

        public UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings() {
            return this.updateJobSettings;
        }

        public PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.ListJobsPagedResponse> listJobsSettings() {
            return this.listJobsSettings;
        }

        public PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, JobsV1Beta3Client.AggregatedListJobsPagedResponse> aggregatedListJobsSettings() {
            return this.aggregatedListJobsSettings;
        }

        public UnaryCallSettings.Builder<CheckActiveJobsRequest, CheckActiveJobsResponse> checkActiveJobsSettings() {
            return this.checkActiveJobsSettings;
        }

        public UnaryCallSettings.Builder<SnapshotJobRequest, Snapshot> snapshotJobSettings() {
            return this.snapshotJobSettings;
        }

        public JobsV1Beta3StubSettings build() throws IOException {
            return new JobsV1Beta3StubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

