/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AcceleratorType;
import com.google.cloud.compute.v1.AcceleratorTypeAggregatedList;
import com.google.cloud.compute.v1.AcceleratorTypeList;
import com.google.cloud.compute.v1.AcceleratorTypesScopedList;
import com.google.cloud.compute.v1.AcceleratorTypesSettings;
import com.google.cloud.compute.v1.AggregatedListAcceleratorTypesRequest;
import com.google.cloud.compute.v1.GetAcceleratorTypeRequest;
import com.google.cloud.compute.v1.ListAcceleratorTypesRequest;
import com.google.cloud.compute.v1.stub.AcceleratorTypesStub;
import com.google.cloud.compute.v1.stub.AcceleratorTypesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AcceleratorTypesClient
implements BackgroundResource {
    private final AcceleratorTypesSettings settings;
    private final AcceleratorTypesStub stub;

    public static final AcceleratorTypesClient create() throws IOException {
        return AcceleratorTypesClient.create(AcceleratorTypesSettings.newBuilder().build());
    }

    public static final AcceleratorTypesClient create(AcceleratorTypesSettings settings) throws IOException {
        return new AcceleratorTypesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AcceleratorTypesClient create(AcceleratorTypesStub stub) {
        return new AcceleratorTypesClient(stub);
    }

    protected AcceleratorTypesClient(AcceleratorTypesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AcceleratorTypesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AcceleratorTypesClient(AcceleratorTypesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AcceleratorTypesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AcceleratorTypesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListAcceleratorTypesRequest request = AggregatedListAcceleratorTypesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListAcceleratorTypesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListAcceleratorTypesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final AcceleratorType get(String project, String zone, String acceleratorType) {
        GetAcceleratorTypeRequest request = GetAcceleratorTypeRequest.newBuilder().setProject(project).setZone(zone).setAcceleratorType(acceleratorType).build();
        return this.get(request);
    }

    public final AcceleratorType get(GetAcceleratorTypeRequest request) {
        return (AcceleratorType)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetAcceleratorTypeRequest, AcceleratorType> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListAcceleratorTypesRequest request = ListAcceleratorTypesRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListAcceleratorTypesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAcceleratorTypesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListAcceleratorTypesRequest, AcceleratorTypeList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorType, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorType, ListPage> {
        private ListPage(PageContext<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorType> context, AcceleratorTypeList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorType> context, AcceleratorTypeList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorType> context, ApiFuture<AcceleratorTypeList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorType, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorType> context, ApiFuture<AcceleratorTypeList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, Map.Entry<String, AcceleratorTypesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, Map.Entry<String, AcceleratorTypesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, Map.Entry<String, AcceleratorTypesScopedList>> context, AcceleratorTypeAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, Map.Entry<String, AcceleratorTypesScopedList>> context, AcceleratorTypeAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, Map.Entry<String, AcceleratorTypesScopedList>> context, ApiFuture<AcceleratorTypeAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, Map.Entry<String, AcceleratorTypesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, Map.Entry<String, AcceleratorTypesScopedList>> context, ApiFuture<AcceleratorTypeAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

